/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.impl.shape;

import com.google.common.collect.Lists;
import de.melanx.excavar.api.shape.Matcher;
import de.melanx.excavar.api.shape.Shape;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PlantsShapeless
implements Shape {
    private static final List<BlockPos> CORNER_OFFSETS = Lists.newArrayList((Object[])new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(0, 0, 2), new BlockPos(0, 0, -2), new BlockPos(1, 0, 2), new BlockPos(1, 0, -2), new BlockPos(-1, 0, 2), new BlockPos(-1, 0, -2), new BlockPos(2, 0, 0), new BlockPos(2, 0, 1), new BlockPos(2, 0, -1), new BlockPos(2, 0, 2), new BlockPos(2, 0, -2), new BlockPos(-2, 0, 0), new BlockPos(-2, 0, 1), new BlockPos(-2, 0, -1), new BlockPos(-2, 0, 2), new BlockPos(-2, 0, -2)});

    @Override
    public int addNeighbors(Level level, BlockPos pos, Direction side, BlockState originalState, List<BlockPos> blocksToMine, int stepsLeft) {
        BlockPos.MutableBlockPos newPos = pos.mutable();
        for (Direction value : Direction.Plane.HORIZONTAL) {
            if (stepsLeft > 0) {
                newPos.move(value);
                if (!blocksToMine.contains(newPos) && Matcher.PLANT.test(originalState, level.getBlockState((BlockPos)newPos))) {
                    blocksToMine.add(newPos.immutable());
                    --stepsLeft;
                }
                newPos.set((Vec3i)pos);
                continue;
            }
            return stepsLeft;
        }
        newPos.set((Vec3i)pos);
        for (BlockPos offset : CORNER_OFFSETS) {
            if (stepsLeft <= 0) continue;
            newPos.move((Vec3i)offset);
            if (!blocksToMine.contains(newPos) && Matcher.PLANT.test(originalState, level.getBlockState((BlockPos)newPos))) {
                blocksToMine.add(newPos.immutable());
                --stepsLeft;
            }
            newPos.set((Vec3i)pos);
        }
        return stepsLeft;
    }
}

