/*
 * Decompiled with CFR 0.152.
 */
package indi.yunherry.weather.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import indi.yunherry.weather.renderer.ParticleRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WeatherParticle
extends TextureSheetParticle {
    protected BlockPos.MutableBlockPos pos;
    boolean shouldFadeOut = false;
    float temperature;

    protected WeatherParticle(ClientLevel p_108323_, double p_108324_, double p_108325_, double p_108326_) {
        super(p_108323_, p_108324_, p_108325_, p_108326_);
        this.m_107250_(0.01f, 0.01f);
        this.f_107225_ = Integer.MAX_VALUE;
        this.f_107230_ = 0.0f;
        this.pos = new BlockPos.MutableBlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
        this.temperature = ((Biome)this.f_107208_.m_204166_((BlockPos)this.pos).m_203334_()).m_47554_();
        ++ParticleRenderer.particleCount;
    }

    public void m_5989_() {
        super.m_5989_();
        this.pos.m_122169_(this.f_107212_, this.f_107213_ - 0.2, this.f_107214_);
        if (this.shouldFadeOut) {
            this.fadeOut();
        } else if (this.f_107224_ % 10 == 0) {
            if ((double)Mth.m_14154_((float)(((Biome)this.f_107208_.m_204166_((BlockPos)this.pos).m_203334_()).m_47554_() - this.temperature)) > 0.4) {
                this.shouldFadeOut = true;
            }
        } else {
            this.fadeIn();
        }
    }

    void removeIfOOB() {
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        if (cameraEntity == null || cameraEntity.m_20275_(this.f_107212_, this.f_107213_, this.f_107214_) > (double)Mth.m_144944_((int)25)) {
            this.shouldFadeOut = true;
        }
    }

    public void m_5744_(VertexConsumer p_107678_, Camera p_107679_, float p_107680_) {
        super.m_5744_(p_107678_, p_107679_, p_107680_);
    }

    public void m_107274_() {
        if (this.m_107276_()) {
            --ParticleRenderer.particleCount;
        }
        super.m_107274_();
    }

    public void fadeIn() {
        if (this.f_107224_ < 20) {
            this.f_107230_ = (float)this.f_107224_ * 1.0f / 20.0f;
        }
    }

    public void fadeOut() {
        if ((double)this.f_107230_ < 0.01) {
            this.m_107274_();
        } else {
            this.f_107230_ -= 0.05f;
        }
    }

    protected boolean removeIfObstructed() {
        if (this.f_107212_ == this.f_107209_ || this.f_107214_ == this.f_107211_) {
            this.m_107274_();
            return true;
        }
        return false;
    }

    public Quaternionf flipItTurnwaysIfBackfaced(Quaternionf quaternion, Vector3f toCamera) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)quaternion).normalize();
        float dot = normal.dot((Vector3fc)toCamera);
        if (dot > 0.0f) {
            return quaternion.mul((Quaternionfc)Axis.f_252436_.m_252961_((float)Math.PI));
        }
        return quaternion;
    }

    public static double yLevelWindAdjustment(double y) {
        return org.joml.Math.clamp((double)0.01, (double)1.0, (double)((y - 64.0) / 40.0));
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }
}

