/*
 * Decompiled with CFR 0.152.
 */
package indi.yunherry.weather.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import indi.yunherry.weather.WindDirectionType;
import indi.yunherry.weather.WorldContext;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class WindParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final Quaternionf rotation = new Quaternionf();
    private final Matrix4f transformMatrix = new Matrix4f();
    private final float rotationY;
    public static final ParticleRenderType CUSTOM_SHEET = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager texture) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
            RenderSystem.enableCull();
            RenderSystem.defaultBlendFunc();
        }
    };

    public WindParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet p_107724_) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprites = p_107724_;
        this.m_6569_(20.5f + (float)this.f_107223_.m_188503_(60));
        this.f_107225_ = 50;
        this.f_107219_ = true;
        this.m_107264_(x, y, z);
        this.m_108339_(p_107724_);
        this.m_107271_(0.5f);
        this.rotationY = (switch (WorldContext.windDirection) {
            default -> throw new IncompatibleClassChangeError();
            case WindDirectionType.NORTH -> 0;
            case WindDirectionType.WEST -> 270;
            case WindDirectionType.EAST -> 90;
            case WindDirectionType.SOUTH -> 180;
            case WindDirectionType.NONE -> 114514;
        }) + (this.f_107223_.m_188503_(40) - 20);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return CUSTOM_SHEET;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        if (this.f_107230_ == 0.0f) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 camPos = camera.m_90583_();
        float size = this.m_5902_(partialTicks);
        int packedLight = this.m_6355_(partialTicks);
        float alpha = 1.0f;
        this.rotation.identity().rotateY((float)Math.toRadians(-this.rotationY + 180.0f));
        this.transformMatrix.identity().translation((float)(this.f_107212_ - camPos.f_82479_ + this.f_107215_ * (double)partialTicks), (float)(this.f_107213_ - camPos.f_82480_ + this.f_107216_ * (double)partialTicks), (float)(this.f_107214_ - camPos.f_82481_ + this.f_107217_ * (double)partialTicks)).rotate((Quaternionfc)this.rotation).scale(size);
        this.renderQuad(buffer, packedLight, alpha);
    }

    private void renderQuad(VertexConsumer buffer, int packedLight, float alpha) {
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        buffer.m_252986_(this.transformMatrix, -1.0f, -1.0f, 0.0f).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(this.transformMatrix, -1.0f, 1.0f, 0.0f).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(this.transformMatrix, 1.0f, 1.0f, 0.0f).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(this.transformMatrix, 1.0f, -1.0f, 0.0f).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(packedLight).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet p_107739_) {
            this.sprite = p_107739_;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Random random = new Random();
            int d = random.nextInt(30) + 40;
            double r = random.nextDouble() * Math.PI * 2.0;
            double newY = y + (double)random.nextInt(15) + (double)random.nextInt(15);
            return new WindParticle(world, Math.cos(r) * (double)d + x, newY, Math.sin(r) * (double)d + z, xSpeed, ySpeed, zSpeed, this.sprite);
        }
    }
}

