/*
 * Decompiled with CFR 0.152.
 */
package indi.yunherry.weather.factory.factory;

import indi.yunherry.weather.annotation.ParentMark;
import indi.yunherry.weather.constant.enums.ScanTypeEnum;
import indi.yunherry.weather.exception.InitFactoryException;
import indi.yunherry.weather.utils.ScanClassUntil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public abstract class Factory {
    protected static Map<String, List<ModFileScanData.AnnotationData>> classes;

    public static void initFactory() throws InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        classes = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(item -> {
            Type annotationType = item.annotationType();
            String className = annotationType.getClassName();
            try {
                Class<?> annotationClass = Class.forName(className);
                return annotationClass.isAnnotationPresent(ParentMark.class);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return false;
            }
        }).collect(Collectors.groupingBy(item -> item.annotationType().getClassName()));
        Factory.getFactory();
        try {
            List<Factory> factoryArrayList = Factory.getFactory();
            for (Factory factory : factoryArrayList) {
                factory.create(classes);
            }
        }
        catch (Exception e) {
            throw new InitFactoryException(e);
        }
    }

    private static List<Factory> getFactory() {
        return classes.get("indi.yunherry.weather.annotation.Factory").stream().map(item -> {
            try {
                return (Factory)Class.forName(item.clazz().getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    protected abstract void create(Map<String, List<ModFileScanData.AnnotationData>> var1) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, NoSuchFieldException;

    public <A extends Annotation> void finds(ArrayList<Class<?>> classes, ArrayList<Class<?>> trueList, Class<A> annotation, Class<?> fatherClass, ScanTypeEnum model) {
        Iterator<Class<?>> iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            if (!(model == ScanTypeEnum.SCAN_ONLY_ANNOTATION || model == ScanTypeEnum.SCAN_ONLY_FATHER_CLASS ? (model == ScanTypeEnum.SCAN_ONLY_ANNOTATION ? ScanClassUntil.isSuitableAnnotation(annotation, clazz) : ScanClassUntil.isSuitableClass(clazz, fatherClass)) : ScanClassUntil.isSuitableClass(annotation, clazz, fatherClass))) continue;
            trueList.add(clazz);
            iterator.remove();
        }
    }
}

