/*
 * Decompiled with CFR 0.152.
 */
package indi.yunherry.weather.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import indi.yunherry.weather.WorldContext;
import indi.yunherry.weather.annotation.Renderer;
import indi.yunherry.weather.client.RainParticleQuad;
import indi.yunherry.weather.renderer.WeatherRenderer;
import indi.yunherry.weather.util.ShaderUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

@Renderer
public class RainRenderer
extends WeatherRenderer {
    private final Map<BlockPos, RainParticleQuad> precipitationQuads = new HashMap<BlockPos, RainParticleQuad>();
    private final Map<Biome.Precipitation, List<RainParticleQuad>> quadsByPrecipitation = Maps.newHashMap();
    private static final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    @Override
    public void tick() {
        if (mc == null) {
            return;
        }
        if (!level.m_46471_()) {
            return;
        }
        Biome biome = (Biome)RainRenderer.mc.f_91073_.m_204166_(camPos).m_203334_();
        if (biome.m_264600_(camPos) == Biome.Precipitation.RAIN) {
            float rainIntensity = RainRenderer.mc.f_91073_.m_46722_(0.0f);
            float xRot = 0.21816616f;
            Vector3f direction = new Vector3f(1.0f, 0.0f, 0.0f);
            float yRot = (float)(-Mth.m_14136_((double)direction.x, (double)direction.z));
            float xRotCos = Mth.m_14089_((float)(xRot - 1.5707964f));
            int xOffset = Mth.m_14143_((float)(Mth.m_14031_((float)(-yRot)) * xRotCos * 16.0f));
            int zOffset = Mth.m_14143_((float)(Mth.m_14089_((float)(-yRot)) * xRotCos * 16.0f));
            int radius = Mth.m_14143_((float)(16.0f * (Minecraft.m_91405_() ? 1.0f : 0.5f)));
            int minX = camPos.m_123341_() - radius - xOffset;
            int minY = camPos.m_123342_() + 8;
            int minZ = camPos.m_123343_() - radius - zOffset;
            int maxX = camPos.m_123341_() + radius - xOffset;
            int maxY = camPos.m_123342_() + 32;
            int maxZ = camPos.m_123343_() + radius - zOffset;
            Biome.Precipitation precipitation = biome.m_264600_((BlockPos)pos);
            if (rainIntensity > 0.0f && biome.m_264473_()) {
                for (int x = minX; x < maxX; ++x) {
                    for (int z = minZ; z < maxZ; ++z) {
                        int height = RainRenderer.mc.f_91073_.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
                        for (int y = minY; y < maxY; ++y) {
                            if (height > y) continue;
                            BlockPos pos = new BlockPos(x, y, z);
                            RandomSource blockRandom = RandomSource.m_216335_((long)pos.m_121878_());
                            if (this.precipitationQuads.containsKey(pos) || blockRandom.m_188503_(100) > 1) continue;
                            float widthModifier = 2.0f;
                            RainParticleQuad quad = new RainParticleQuad(precipitation, arg_0 -> ((ClientLevel)RainRenderer.mc.f_91073_).m_45547_(arg_0), pos, xRot + WorldContext.random.m_188501_() * 0.1f, yRot + WorldContext.random.m_188501_() * 0.1f, 60 + WorldContext.random.m_188503_(60), rainIntensity * widthModifier);
                            this.precipitationQuads.put(pos, quad);
                            this.quadsByPrecipitation.computeIfAbsent(precipitation, p -> Lists.newArrayList()).add(quad);
                        }
                    }
                }
            }
            this.precipitationQuads.forEach((key, value) -> {
                ClientLevel levelreader = RainRenderer.mc.f_91073_;
                BlockPos downPos = value.getDownBlockPos();
                if (downPos != null) {
                    BlockState blockstate = levelreader.m_8055_(downPos);
                    FluidState fluidstate = levelreader.m_6425_(downPos);
                    VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)levelreader, downPos);
                    double d0 = WorldContext.random.m_188500_();
                    double d1 = WorldContext.random.m_188500_();
                    double d2 = voxelshape.m_83290_(Direction.Axis.Y, d0, d1);
                    double d3 = fluidstate.m_76155_((BlockGetter)levelreader, downPos);
                    SimpleParticleType particleoptions = !fluidstate.m_205070_(FluidTags.f_13132_) && !blockstate.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockstate) ? ParticleTypes.f_123761_ : ParticleTypes.f_123762_;
                    double surfaceHeight = voxelshape.m_83290_(Direction.Axis.Y, WorldContext.random.m_188500_(), WorldContext.random.m_188500_());
                    double fluidHeight = fluidstate.m_76155_((BlockGetter)levelreader, downPos);
                    double maxSurfaceY = Math.max(surfaceHeight, fluidHeight);
                    double baseX = (double)downPos.m_123341_() + 0.5;
                    double baseY = (double)downPos.m_123342_() + maxSurfaceY;
                    double baseZ = (double)downPos.m_123343_() + 0.5;
                    Direction hitFace = value.getHitDirection();
                    double edgeOffset = 0.3;
                    double randomSpread = 0.4;
                    switch (hitFace) {
                        case UP: {
                            baseX += (WorldContext.random.m_188500_() - 0.5) * 0.4;
                            baseZ += (WorldContext.random.m_188500_() - 0.5) * 0.4;
                            baseY += 0.3;
                            break;
                        }
                        case DOWN: {
                            return;
                        }
                        case NORTH: {
                            baseZ = (double)downPos.m_123343_() - 0.3;
                            baseX += WorldContext.random.m_188500_() * 0.4;
                            break;
                        }
                        case SOUTH: {
                            baseZ = (double)(downPos.m_123343_() + 1) + 0.3;
                            baseX += WorldContext.random.m_188500_() * 0.4;
                            break;
                        }
                        case EAST: {
                            baseX = (double)(downPos.m_123341_() + 1) + 0.3;
                            baseZ += WorldContext.random.m_188500_() * 0.4;
                            break;
                        }
                        case WEST: {
                            baseX = (double)downPos.m_123341_() - 0.3;
                            baseZ += WorldContext.random.m_188500_() * 0.4;
                        }
                    }
                    levelreader.m_7106_((ParticleOptions)particleoptions, baseX, baseY + (hitFace == Direction.UP ? 0.0 : WorldContext.random.m_188500_() * 0.3), baseZ, 0.0, 0.0, 0.0);
                }
            });
        }
    }

    @Override
    public void render() {
    }

    @Override
    public void renderWeather(LightTexture texture, float partialTick, int ticks) {
        float xRot = 0.21816616f;
        Vector3f direction = new Vector3f(1.0f, 0.0f, 0.0f);
        float yRot = (float)(-Mth.m_14136_((double)direction.x, (double)direction.z));
        float xRotCos = Mth.m_14089_((float)(xRot - 1.5707964f));
        int xOffset = Mth.m_14143_((float)(Mth.m_14031_((float)(-yRot)) * xRotCos * 16.0f));
        int zOffset = Mth.m_14143_((float)(Mth.m_14089_((float)(-yRot)) * xRotCos * 16.0f));
        int radius = Mth.m_14143_((float)(16.0f * (Minecraft.m_91405_() ? 1.0f : 0.5f)));
        int minX = camPos.m_123341_() - radius - xOffset;
        int minY = camPos.m_123342_() + 8;
        int minZ = camPos.m_123343_() - radius - zOffset;
        int maxX = camPos.m_123341_() + radius - xOffset;
        int maxY = camPos.m_123342_() + 32;
        int maxZ = camPos.m_123343_() + radius - zOffset;
        AABB box = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        Iterator<Map.Entry<BlockPos, RainParticleQuad>> rain = this.precipitationQuads.entrySet().iterator();
        while (rain.hasNext()) {
            Map.Entry<BlockPos, RainParticleQuad> entry = rain.next();
            RainParticleQuad quad = entry.getValue();
            BlockPos pos = entry.getKey();
            if (!box.m_82393_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) || quad.isDead()) {
                this.quadsByPrecipitation.get(quad.getPrecipitation()).remove(quad);
                rain.remove();
                continue;
            }
            quad.tick();
        }
        if (!level.m_46471_()) {
            return;
        }
        float rainIntensity = RainRenderer.mc.f_91073_.m_46722_(0.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        RenderSystem.depthMask((Minecraft.m_91085_() || ShaderUtils.areShadersRunning() ? 1 : 0) != 0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (!this.quadsByPrecipitation.isEmpty()) {
            texture.m_109896_();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::m_172829_);
            for (Map.Entry<Biome.Precipitation, List<RainParticleQuad>> entry : this.quadsByPrecipitation.entrySet()) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)RainParticleQuad.TEXTURE_BY_PRECIPITATION.get(entry.getKey()));
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                PoseStack stack = new PoseStack();
                stack.m_252880_((float)(-camPos.m_123341_()), (float)(-camPos.m_123342_()), (float)(-camPos.m_123343_()));
                for (RainParticleQuad quad : entry.getValue()) {
                    stack.m_85836_();
                    int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)RainRenderer.mc.f_91073_, (BlockPos)quad.getBlockPos());
                    quad.render(stack, (VertexConsumer)builder, partialTick, packedLight, camPos.m_123341_(), camPos.m_123342_(), camPos.m_123343_(), rainIntensity, ticks);
                    stack.m_85849_();
                }
                tesselator.m_85914_();
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }
}

