/*
 * Decompiled with CFR 0.152.
 */
package indi.yunherry.weather.renderer;

import indi.yunherry.weather.ParticleRegistry;
import indi.yunherry.weather.WorldContext;
import indi.yunherry.weather.annotation.Renderer;
import indi.yunherry.weather.renderer.WeatherRenderer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;

@Renderer
public class SnowRenderer
extends WeatherRenderer {
    private static int PARTICLE_RADIUS = 25;
    private static int MAX_PARTICLES = 80;
    private static double CENTER_BIAS = 2.5;
    private static final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    @Override
    public void renderWeather(LightTexture texture, float partialTick, int ticks) {
    }

    @Override
    public void tick() {
        if (!level.m_46471_()) {
            return;
        }
        Biome biome = (Biome)SnowRenderer.mc.f_91073_.m_204166_(camPos).m_203334_();
        if (biome.m_264600_(camPos) == Biome.Precipitation.SNOW) {
            for (int i = 0; i < MAX_PARTICLES; ++i) {
                double theta = WorldContext.random.m_188500_() * 2.0 * Math.PI;
                double phi = Math.acos(Math.pow(WorldContext.random.m_188500_(), CENTER_BIAS));
                double radius1 = (double)PARTICLE_RADIUS * Math.pow(WorldContext.random.m_188500_(), 0.6);
                double x = radius1 * Math.sin(phi) * Math.cos(theta);
                double z = radius1 * Math.sin(phi) * Math.sin(theta);
                double y = radius1 * Math.cos(phi);
                double posX = x + (double)camPos.m_123341_();
                double posY = y + (double)camPos.m_123342_() + 5.0;
                double posZ = z + (double)camPos.m_123343_();
                if (posY < (double)level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos).m_123342_() || posY > (double)(camPos.m_123342_() + PARTICLE_RADIUS)) continue;
                SnowRenderer.spawnParticle(level, (Holder<Biome>)level.m_204166_((BlockPos)pos), posX, posY + (double)WorldContext.random.m_188501_(), posZ);
            }
        }
    }

    private static void spawnParticle(ClientLevel level, Holder<Biome> biome, double x, double y, double z) {
        if (particleCount > maxParticleCount) {
            return;
        }
        y += 8.0;
        BlockPos getPrecipitationFromBlockPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos);
        if (level.f_46441_.m_188501_() < 0.8f) {
            level.m_7106_((ParticleOptions)ParticleRegistry.SNOW.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void render() {
    }
}

