/*
 * Decompiled with CFR 0.152.
 */
package indi.yunherry.weather.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import indi.yunherry.weather.ParticleRegistry;
import indi.yunherry.weather.WeatherType;
import indi.yunherry.weather.WorldContext;
import indi.yunherry.weather.client.RainParticleQuad;
import indi.yunherry.weather.renderer.ParticleRenderer;
import indi.yunherry.weather.util.ShaderUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class WeatherRenderer$backup
extends ParticleRenderer {
    private static final double AREA_HALF = 32.0;
    private static final double BASE_HEIGHT = 100.0;
    private static final double HEIGHT_VARIATION = 16.0;
    private static final int MAX_PARTICLES = 2;
    private static final double DENSITY_POWER = 2.0;
    public static WeatherRenderer$backup instance = new WeatherRenderer$backup();
    private Minecraft mc = Minecraft.m_91087_();
    public static final Map<Biome.Precipitation, ResourceLocation> TEXTURE_BY_PRECIPITATION = (Map)Util.m_137537_(() -> {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)Biome.Precipitation.RAIN, (Object)new ResourceLocation("textures/environment/rain.png"));
        map.put((Object)Biome.Precipitation.SNOW, (Object)new ResourceLocation("textures/environment/snow.png"));
        return map.build();
    });
    private static final int HASH_MASK = 65535;
    private static final float RAIN_SIZE_SCALE = 0.1f;
    private final Map<BlockPos, RainParticleQuad> precipitationQuads = new HashMap<BlockPos, RainParticleQuad>();
    private final Map<Biome.Precipitation, List<RainParticleQuad>> quadsByPrecipitation = Maps.newHashMap();
    private static final RandomSource random = RandomSource.m_216327_();
    private static final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    public Map<BlockPos, RainParticleQuad> getPrecipitationQuads() {
        return this.precipitationQuads;
    }

    public Map<Biome.Precipitation, List<RainParticleQuad>> getQuadsByPrecipitation() {
        return this.quadsByPrecipitation;
    }

    @Deprecated(since="v1.5")
    public void renderWeather(LightTexture texture, float partialTick, double camX, double camY, double camZ, int ticks) {
        float rainIntensity = this.mc.f_91073_.m_46722_(0.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        RenderSystem.depthMask((Minecraft.m_91085_() || ShaderUtils.areShadersRunning() ? 1 : 0) != 0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (!this.quadsByPrecipitation.isEmpty()) {
            texture.m_109896_();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::m_172829_);
            for (Map.Entry<Biome.Precipitation, List<RainParticleQuad>> entry : this.quadsByPrecipitation.entrySet()) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)RainParticleQuad.TEXTURE_BY_PRECIPITATION.get(entry.getKey()));
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                PoseStack stack = new PoseStack();
                stack.m_85837_(-camX, -camY, -camZ);
                for (RainParticleQuad quad : entry.getValue()) {
                    stack.m_85836_();
                    int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)this.mc.f_91073_, (BlockPos)quad.getBlockPos());
                    quad.render(stack, (VertexConsumer)builder, partialTick, packedLight, camX, camY, camZ, rainIntensity, ticks);
                    stack.m_85849_();
                }
                tesselator.m_85914_();
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private static void startEasing(float currentAngle) {
        WorldContext.isEasing = true;
        WorldContext.easeStartAngle = currentAngle;
        WorldContext.easeTargetAngle = currentAngle + (float)(random.m_188499_() ? 1 : -1) * random.m_188501_() * 30.0f;
        WorldContext.easeDuration = Mth.m_216271_((RandomSource)random, (int)20, (int)40);
        WorldContext.easeTimer = 0;
    }

    private static void updateEasing(float partialTicks) {
        if ((WorldContext.easeTimer = (int)((float)WorldContext.easeTimer + partialTicks)) >= WorldContext.easeDuration) {
            WorldContext.isEasing = false;
        }
    }

    @Override
    public void tick() {
        if (WorldContext.nowWeather == WeatherType.NONE) {
            return;
        }
        if (WorldContext.nowWeather == WeatherType.RAIN) {
            BlockPos pos;
            float rainIntensity = this.mc.f_91073_.m_46722_(0.0f);
            float xRot = 0.21816616f;
            Vector3f direction = new Vector3f(1.0f, 0.0f, 0.0f);
            float yRot = (float)(-Mth.m_14136_((double)direction.x, (double)direction.z));
            float xRotCos = Mth.m_14089_((float)(xRot - 1.5707964f));
            int xOffset = Mth.m_14143_((float)(Mth.m_14031_((float)(-yRot)) * xRotCos * 16.0f));
            int zOffset = Mth.m_14143_((float)(Mth.m_14089_((float)(-yRot)) * xRotCos * 16.0f));
            int radius = Mth.m_14143_((float)(16.0f * (Minecraft.m_91405_() ? 1.0f : 0.5f)));
            int minX = camPos.m_123341_() - radius - xOffset;
            int minY = camPos.m_123342_() + 8;
            int minZ = camPos.m_123343_() - radius - zOffset;
            int maxX = camPos.m_123341_() + radius - xOffset;
            int maxY = camPos.m_123342_() + 32;
            int maxZ = camPos.m_123343_() + radius - zOffset;
            AABB box = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            Biome biome = (Biome)this.mc.f_91073_.m_204166_(camPos).m_203334_();
            if (rainIntensity > 0.0f && biome.m_264473_()) {
                for (int x = minX; x < maxX; ++x) {
                    for (int z = minZ; z < maxZ; ++z) {
                        int height = this.mc.f_91073_.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
                        for (int y = minY; y < maxY; ++y) {
                            if (height > y) continue;
                            pos = new BlockPos(x, y, z);
                            Biome.Precipitation precipitation = Biome.Precipitation.RAIN;
                            RandomSource blockRandom = RandomSource.m_216335_((long)pos.m_121878_());
                            if (this.precipitationQuads.containsKey(pos) || blockRandom.m_188503_(100) > 1) continue;
                            float widthModifier = precipitation == Biome.Precipitation.SNOW ? 4.0f : 2.0f;
                            RainParticleQuad quad = new RainParticleQuad(precipitation, arg_0 -> ((ClientLevel)this.mc.f_91073_).m_45547_(arg_0), pos, xRot + random.m_188501_() * 0.1f, yRot + random.m_188501_() * 0.1f, 60 + random.m_188503_(60), rainIntensity * widthModifier);
                            this.precipitationQuads.put(pos, quad);
                            this.quadsByPrecipitation.computeIfAbsent(precipitation, p -> Lists.newArrayList()).add(quad);
                        }
                    }
                }
            }
            Iterator<Map.Entry<BlockPos, RainParticleQuad>> rain = this.precipitationQuads.entrySet().iterator();
            while (rain.hasNext()) {
                Map.Entry<BlockPos, RainParticleQuad> entry = rain.next();
                ClientLevel levelreader = this.mc.f_91073_;
                RainParticleQuad quad = entry.getValue();
                pos = entry.getKey();
                if (!box.m_82393_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) || quad.isDead()) {
                    this.quadsByPrecipitation.get(quad.getPrecipitation()).remove(quad);
                    rain.remove();
                    continue;
                }
                quad.tick();
            }
        }
        RandomSource rand = RandomSource.m_216327_();
        Vec3 camPosition = camPos.m_252807_();
        ClientLevel level = this.mc.f_91073_;
        int PARTICLE_RADIUS = 25;
        int MAX_PARTICLES = 80;
        double CENTER_BIAS = 2.5;
        if (WorldContext.nowWeather == WeatherType.SNOW) {
            for (int i = 0; i < MAX_PARTICLES; ++i) {
                double theta = rand.m_188500_() * 2.0 * Math.PI;
                double phi = Math.acos(Math.pow(rand.m_188500_(), CENTER_BIAS));
                double radius1 = (double)PARTICLE_RADIUS * Math.pow(rand.m_188500_(), 0.6);
                double x = radius1 * Math.sin(phi) * Math.cos(theta);
                double z = radius1 * Math.sin(phi) * Math.sin(theta);
                double y = radius1 * Math.cos(phi);
                double posX = x + camPosition.f_82479_;
                double posY = y + camPosition.f_82480_ + 5.0;
                double posZ = z + camPosition.f_82481_;
                if (posY < (double)level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos).m_123342_() || posY > camPosition.f_82480_ + (double)PARTICLE_RADIUS) continue;
                WeatherRenderer$backup.spawnParticle(level, (Holder<Biome>)level.m_204166_((BlockPos)pos), posX, posY + (double)rand.m_188501_(), posZ);
            }
        }
        if (WorldContext.nowWeather == WeatherType.SNOW) {
            return;
        }
        this.precipitationQuads.forEach((key, value) -> {
            ClientLevel levelreader = this.mc.f_91073_;
            BlockPos downPos = value.getDownBlockPos();
            if (downPos != null) {
                BlockState blockstate = levelreader.m_8055_(downPos);
                FluidState fluidstate = levelreader.m_6425_(downPos);
                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)levelreader, downPos);
                double d0 = random.m_188500_();
                double d1 = random.m_188500_();
                double d2 = voxelshape.m_83290_(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.m_76155_((BlockGetter)levelreader, downPos);
                double d4 = Math.max(d2, d3);
                SimpleParticleType particleoptions = !fluidstate.m_205070_(FluidTags.f_13132_) && !blockstate.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockstate) ? ParticleTypes.f_123761_ : ParticleTypes.f_123762_;
                double surfaceHeight = voxelshape.m_83290_(Direction.Axis.Y, random.m_188500_(), random.m_188500_());
                double fluidHeight = fluidstate.m_76155_((BlockGetter)levelreader, downPos);
                double maxSurfaceY = Math.max(surfaceHeight, fluidHeight);
                double baseX = (double)downPos.m_123341_() + 0.5;
                double baseY = (double)downPos.m_123342_() + maxSurfaceY;
                double baseZ = (double)downPos.m_123343_() + 0.5;
                Direction hitFace = value.getHitDirection();
                double edgeOffset = 0.15;
                double randomSpread = 0.4;
                switch (hitFace) {
                    case UP: {
                        baseX += (random.m_188500_() - 0.5) * 0.4;
                        baseZ += (random.m_188500_() - 0.5) * 0.4;
                        baseY += 0.15;
                        break;
                    }
                    case DOWN: {
                        return;
                    }
                    case NORTH: {
                        baseZ = (double)downPos.m_123343_() - 0.15;
                        baseX += random.m_188500_() * 0.4;
                        break;
                    }
                    case SOUTH: {
                        baseZ = (double)(downPos.m_123343_() + 1) + 0.15;
                        baseX += random.m_188500_() * 0.4;
                        break;
                    }
                    case EAST: {
                        baseX = (double)(downPos.m_123341_() + 1) + 0.15;
                        baseZ += random.m_188500_() * 0.4;
                        break;
                    }
                    case WEST: {
                        baseX = (double)downPos.m_123341_() - 0.15;
                        baseZ += random.m_188500_() * 0.4;
                    }
                }
                levelreader.m_7106_((ParticleOptions)particleoptions, baseX, baseY + (hitFace == Direction.UP ? 0.0 : random.m_188500_() * 0.3), baseZ, 0.0, 0.0, 0.0);
            }
        });
    }

    @Override
    public void render() {
    }

    @Override
    public boolean isRender() {
        return false;
    }

    private static void spawnParticle(ClientLevel level, Holder<Biome> biome, double x, double y, double z) {
        if (particleCount > maxParticleCount) {
            return;
        }
        y += 8.0;
        BlockPos getPrecipitationFromBlockPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos);
        if (level.f_46441_.m_188501_() < 0.8f) {
            level.m_7106_((ParticleOptions)ParticleRegistry.SNOW.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

