/*
 * Decompiled with CFR 0.152.
 */
package indi.yunherry.weather.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraftforge.fml.ModList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaderUtils {
    private static final Logger log = LoggerFactory.getLogger(ShaderUtils.class);

    public static boolean isOptifineLoaded() {
        try {
            Class.forName("net.optifine.Config");
        }
        catch (ClassNotFoundException var2) {
            return false;
        }
        return true;
    }

    public static boolean areShadersRunning() {
        try {
            if (ShaderUtils.isOculusLoaded()) {
                Class<?> clazz = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
                Method method = clazz.getMethod("getInstance", new Class[0]);
                Object irisApi = method.invoke(null, new Object[0]);
                return (Boolean)irisApi.getClass().getMethod("isShaderPackInUse", new Class[0]).invoke(irisApi, new Object[0]);
            }
            if (ShaderUtils.isOptifineLoaded()) {
                Class<?> clazz = Class.forName("net.optifine.Config");
                Method method = clazz.getMethod("isShaders", new Class[0]);
                return (Boolean)method.invoke(null, new Object[0]);
            }
            return false;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException var3) {
            Exception e = var3;
            log.error("Failed to check if shaders are enabled:");
            return false;
        }
    }

    public static boolean isOculusLoaded() {
        return ModList.get().isLoaded("oculus");
    }

    public static boolean isSodiumLoaded() {
        return ModList.get().isLoaded("rubidium");
    }
}

