/*
 * Decompiled with CFR 0.152.
 */
package indi.yunherry.weather.utils;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FindClassUtil {
    public static ArrayList<Class<?>> findClasses(Class<?> input) throws IOException {
        return FindClassUtil.getClasses(input.getPackageName());
    }

    public static ArrayList<Class<?>> getClasses(String packageName) throws IOException {
        ArrayList classes = new ArrayList();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                JarFile jarFile;
                JarURLConnection connection;
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8);
                    FindClassUtil.findClassInPackageByFile(packageName, filePath, true, classes);
                    continue;
                }
                if (!"jar".equals(protocol) || (connection = (JarURLConnection)url.openConnection()) == null || (jarFile = connection.getJarFile()) == null) continue;
                Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
                while (jarEntryEnumeration.hasMoreElements()) {
                    JarEntry entry = jarEntryEnumeration.nextElement();
                    String jarEntryName = entry.getName();
                    if (!jarEntryName.contains(".class") || !jarEntryName.replaceAll("/", ".").startsWith(packageName)) continue;
                    String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replace("/", ".");
                    Class<?> clazz = Class.forName(className);
                    classes.add(clazz);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findClassInPackageByFile(String packageName, String filePath, boolean recursive, List<Class<?>> classes) {
        File dir = new File(filePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirFiles = dir.listFiles(file -> {
            boolean acceptDir = recursive && file.isDirectory();
            boolean acceptClass = file.getName().endsWith("class");
            return acceptDir || acceptClass;
        });
        assert (dirFiles != null);
        for (File file2 : dirFiles) {
            if (file2.isDirectory()) {
                FindClassUtil.findClassInPackageByFile(packageName + "." + file2.getName(), file2.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().length() - 6);
            System.out.println("\u7c7b: " + className);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + "." + className));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

