/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.MechanicalPeeler;

import com.adonis.createfisheryindustry.block.MechanicalPeeler.MechanicalPeelerBlock;
import com.adonis.createfisheryindustry.client.renderer.MechanicalPeelerActorVisual;
import com.adonis.createfisheryindustry.client.renderer.MechanicalPeelerRenderer;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.DataMapHooks;
import net.neoforged.neoforge.common.IShearable;

public class MechanicalPeelerMovementBehaviour
extends BlockBreakingMovementBehaviour {
    private static final int ENTITY_COOLDOWN_TICKS = 1200;
    private static final int BLOCK_BREAK_TIME = 30;

    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)((Direction)context.state.getValue((Property)MechanicalPeelerBlock.FACING)).getOpposite());
    }

    public Vec3 getActiveAreaOffset(MovementContext context) {
        Direction facing = (Direction)context.state.getValue((Property)MechanicalPeelerBlock.FACING);
        return Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale((double)0.65f);
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Level world = context.world;
        if (world.isClientSide) {
            return;
        }
        Direction facing = (Direction)context.state.getValue((Property)MechanicalPeelerBlock.FACING);
        this.processEntitiesInArea(context, pos, world, facing);
        BlockState stateVisited = world.getBlockState(pos);
        if (this.canProcessBlock(stateVisited)) {
            context.data.put("BreakingPos", NbtUtils.writeBlockPos((BlockPos)pos));
            context.stall = true;
        }
    }

    private void processEntitiesInArea(MovementContext context, BlockPos pos, Level world, Direction facing) {
        AABB detectionArea = this.createEntityDetectionArea(pos, facing);
        List entities = world.getEntitiesOfClass(Entity.class, detectionArea, entity -> entity.isAlive() && (entity instanceof IShearable || entity instanceof Armadillo || entity instanceof Turtle));
        for (Entity entity2 : entities) {
            this.processEntity(context, entity2);
        }
    }

    private AABB createEntityDetectionArea(BlockPos pos, Direction facing) {
        double interactionDepth = 0.6;
        double interactionWidth = 0.8;
        double interactionHeight = 0.8;
        double offsetFromSurface = 0.1;
        Vec3 min = Vec3.ZERO;
        Vec3 max = Vec3.ZERO;
        switch (facing) {
            case UP: {
                min = new Vec3(0.09999999999999998, 1.1, 0.09999999999999998);
                max = new Vec3(0.9, 1.7000000000000002, 0.9);
                break;
            }
            case DOWN: {
                min = new Vec3(0.09999999999999998, -0.7, 0.09999999999999998);
                max = new Vec3(0.9, -0.1, 0.9);
                break;
            }
            case NORTH: {
                min = new Vec3(0.09999999999999998, 0.09999999999999998, -0.7);
                max = new Vec3(0.9, 0.9, -0.1);
                break;
            }
            case SOUTH: {
                min = new Vec3(0.09999999999999998, 0.09999999999999998, 1.1);
                max = new Vec3(0.9, 0.9, 1.7000000000000002);
                break;
            }
            case WEST: {
                min = new Vec3(-0.7, 0.09999999999999998, 0.09999999999999998);
                max = new Vec3(-0.1, 0.9, 0.9);
                break;
            }
            case EAST: {
                min = new Vec3(1.1, 0.09999999999999998, 0.09999999999999998);
                max = new Vec3(1.7000000000000002, 0.9, 0.9);
            }
        }
        return new AABB(min.x, min.y, min.z, max.x, max.y, max.z).move(pos);
    }

    private void processEntity(MovementContext context, Entity entity) {
        List drops;
        IShearable shearableTarget;
        boolean isArmadilloOrTurtle;
        UUID entityId = entity.getUUID();
        boolean bl = isArmadilloOrTurtle = entity instanceof Armadillo || entity instanceof Turtle;
        if (isArmadilloOrTurtle && this.isEntityOnCooldown(context, entityId)) {
            return;
        }
        boolean processedSuccessfully = false;
        if (entity instanceof IShearable && (shearableTarget = (IShearable)entity).isShearable(null, ItemStack.EMPTY, context.world, entity.blockPosition()) && (drops = shearableTarget.onSheared(null, ItemStack.EMPTY, context.world, entity.blockPosition())) != null && !drops.isEmpty()) {
            for (ItemStack drop : drops) {
                this.dropItem(context, drop);
            }
            processedSuccessfully = true;
        }
        if (!processedSuccessfully && isArmadilloOrTurtle) {
            ItemStack scuteStack = null;
            if (entity instanceof Armadillo) {
                scuteStack = new ItemStack((ItemLike)Items.ARMADILLO_SCUTE);
            } else if (entity instanceof Turtle) {
                scuteStack = new ItemStack((ItemLike)Items.TURTLE_SCUTE);
            }
            if (scuteStack != null) {
                this.dropItem(context, scuteStack);
                context.world.playSound(null, entity.blockPosition(), SoundEvents.ARMADILLO_SCUTE_DROP, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.setEntityCooldown(context, entityId);
                processedSuccessfully = true;
            }
        }
    }

    private boolean isEntityOnCooldown(MovementContext context, UUID entityId) {
        CompoundTag data = context.data;
        if (!data.contains("EntityCooldowns")) {
            return false;
        }
        CompoundTag cooldowns = data.getCompound("EntityCooldowns");
        if (!cooldowns.contains(entityId.toString())) {
            return false;
        }
        long lastProcessTime = cooldowns.getLong(entityId.toString());
        return context.world.getGameTime() - lastProcessTime < 1200L;
    }

    private void setEntityCooldown(MovementContext context, UUID entityId) {
        CompoundTag data = context.data;
        if (!data.contains("EntityCooldowns")) {
            data.put("EntityCooldowns", (Tag)new CompoundTag());
        }
        CompoundTag cooldowns = data.getCompound("EntityCooldowns");
        cooldowns.putLong(entityId.toString(), context.world.getGameTime());
    }

    public void tickBreaker(MovementContext context) {
        CompoundTag data = context.data;
        if (context.world.isClientSide) {
            return;
        }
        if (!data.contains("BreakingPos")) {
            context.stall = false;
            return;
        }
        if (context.relativeMotion.equals((Object)Vec3.ZERO)) {
            context.stall = false;
            return;
        }
        float processingSpeed = this.getProcessingSpeed(context);
        float currentProgress = data.getFloat("ProcessingProgress");
        data.putFloat("ProcessingProgress", currentProgress += processingSpeed);
        Level world = context.world;
        BlockPos breakingPos = NBTHelper.readBlockPos((CompoundTag)data, (String)"BreakingPos");
        BlockState stateToBreak = world.getBlockState(breakingPos);
        if (!this.canProcessBlock(stateToBreak)) {
            data.remove("ProcessingProgress");
            data.remove("BreakingPos");
            context.stall = false;
            return;
        }
        if (currentProgress >= 30.0f) {
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                BlockState processedState = this.processBlock(serverLevel, breakingPos, stateToBreak, context);
                if (processedState != null && this.canProcessBlock(processedState)) {
                    data.putFloat("ProcessingProgress", 0.0f);
                } else {
                    data.remove("ProcessingProgress");
                    data.remove("BreakingPos");
                    context.stall = false;
                }
            } else {
                data.remove("ProcessingProgress");
                data.remove("BreakingPos");
                context.stall = false;
            }
            return;
        }
    }

    private float getProcessingSpeed(MovementContext context) {
        float baseSpeed = 1.0f;
        if (context.contraption != null) {
            // empty if block
        }
        return baseSpeed;
    }

    public void tick(MovementContext context) {
        CompoundTag data;
        super.tick(context);
        if (context.world.isClientSide && (data = context.data).contains("BreakingPos") && data.contains("ProcessingProgress")) {
            Level world = context.world;
            BlockPos breakingPos = NBTHelper.readBlockPos((CompoundTag)data, (String)"BreakingPos");
            BlockState stateToBreak = world.getBlockState(breakingPos);
            float processingProgress = data.getFloat("ProcessingProgress");
            if (this.canProcessBlock(stateToBreak) && processingProgress > 0.0f && world.getGameTime() % 3L == 0L) {
                this.spawnProcessingParticles(world, breakingPos, stateToBreak);
            }
        }
    }

    private void spawnProcessingParticles(Level world, BlockPos pos, BlockState state) {
        RandomSource random = world.random;
        Vec3 center = Vec3.atCenterOf((Vec3i)pos);
        if (state.getBlock() == Blocks.AMETHYST_CLUSTER) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            for (i = 0; i < 2; ++i) {
                offsetX = (random.nextDouble() - 0.5) * 0.8;
                offsetY = (random.nextDouble() - 0.5) * 0.8;
                offsetZ = (random.nextDouble() - 0.5) * 0.8;
                world.addParticle((ParticleOptions)ParticleTypes.END_ROD, center.x + offsetX, center.y + offsetY, center.z + offsetZ, (random.nextDouble() - 0.5) * 0.1, random.nextDouble() * 0.1 + 0.02, (random.nextDouble() - 0.5) * 0.1);
            }
            for (i = 0; i < 1; ++i) {
                offsetX = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)world, pos).bounds().getXsize();
                offsetY = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)world, pos).bounds().getYsize();
                offsetZ = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)world, pos).bounds().getZsize();
                world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), center.x + offsetX, center.y + offsetY, center.z + offsetZ, (random.nextDouble() - 0.5) * 0.2, random.nextDouble() * 0.1 + 0.05, (random.nextDouble() - 0.5) * 0.2);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)world, pos).bounds().getXsize();
                double offsetY = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)world, pos).bounds().getYsize();
                double offsetZ = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)world, pos).bounds().getZsize();
                world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), center.x + offsetX, center.y + offsetY, center.z + offsetZ, (random.nextDouble() - 0.5) * 0.2, random.nextDouble() * 0.1 + 0.05, (random.nextDouble() - 0.5) * 0.2);
            }
        }
    }

    private BlockState processBlock(ServerLevel world, BlockPos pos, BlockState state, MovementContext context) {
        String blockPath;
        Block currentBlock = state.getBlock();
        BlockState newState = null;
        if (currentBlock == Blocks.AMETHYST_CLUSTER) {
            ItemStack amethystShards = new ItemStack((ItemLike)Items.AMETHYST_SHARD, 4);
            this.dropItem(context, amethystShards);
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            world.playSound(null, pos, state.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return null;
        }
        Block deoxidized = (Block)DataMapHooks.INVERSE_OXIDIZABLES_DATAMAP.get(currentBlock);
        if (deoxidized != null) {
            newState = MechanicalPeelerMovementBehaviour.copyProperties(state, deoxidized.defaultBlockState());
            world.setBlock(pos, newState, 3);
            world.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return newState;
        }
        Block dewaxed = (Block)DataMapHooks.INVERSE_WAXABLES_DATAMAP.get(currentBlock);
        if (dewaxed != null) {
            newState = MechanicalPeelerMovementBehaviour.copyProperties(state, dewaxed.defaultBlockState());
            world.setBlock(pos, newState, 3);
            world.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return newState;
        }
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)currentBlock);
        if (blockId != null && (blockPath = blockId.getPath()).contains("log") && !blockPath.contains("stripped")) {
            String strippedPath = "stripped_" + blockPath;
            ResourceLocation strippedId = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)strippedPath);
            if (BuiltInRegistries.BLOCK.containsKey(strippedId)) {
                Block strippedBlock = (Block)BuiltInRegistries.BLOCK.get(strippedId);
                newState = MechanicalPeelerMovementBehaviour.copyProperties(state, strippedBlock.defaultBlockState());
                world.setBlock(pos, newState, 3);
                world.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.processConnectedLogs(world, pos, currentBlock, context);
                return null;
            }
        }
        return null;
    }

    private void processConnectedLogs(ServerLevel world, BlockPos startPos, Block logType, MovementContext context) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(startPos);
        visited.add(startPos);
        int processedCount = 0;
        while (!toCheck.isEmpty() && processedCount < 64) {
            BlockPos current = (BlockPos)toCheck.poll();
            for (Direction dir : Direction.values()) {
                BlockState neighborState;
                BlockPos neighbor = current.relative(dir);
                if (visited.contains(neighbor) || !this.isSameWoodType(logType, (neighborState = world.getBlockState(neighbor)).getBlock())) continue;
                visited.add(neighbor);
                toCheck.add(neighbor);
                this.processBlock(world, neighbor, neighborState, context);
                ++processedCount;
            }
        }
    }

    private boolean isSameWoodType(Block block1, Block block2) {
        ResourceLocation id1 = BuiltInRegistries.BLOCK.getKey((Object)block1);
        ResourceLocation id2 = BuiltInRegistries.BLOCK.getKey((Object)block2);
        if (id1 == null || id2 == null) {
            return false;
        }
        if (!id1.getNamespace().equals(id2.getNamespace())) {
            return false;
        }
        String type1 = this.extractWoodType(id1.getPath());
        String type2 = this.extractWoodType(id2.getPath());
        return type1.equals(type2);
    }

    private String extractWoodType(String blockPath) {
        if (blockPath.endsWith("_log")) {
            return blockPath.substring(0, blockPath.length() - 4);
        }
        if (blockPath.startsWith("stripped_") && blockPath.endsWith("_log")) {
            return blockPath.substring(9, blockPath.length() - 4);
        }
        return blockPath;
    }

    private static <T extends Comparable<T>> BlockState copyProperties(BlockState from, BlockState to) {
        for (Property property : from.getProperties()) {
            if (!to.hasProperty(property)) continue;
            to = (BlockState)to.setValue(property, from.getValue(property));
        }
        return to;
    }

    private boolean canProcessBlock(BlockState state) {
        String blockPath;
        if (state.isAir()) {
            return false;
        }
        Block block = state.getBlock();
        if (DataMapHooks.INVERSE_OXIDIZABLES_DATAMAP.containsKey(block)) {
            return true;
        }
        if (DataMapHooks.INVERSE_WAXABLES_DATAMAP.containsKey(block)) {
            return true;
        }
        if (block == Blocks.AMETHYST_CLUSTER) {
            return true;
        }
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (blockId != null && (blockPath = blockId.getPath()).contains("log") && !blockPath.contains("stripped")) {
            String strippedPath = "stripped_" + blockPath;
            ResourceLocation strippedId = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)strippedPath);
            return BuiltInRegistries.BLOCK.containsKey(strippedId);
        }
        return false;
    }

    public boolean canBreak(Level world, BlockPos breakingPos, BlockState state) {
        return this.canProcessBlock(state) && !AllTags.AllBlockTags.TRACKS.matches(state);
    }

    protected DamageSource getDamageSource(Level level) {
        return null;
    }

    public boolean disableBlockEntityRendering() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (!VisualizationManager.supportsVisualization((LevelAccessor)context.world)) {
            MechanicalPeelerRenderer.renderInContraption(context, renderWorld, matrices, buffer);
        }
    }

    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new MechanicalPeelerActorVisual(visualizationContext, simulationWorld, movementContext);
    }
}

