/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.MeshTrap;

import com.adonis.createfisheryindustry.block.MeshTrap.MeshTrapBlock;
import com.adonis.createfisheryindustry.block.SmartMesh.SmartMeshBlockEntity;
import com.adonis.createfisheryindustry.block.common.TrapBlockEntity;
import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlockEntities;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeshTrapBlockEntity
extends TrapBlockEntity
implements IHaveGoggleInformation {
    protected static final int PROCESSING_TIME = 10;
    protected static final double ENTITY_KILL_RANGE = 1.0;
    private static final double MAX_COLLISION_BOX_SIZE = 0.8;
    private static final int AUTO_EXPORT_COOLDOWN = 20;
    private int autoExportTicks = 0;
    private static final int BELT_EXTRACTION_COOLDOWN = 5;
    private int beltExtractionTicks = 0;
    private final Map<Direction, TransportedItemStackHandlerBehaviour> beltHandlers = new HashMap<Direction, TransportedItemStackHandlerBehaviour>();
    private final IItemHandler insertionHandler = new InsertionOnlyItemHandler((IItemHandler)this.inventory);
    private final IItemHandler extractionHandler = new ExtractionOnlyItemHandler((IItemHandler)this.inventory);

    public MeshTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CreateFisheryBlockEntities.MESH_TRAP.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MeshTrapBlockEntity be) {
        if (level.isClientSide()) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ++be.processingTicks;
        if (be.processingTicks >= 10) {
            be.processingTicks = 0;
            be.collectNearbyItems(serverLevel);
            be.tryProcessEntities(serverLevel);
            be.setChanged();
            be.sendData();
            serverLevel.sendBlockUpdated(pos, state, state, 3);
        }
        ++be.autoExportTicks;
        if (be.autoExportTicks >= 20) {
            be.autoExportTicks = 0;
            be.tryExportItems(serverLevel);
        }
        ++be.beltExtractionTicks;
        if (be.beltExtractionTicks >= 5) {
            be.beltExtractionTicks = 0;
            be.extractItemsFromBelts(serverLevel);
        }
        be.tick();
    }

    protected void extractItemsFromBelts(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return;
        }
        this.updateBeltHandlers(level);
        for (Direction direction : Direction.values()) {
            TransportedItemStackHandlerBehaviour handler;
            if (direction == Direction.UP || direction == Direction.DOWN || (handler = this.beltHandlers.get(direction)) == null) continue;
            this.extractFromBelt(handler);
        }
    }

    private void updateBeltHandlers(ServerLevel level) {
        this.beltHandlers.clear();
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos;
            BlockEntity blockEntity;
            if (direction == Direction.UP || direction == Direction.DOWN || !((blockEntity = level.getBlockEntity(neighborPos = this.getBlockPos().relative(direction))) instanceof SmartBlockEntity)) continue;
            SmartBlockEntity smartBE = (SmartBlockEntity)blockEntity;
            TransportedItemStackHandlerBehaviour behaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)neighborPos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
            if (behaviour == null) continue;
            this.beltHandlers.put(direction, behaviour);
        }
    }

    private void extractFromBelt(TransportedItemStackHandlerBehaviour beltHandler) {
        boolean hasSpace = false;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            if (!this.inventory.getStackInSlot(slot).isEmpty()) continue;
            hasSpace = true;
            break;
        }
        if (!hasSpace) {
            return;
        }
        beltHandler.handleCenteredProcessingOnAllItems(0.5f, transportedItem -> {
            ItemStack stack = transportedItem.stack;
            if (stack.isEmpty()) {
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            }
            ItemStack remaining = stack.copy();
            boolean anyInserted = false;
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack toInsert;
                ItemStack slotStack = this.inventory.getStackInSlot(slot);
                if (!slotStack.isEmpty() && (!ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)remaining) || slotStack.getCount() >= slotStack.getMaxStackSize()) || (remaining = this.inventory.insertItem(slot, toInsert = remaining.copy(), false)).getCount() >= toInsert.getCount()) continue;
                anyInserted = true;
                if (remaining.isEmpty()) break;
            }
            if (anyInserted) {
                this.setChanged();
                this.sendData();
                Level patt0$temp = this.level;
                if (patt0$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt0$temp;
                    serverLevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                }
                if (remaining.isEmpty()) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
                }
                TransportedItemStack newTransportedItem = new TransportedItemStack(remaining);
                newTransportedItem.prevBeltPosition = transportedItem.prevBeltPosition;
                newTransportedItem.beltPosition = transportedItem.beltPosition;
                newTransportedItem.insertedFrom = transportedItem.insertedFrom;
                newTransportedItem.insertedAt = transportedItem.insertedAt;
                return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo((TransportedItemStack)newTransportedItem);
            }
            return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        });
    }

    protected void tryExportItems(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return;
        }
        boolean anyItemMoved = false;
        for (Direction direction : Direction.values()) {
            IItemHandler targetInventory;
            BlockPos neighborPos = this.getBlockPos().relative(direction);
            TransportedItemStackHandlerBehaviour beltBehaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)neighborPos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
            if (beltBehaviour != null || level.getBlockEntity(neighborPos) instanceof MeshTrapBlockEntity || level.getBlockEntity(neighborPos) instanceof SmartMeshBlockEntity || (targetInventory = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, neighborPos, (Object)direction.getOpposite())) == null) continue;
            for (int sourceSlot = 0; sourceSlot < this.inventory.getSlots(); ++sourceSlot) {
                ItemStack extractedItem;
                ItemStack stackInSlot = this.inventory.getStackInSlot(sourceSlot);
                if (stackInSlot.isEmpty() || (extractedItem = this.inventory.extractItem(sourceSlot, stackInSlot.getCount(), true)).isEmpty()) continue;
                ItemStack remainingItem = this.insertItemIntoTarget(extractedItem, targetInventory);
                int actualExtractAmount = extractedItem.getCount() - remainingItem.getCount();
                if (actualExtractAmount <= 0) continue;
                this.inventory.extractItem(sourceSlot, actualExtractAmount, false);
                anyItemMoved = true;
                break;
            }
            if (anyItemMoved) break;
        }
        if (anyItemMoved) {
            this.setChanged();
            this.sendData();
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private ItemStack insertItemIntoTarget(ItemStack stack, IItemHandler targetInventory) {
        ItemStack remaining = stack.copy();
        for (int slot = 0; slot < targetInventory.getSlots() && !remaining.isEmpty(); ++slot) {
            remaining = targetInventory.insertItem(slot, remaining, false);
        }
        return remaining;
    }

    protected void tryProcessEntities(ServerLevel level) {
        CreateFisheryCommonConfig.refreshCache();
        AABB boundingBox = new AABB(this.getBlockPos()).inflate(1.0);
        List entities = level.getEntitiesOfClass(Entity.class, boundingBox);
        for (Entity entity : entities) {
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            if (!entity.isAlive()) continue;
            EntityType entityType = entity.getType();
            ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType);
            if (entityId.toString().equals("minecraft:breeze")) {
                // empty if block
            }
            if (CreateFisheryCommonConfig.isEntityBlacklisted(entityId)) {
                if (!entityId.toString().equals("minecraft:breeze")) continue;
                continue;
            }
            if (CreateFisheryCommonConfig.isEntityWhitelisted(entityId)) {
                if (entityId.toString().equals("minecraft:breeze")) {
                    // empty if block
                }
                this.processEntityDrops(level, mob);
                continue;
            }
            if (entityId.toString().equals("minecraft:breeze")) {
                // empty if block
            }
            AABB collisionBox = entity.getBoundingBox();
            double width = collisionBox.getXsize();
            double height = collisionBox.getYsize();
            double depth = collisionBox.getZsize();
            if (entityId.toString().equals("minecraft:breeze")) {
                // empty if block
            }
            if (width <= 0.8 && height <= 0.8 && depth <= 0.8) {
                if (entityId.toString().equals("minecraft:breeze")) {
                    // empty if block
                }
                this.processEntityDrops(level, mob);
                continue;
            }
            if (!entityId.toString().equals("minecraft:breeze")) continue;
        }
    }

    private void processEntityDrops(ServerLevel level, Mob mob) {
        Player nearestPlayer;
        ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType());
        ResourceKey lootTableKey = mob.getLootTable();
        if (lootTableKey == null) {
            return;
        }
        LootParams.Builder paramsBuilder = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)mob).withParameter(LootContextParams.ORIGIN, (Object)mob.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().generic());
        List players = level.getServer().getPlayerList().getPlayers();
        if (!players.isEmpty() && (nearestPlayer = level.getNearestPlayer((Entity)mob, -1.0)) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)nearestPlayer;
            paramsBuilder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)serverPlayer);
        }
        LootParams params = paramsBuilder.create(LootContextParamSets.ENTITY);
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableKey);
        ObjectArrayList loots = lootTable.getRandomItems(params);
        boolean allInserted = true;
        for (ItemStack stack : loots) {
            ItemStack remainder = stack.copy();
            for (int i = 0; i < this.inventory.getSlots() && !(remainder = this.inventory.insertItem(i, remainder, false)).isEmpty(); ++i) {
            }
            if (remainder.isEmpty()) continue;
            ItemEntity itemEntity = new ItemEntity((Level)level, mob.getX(), mob.getY(), mob.getZ(), remainder);
            level.addFreshEntity((Entity)itemEntity);
            allInserted = false;
        }
        boolean inWater = (Boolean)this.getBlockState().getValue((Property)MeshTrapBlock.WATERLOGGED);
        SimpleParticleType particleType = inWater ? ParticleTypes.BUBBLE : ParticleTypes.CLOUD;
        level.sendParticles((ParticleOptions)particleType, mob.getX(), mob.getY() + 0.5, mob.getZ(), 15, 0.5, 0.5, 0.5, 0.1);
        level.playSound(null, new BlockPos((int)mob.getX(), (int)mob.getY(), (int)mob.getZ()), SoundEvents.BUCKET_FILL_FISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        Item expNuggetItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"experience_nugget"));
        if (expNuggetItem != null && expNuggetItem != BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)"air"))) {
            ItemStack expNugget = new ItemStack((ItemLike)expNuggetItem, 1);
            ItemStack remainder = expNugget.copy();
            for (int i = 0; i < this.inventory.getSlots() && !(remainder = this.inventory.insertItem(i, remainder, false)).isEmpty(); ++i) {
            }
            if (!remainder.isEmpty()) {
                ItemEntity itemEntity = new ItemEntity((Level)level, mob.getX(), mob.getY(), mob.getZ(), remainder);
                level.addFreshEntity((Entity)itemEntity);
            }
        }
        mob.setRemoved(Entity.RemovalReason.KILLED);
        this.setChanged();
        this.sendData();
        level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"gui.goggles.mesh_trap_contents", (Object[])new Object[0]).forGoggles(tooltip);
        ItemStackHandler inv = this.getInventory();
        boolean isEmpty = true;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            isEmpty = false;
            CreateLang.text((String)"").add(Component.translatable((String)stack.getDescriptionId()).withStyle(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stack.getCount())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        if (isEmpty) {
            CreateLang.translate((String)"gui.goggles.inventory.empty", (Object[])new Object[0]).forGoggles(tooltip, 1);
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T getCapability(BlockCapability<T, @Nullable Direction> capability, @Nullable Direction side) {
        if (capability == Capabilities.ItemHandler.BLOCK) {
            return (T)this.inventory;
        }
        return super.getCapability(capability, side);
    }

    private static class InsertionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public InsertionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.wrapped.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }

    private static class ExtractionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public ExtractionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.wrapped.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }
}

