/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.MeshTrap;

import com.adonis.createfisheryindustry.block.MeshTrap.MeshTrapBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

class MeshTrapInteractionPoint
extends ArmInteractionPoint {
    public MeshTrapInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    protected Vec3 getInteractionPositionVector() {
        Vec3 pos = Vec3.atLowerCornerOf((Vec3i)this.pos).add(0.5, 0.875, 0.5);
        return pos;
    }

    protected IItemHandler getHandler() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof MeshTrapBlockEntity) {
            MeshTrapBlockEntity meshTrap = (MeshTrapBlockEntity)blockEntity;
            ItemStackHandler handler = meshTrap.getInventory();
            return handler;
        }
        return null;
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        IItemHandler handler = this.getHandler();
        if (handler == null) {
            return stack;
        }
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        return remainder;
    }

    public ItemStack extract(int slot, int amount, boolean simulate) {
        IItemHandler handler = this.getHandler();
        if (handler == null) {
            return ItemStack.EMPTY;
        }
        ItemStack extracted = handler.extractItem(slot, amount, simulate);
        return extracted;
    }

    public int getSlotCount() {
        IItemHandler handler = this.getHandler();
        int slotCount = handler != null ? handler.getSlots() : 0;
        return slotCount;
    }
}

