/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.SmartMesh;

import com.adonis.createfisheryindustry.block.MeshTrap.MeshTrapBlockEntity;
import com.adonis.createfisheryindustry.block.SmartMesh.SmartMeshFilterSlotPositioning;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlockEntities;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SmartMeshBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected static final int PROCESSING_TIME = 10;
    private static final int AUTO_EXPORT_COOLDOWN = 20;
    private static final int BELT_EXTRACTION_COOLDOWN = 5;
    protected static final double COLLECTION_RANGE = 1.5;
    private int processingTicks = 0;
    private int autoExportTicks = 0;
    private int beltExtractionTicks = 0;
    private final Map<Direction, TransportedItemStackHandlerBehaviour> beltHandlers = new HashMap<Direction, TransportedItemStackHandlerBehaviour>();
    protected ItemStackHandler inventory = this.createInventory();
    private final IItemHandler insertionHandler = new InsertionOnlyItemHandler((IItemHandler)this.inventory);
    private final IItemHandler extractionHandler = new ExtractionOnlyItemHandler((IItemHandler)this.inventory);
    protected FilteringBehaviour filtering;

    public SmartMeshBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CreateFisheryBlockEntities.SMART_MESH.get(), pos, state);
    }

    protected ItemStackHandler createInventory() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                SmartMeshBlockEntity.this.setChanged();
                if (SmartMeshBlockEntity.this.level != null && !SmartMeshBlockEntity.this.level.isClientSide()) {
                    SmartMeshBlockEntity.this.level.sendBlockUpdated(SmartMeshBlockEntity.this.worldPosition, SmartMeshBlockEntity.this.getBlockState(), SmartMeshBlockEntity.this.getBlockState(), 3);
                }
            }
        };
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SmartMeshFilterSlotPositioning());
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SmartMeshBlockEntity be) {
        if (level.isClientSide()) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ++be.processingTicks;
        if (be.processingTicks >= 10) {
            be.processingTicks = 0;
            be.collectNearbyItems(serverLevel);
            be.setChanged();
            be.sendData();
            serverLevel.sendBlockUpdated(pos, state, state, 3);
        }
        ++be.autoExportTicks;
        if (be.autoExportTicks >= 20) {
            be.autoExportTicks = 0;
            be.tryExportItems(serverLevel);
        }
        ++be.beltExtractionTicks;
        if (be.beltExtractionTicks >= 5) {
            be.beltExtractionTicks = 0;
            be.extractItemsFromBelts(serverLevel);
        }
    }

    protected void collectNearbyItems(ServerLevel level) {
        AABB boundingBox = new AABB(this.getBlockPos()).inflate(1.5);
        List items = level.getEntitiesOfClass(ItemEntity.class, boundingBox);
        for (ItemEntity itemEntity : items) {
            ItemStack stack;
            if (itemEntity == null || !itemEntity.isAlive() || (stack = itemEntity.getItem()).isEmpty() || !this.canAcceptItem(stack)) continue;
            ItemStack copy = stack.copy();
            if (this.insertItem(copy)) {
                itemEntity.discard();
                continue;
            }
            if (copy.getCount() >= stack.getCount()) continue;
            itemEntity.setItem(copy);
        }
    }

    protected boolean insertItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ItemStack remainder = stack.copy();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!(remainder = this.inventory.insertItem(i, remainder, false)).isEmpty()) continue;
            return true;
        }
        return stack.getCount() != remainder.getCount();
    }

    protected void extractItemsFromBelts(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return;
        }
        this.updateBeltHandlers(level);
        for (Direction direction : Direction.values()) {
            TransportedItemStackHandlerBehaviour handler;
            if (direction == Direction.UP || direction == Direction.DOWN || (handler = this.beltHandlers.get(direction)) == null) continue;
            this.extractFromBelt(handler);
        }
    }

    private void updateBeltHandlers(ServerLevel level) {
        this.beltHandlers.clear();
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos;
            BlockEntity blockEntity;
            if (direction == Direction.UP || direction == Direction.DOWN || !((blockEntity = level.getBlockEntity(neighborPos = this.getBlockPos().relative(direction))) instanceof SmartBlockEntity)) continue;
            SmartBlockEntity smartBE = (SmartBlockEntity)blockEntity;
            TransportedItemStackHandlerBehaviour behaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)neighborPos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
            if (behaviour == null) continue;
            this.beltHandlers.put(direction, behaviour);
        }
    }

    private void extractFromBelt(TransportedItemStackHandlerBehaviour beltHandler) {
        boolean hasSpace = false;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            if (!this.inventory.getStackInSlot(slot).isEmpty()) continue;
            hasSpace = true;
            break;
        }
        if (!hasSpace) {
            return;
        }
        beltHandler.handleCenteredProcessingOnAllItems(0.5f, transportedItem -> {
            ItemStack stack = transportedItem.stack;
            if (stack.isEmpty()) {
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            }
            if (!this.canAcceptItem(stack)) {
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            }
            ItemStack remaining = stack.copy();
            boolean anyInserted = false;
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack toInsert;
                ItemStack slotStack = this.inventory.getStackInSlot(slot);
                if (!slotStack.isEmpty() && (!ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)remaining) || slotStack.getCount() >= slotStack.getMaxStackSize()) || (remaining = this.inventory.insertItem(slot, toInsert = remaining.copy(), false)).getCount() >= toInsert.getCount()) continue;
                anyInserted = true;
                if (remaining.isEmpty()) break;
            }
            if (anyInserted) {
                this.setChanged();
                this.sendData();
                Level patt0$temp = this.level;
                if (patt0$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt0$temp;
                    serverLevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                }
                if (remaining.isEmpty()) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
                }
                TransportedItemStack newTransportedItem = new TransportedItemStack(remaining);
                newTransportedItem.prevBeltPosition = transportedItem.prevBeltPosition;
                newTransportedItem.beltPosition = transportedItem.beltPosition;
                newTransportedItem.insertedFrom = transportedItem.insertedFrom;
                newTransportedItem.insertedAt = transportedItem.insertedAt;
                return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo((TransportedItemStack)newTransportedItem);
            }
            return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        });
    }

    protected void tryExportItems(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return;
        }
        boolean anyItemMoved = false;
        for (Direction direction : Direction.values()) {
            IItemHandler targetInventory;
            BlockPos neighborPos = this.getBlockPos().relative(direction);
            TransportedItemStackHandlerBehaviour beltBehaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)neighborPos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
            if (beltBehaviour != null || level.getBlockEntity(neighborPos) instanceof MeshTrapBlockEntity || level.getBlockEntity(neighborPos) instanceof SmartMeshBlockEntity || (targetInventory = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, neighborPos, (Object)direction.getOpposite())) == null) continue;
            for (int sourceSlot = 0; sourceSlot < this.inventory.getSlots(); ++sourceSlot) {
                ItemStack stackInSlot = this.inventory.getStackInSlot(sourceSlot);
                if (stackInSlot.isEmpty()) continue;
                int extractionAmount = this.getExtractionAmount();
                ItemHelper.ExtractionCountMode extractionMode = this.getExtractionMode();
                ItemStack extractedItem = this.inventory.extractItem(sourceSlot, Math.min(stackInSlot.getCount(), extractionAmount), true);
                if (extractedItem.isEmpty()) continue;
                ItemStack remainingItem = this.insertItemIntoTarget(extractedItem, targetInventory);
                int actualExtractAmount = extractedItem.getCount() - remainingItem.getCount();
                if (actualExtractAmount <= 0) continue;
                this.inventory.extractItem(sourceSlot, actualExtractAmount, false);
                anyItemMoved = true;
                break;
            }
            if (anyItemMoved) break;
        }
        if (anyItemMoved) {
            this.setChanged();
            this.sendData();
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private ItemStack insertItemIntoTarget(ItemStack stack, IItemHandler targetInventory) {
        ItemStack remaining = stack.copy();
        for (int slot = 0; slot < targetInventory.getSlots() && !remaining.isEmpty(); ++slot) {
            remaining = targetInventory.insertItem(slot, remaining, false);
        }
        return remaining;
    }

    protected boolean canAcceptItem(ItemStack stack) {
        boolean canAccept = this.filtering.test(stack);
        return canAccept;
    }

    protected int getExtractionAmount() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? this.filtering.getAmount() : 64;
    }

    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() && !this.filtering.upTo ? ItemHelper.ExtractionCountMode.EXACTLY : ItemHelper.ExtractionCountMode.UPTO;
    }

    public void dropInventory() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = Vec3.atCenterOf((Vec3i)this.worldPosition);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemEntity itemEntity = new ItemEntity(this.level, pos.x, pos.y, pos.z, stack);
                serverLevel.addFreshEntity((Entity)itemEntity);
                this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"gui.goggles.smart_mesh_contents", (Object[])new Object[0]).forGoggles(tooltip);
        ItemStackHandler inv = this.getInventory();
        boolean isEmpty = true;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            isEmpty = false;
            CreateLang.text((String)"").add(Component.translatable((String)stack.getDescriptionId()).withStyle(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stack.getCount())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        if (isEmpty) {
            CreateLang.translate((String)"gui.goggles.inventory.empty", (Object[])new Object[0]).forGoggles(tooltip, 1);
        }
        return true;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.putInt("ProcessingTicks", this.processingTicks);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.processingTicks = compound.getInt("ProcessingTicks");
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CreateFisheryBlockEntities.SMART_MESH.get(), (be, side) -> be.inventory);
    }

    private static class InsertionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public InsertionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.wrapped.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack) && this.canAcceptItem(stack);
        }

        private boolean canAcceptItem(ItemStack stack) {
            if (this.wrapped instanceof ItemStackHandler) {
                for (int i = 0; i < this.wrapped.getSlots(); ++i) {
                    ItemStack slotStack = this.wrapped.getStackInSlot(i);
                    if (!slotStack.isEmpty() && (!ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)stack) || slotStack.getCount() >= slotStack.getMaxStackSize())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    private static class ExtractionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public ExtractionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.wrapped.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }
}

