/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.SmartNozzle;

import com.adonis.createfisheryindustry.block.SmartNozzle.SmartNozzleBlock;
import com.adonis.createfisheryindustry.block.SmartNozzle.SmartNozzleFilterSlotPositioning;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlockEntities;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.particle.FluidParticleData;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.NozzleBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SmartNozzleBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected static final int INVENTORY_SLOTS = 9;
    protected static final double COLLECTION_RANGE = 1.5;
    protected static final int PROCESSING_TIME = 10;
    protected final ItemStackHandler inventory;
    protected int processingTicks = 0;
    private List<ItemEntity> pullingItems = new ArrayList<ItemEntity>();
    private List<Entity> pushingEntities = new ArrayList<Entity>();
    private float range;
    private boolean pushing;
    private BlockPos fanPos;
    private final Lazy<IItemHandler> insertionHandler;
    private final Lazy<IItemHandler> extractionHandler;
    protected FilteringBehaviour filtering;

    public SmartNozzleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = this.createInventory();
        this.setLazyTickRate(5);
        this.insertionHandler = Lazy.of(() -> new InsertionOnlyItemHandler((IItemHandler)this.inventory));
        this.extractionHandler = Lazy.of(() -> new ExtractionOnlyItemHandler((IItemHandler)this.inventory));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SmartNozzleFilterSlotPositioning());
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    protected ItemStackHandler createInventory() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                SmartNozzleBlockEntity.this.setChanged();
                if (SmartNozzleBlockEntity.this.level != null && !SmartNozzleBlockEntity.this.level.isClientSide()) {
                    SmartNozzleBlockEntity.this.level.sendBlockUpdated(SmartNozzleBlockEntity.this.worldPosition, SmartNozzleBlockEntity.this.getBlockState(), SmartNozzleBlockEntity.this.getBlockState(), 3);
                }
            }
        };
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public FilteringBehaviour getFiltering() {
        return this.filtering;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SmartNozzleBlockEntity be) {
        be.tickNozzle();
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ++be.processingTicks;
            if (be.processingTicks >= 10) {
                be.processingTicks = 0;
                be.collectNearbyItems(serverLevel);
                be.setChanged();
                be.sendData();
                serverLevel.sendBlockUpdated(pos, state, state, 3);
            }
        }
    }

    private void tickNozzle() {
        int probability;
        float range = this.calcRange();
        if (this.range != range) {
            this.setRange(range);
        }
        Vec3 center = Vec3.atCenterOf((Vec3i)this.worldPosition);
        if (this.level.isClientSide && range != 0.0f && this.level.random.nextInt(probability = Mth.clamp((int)(10 - (int)range), (int)1, (int)10)) == 0) {
            Vec3 start = VecHelper.offsetRandomly((Vec3)center, (RandomSource)this.level.random, (float)(this.pushing ? 1.0f : range / 2.0f));
            float speedFactor = this.pushing ? 0.05f : 1.0f;
            Vec3 motion = center.subtract(start).normalize().scale((double)(Mth.clamp((float)(range * speedFactor), (float)0.0f, (float)0.5f) * (float)(this.pushing ? -1 : 1)));
            boolean inWater = (Boolean)this.getBlockState().getValue((Property)SmartNozzleBlock.WATERLOGGED);
            if (inWater) {
                this.level.addParticle((ParticleOptions)new FluidParticleData(AllParticleTypes.FLUID_DRIP.get(), new FluidStack((Fluid)Fluids.WATER, 1000)), start.x, start.y, start.z, motion.x, motion.y, motion.z);
            } else {
                this.level.addParticle((ParticleOptions)ParticleTypes.POOF, start.x, start.y, start.z, motion.x, motion.y, motion.z);
            }
        }
        Iterator<ItemEntity> iterator = this.pullingItems.iterator();
        while (iterator.hasNext()) {
            ItemEntity item = iterator.next();
            Vec3 diff = item.position().subtract(center);
            double distance = diff.length();
            if (distance > (double)range || !item.isAlive()) {
                iterator.remove();
                continue;
            }
            if (!this.pushing && distance < 1.5) continue;
            Vec3 pullVec = diff.normalize().scale(((double)range - distance) * (double)(this.pushing ? 1 : -1));
            item.setDeltaMovement(item.getDeltaMovement().add(pullVec.scale(0.0078125)));
            item.fallDistance = 0.0f;
            item.hurtMarked = true;
        }
        this.lazyTickNozzle();
    }

    private void lazyTickNozzle() {
        if (this.range == 0.0f) {
            return;
        }
        Vec3 center = Vec3.atCenterOf((Vec3i)this.worldPosition);
        AABB bb = new AABB(center, center).inflate((double)(this.range / 2.0f));
        for (ItemEntity item : this.level.getEntitiesOfClass(ItemEntity.class, bb)) {
            Vec3 diff = item.position().subtract(center);
            double distance = diff.length();
            if (distance > (double)this.range || !item.isAlive()) continue;
            if (this.filtering != null && !this.filtering.getFilter().isEmpty() && !this.filtering.test(item.getItem())) {
                this.pullingItems.remove(item);
                continue;
            }
            boolean canSee = this.canSee(item);
            if (!canSee) {
                this.pullingItems.remove(item);
                continue;
            }
            if (this.pullingItems.contains(item)) continue;
            this.pullingItems.add(item);
        }
        Iterator<ItemEntity> iterator = this.pullingItems.iterator();
        while (iterator.hasNext()) {
            ItemEntity item;
            item = iterator.next();
            if (item.isAlive()) continue;
            iterator.remove();
        }
    }

    private float calcRange() {
        BlockEntity be;
        if (this.fanPos == null) {
            this.fanPos = this.worldPosition.relative(((Direction)this.getBlockState().getValue((Property)NozzleBlock.FACING)).getOpposite());
        }
        if (!((be = this.level.getBlockEntity(this.fanPos)) instanceof IAirCurrentSource)) {
            return 0.0f;
        }
        IAirCurrentSource source = (IAirCurrentSource)be;
        if (source.getAirCurrent() == null || source.getSpeed() == 0.0f) {
            return 0.0f;
        }
        this.pushing = source.getAirFlowDirection() == source.getAirflowOriginSide();
        return source.getMaxDistance();
    }

    private boolean canSee(ItemEntity item) {
        Vec3 start = item.position();
        Vec3 end = Vec3.atCenterOf((Vec3i)this.worldPosition);
        return this.level.clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)item)).getBlockPos().equals((Object)this.worldPosition);
    }

    public void setRange(float range) {
        this.range = range;
        if (range == 0.0f) {
            this.pushingEntities.clear();
        }
        this.sendData();
    }

    protected void collectNearbyItems(ServerLevel level) {
        AABB boundingBox = new AABB(this.getBlockPos()).inflate(1.5);
        List items = level.getEntitiesOfClass(ItemEntity.class, boundingBox);
        for (ItemEntity itemEntity : items) {
            ItemStack stack;
            if (itemEntity == null || !itemEntity.isAlive() || (stack = itemEntity.getItem()).isEmpty() || !this.canAcceptItem(stack)) continue;
            ItemStack copy = stack.copy();
            if (this.insertItem(copy)) {
                itemEntity.discard();
                continue;
            }
            if (copy.getCount() >= stack.getCount()) continue;
            itemEntity.setItem(copy);
        }
    }

    protected boolean canAcceptItem(ItemStack stack) {
        return this.filtering.test(stack);
    }

    public boolean insertItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ItemStack remainder = stack.copy();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!(remainder = this.inventory.insertItem(i, remainder, false)).isEmpty()) continue;
            return true;
        }
        return stack.getCount() != remainder.getCount();
    }

    public void dropInventory() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = Vec3.atCenterOf((Vec3i)this.worldPosition);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemEntity itemEntity = new ItemEntity(this.level, pos.x, pos.y, pos.z, stack);
                serverLevel.addFreshEntity((Entity)itemEntity);
                this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.putInt("ProcessingTicks", this.processingTicks);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.processingTicks = compound.getInt("ProcessingTicks");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"gui.goggles.smart_nozzle_contents", (Object[])new Object[0]).forGoggles(tooltip);
        ItemStackHandler inv = this.getInventory();
        boolean isEmpty = true;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            isEmpty = false;
            CreateLang.text((String)"").add(Component.translatable((String)stack.getDescriptionId()).withStyle(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stack.getCount())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        if (isEmpty) {
            CreateLang.translate((String)"gui.goggles.inventory.empty", (Object[])new Object[0]).forGoggles(tooltip, 1);
        }
        return true;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CreateFisheryBlockEntities.SMART_NOZZLE.get(), (be, side) -> be.inventory);
    }

    private static class ExtractionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public ExtractionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.wrapped.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }

    private static class InsertionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public InsertionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.wrapped.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }
}

