/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.TrapNozzle;

import com.adonis.createfisheryindustry.block.TrapNozzle.TrapNozzleBlockEntity;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlockEntities;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.NozzleBlock;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmItem;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TrapNozzleBlock
extends NozzleBlock
implements ProperWaterloggedBlock {
    public TrapNozzleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        return this.withWater(state, context);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        this.updateWater(level, state, currentPos);
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)CreateFisheryBlockEntities.TRAP_NOZZLE.get()).create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == CreateFisheryBlockEntities.TRAP_NOZZLE.get() ? (lvl, pos, blockState, be) -> TrapNozzleBlockEntity.tick(lvl, pos, blockState, (TrapNozzleBlockEntity)be) : null;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof TrapNozzleBlockEntity) {
                TrapNozzleBlockEntity trapNozzle = (TrapNozzleBlockEntity)be;
                trapNozzle.dropInventory();
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.NOZZLE.get((Direction)state.getValue((Property)FACING));
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction towardsFan = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockEntity be = worldIn.getBlockEntity(pos.relative(towardsFan));
        return be instanceof IAirCurrentSource && ((IAirCurrentSource)be).getAirflowOriginSide() == towardsFan.getOpposite();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int i;
        if (stack.getItem() instanceof WrenchItem) {
            InteractionResult result;
            UseOnContext wrenchContext = new UseOnContext(level, player, hand, stack, hitResult);
            InteractionResult interactionResult = result = player.isShiftKeyDown() ? this.onSneakWrenched(state, wrenchContext) : this.onWrenched(state, wrenchContext);
            if (result != InteractionResult.PASS) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        if (stack.getItem() instanceof ArmItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof TrapNozzleBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        TrapNozzleBlockEntity trapNozzle = (TrapNozzleBlockEntity)be;
        ItemStackHandler inventory = trapNozzle.getInventory();
        if (inventory == null) {
            return ItemInteractionResult.FAIL;
        }
        ItemStack extracted = ItemStack.EMPTY;
        int totalItems = 0;
        for (i = 0; i < inventory.getSlots(); ++i) {
            ItemStack slotStack = inventory.getStackInSlot(i);
            if (slotStack.isEmpty()) continue;
            totalItems += slotStack.getCount();
        }
        for (i = 0; i < inventory.getSlots() && (extracted = inventory.extractItem(i, 64, false)).isEmpty(); ++i) {
        }
        if (!extracted.isEmpty()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extracted);
            player.displayClientMessage((Component)Component.translatable((String)"create_fishery.trap_nozzle.extracted", (Object[])new Object[]{extracted.getCount(), Component.translatable((String)extracted.getDescriptionId())}), true);
            return ItemInteractionResult.sidedSuccess((boolean)false);
        }
        if (totalItems > 0) {
            player.displayClientMessage((Component)Component.translatable((String)"create_fishery.trap_nozzle.extraction_failed"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"create_fishery.trap_nozzle.empty"), true);
        }
        return ItemInteractionResult.CONSUME;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return 0;
    }
}

