/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.TrapNozzle;

import com.adonis.createfisheryindustry.block.TrapNozzle.TrapNozzleBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

class TrapNozzleInteractionPoint
extends ArmInteractionPoint {
    public TrapNozzleInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    protected Vec3 getInteractionPositionVector() {
        return Vec3.atLowerCornerOf((Vec3i)this.pos).add(0.5, 0.875, 0.5);
    }

    protected IItemHandler getHandler() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof TrapNozzleBlockEntity) {
            TrapNozzleBlockEntity trapNozzle = (TrapNozzleBlockEntity)blockEntity;
            return trapNozzle.getInventory();
        }
        return null;
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        IItemHandler handler = this.getHandler();
        if (handler == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    public ItemStack extract(int slot, int amount, boolean simulate) {
        IItemHandler handler = this.getHandler();
        if (handler == null) {
            return ItemStack.EMPTY;
        }
        return handler.extractItem(slot, amount, simulate);
    }

    public int getSlotCount() {
        IItemHandler handler = this.getHandler();
        return handler != null ? handler.getSlots() : 0;
    }
}

