/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.client.renderer;

import com.adonis.createfisheryindustry.CreateFisheryMod;
import com.adonis.createfisheryindustry.entity.HarpoonEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class HarpoonRenderer
extends EntityRenderer<HarpoonEntity> {
    private static final ModelResourceLocation MODEL_LOCATION = ModelResourceLocation.standalone((ResourceLocation)CreateFisheryMod.asResource("entity/harpoon"));
    private BakedModel cachedModel;

    public HarpoonRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(HarpoonEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        if (this.cachedModel == null) {
            ModelManager modelManager = Minecraft.getInstance().getModelManager();
            this.cachedModel = modelManager.getModel(MODEL_LOCATION);
            if (this.cachedModel == modelManager.getMissingModel()) {
                return;
            }
        }
        poseStack.pushPose();
        float yaw = Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        float pitch = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        poseStack.mulPose(Axis.YP.rotationDegrees(yaw - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(pitch + 90.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.translate(-0.5, -0.5, 0.0);
        float scale = 1.0f;
        poseStack.scale(scale, scale, scale);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        PoseStack.Pose pose = poseStack.last();
        RandomSource random = RandomSource.create((long)42L);
        ModelData modelData = ModelData.EMPTY;
        for (Direction direction : Direction.values()) {
            List quads = this.cachedModel.getQuads(null, direction, random, modelData, null);
            for (BakedQuad quad : quads) {
                vertexConsumer.putBulkData(pose, quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
        List quads = this.cachedModel.getQuads(null, null, random, modelData, null);
        for (BakedQuad quad : quads) {
            vertexConsumer.putBulkData(pose, quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull HarpoonEntity entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

