/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.event;

import com.adonis.createfisheryindustry.entity.TetheredHarpoonEntity;
import com.adonis.createfisheryindustry.registry.CreateFisheryItems;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="createfisheryindustry")
public class HarpoonItemPickupHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HarpoonItemPickupHandler.class);

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity.level().isClientSide) {
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            HarpoonItemPickupHandler.handleItemEntity(itemEntity);
        }
        if (entity instanceof ExperienceOrb) {
            ExperienceOrb orb = (ExperienceOrb)entity;
            HarpoonItemPickupHandler.handleExperienceOrb(orb);
        }
    }

    private static void handleItemEntity(ItemEntity itemEntity) {
        if (itemEntity.isRemoved() || !itemEntity.hasPickUpDelay()) {
            Player player;
            double distance;
            CompoundTag tag = itemEntity.getPersistentData();
            if (!tag.getBoolean("HarpoonTethered")) {
                return;
            }
            int tetherPlayerId = tag.getInt("TetherPlayerId");
            Level world = itemEntity.level();
            Entity playerEntity = world.getEntity(tetherPlayerId);
            if (playerEntity instanceof Player && ((distance = (double)itemEntity.distanceTo((Entity)(player = (Player)playerEntity))) < 1.5 || itemEntity.isRemoved())) {
                HarpoonItemPickupHandler.resetHarpoonGunState(player);
                tag.remove("HarpoonTethered");
                tag.remove("TetherPlayerId");
                tag.remove("TetherEndTime");
                LOGGER.debug("Item {} picked up, resetting harpoon gun for player {}", (Object)itemEntity.getItem(), (Object)player.getName().getString());
            }
        }
    }

    private static void handleExperienceOrb(ExperienceOrb orb) {
        if (orb.isRemoved()) {
            CompoundTag tag = orb.getPersistentData();
            if (!tag.getBoolean("HarpoonTethered")) {
                return;
            }
            int tetherPlayerId = tag.getInt("TetherPlayerId");
            Level world = orb.level();
            Entity playerEntity = world.getEntity(tetherPlayerId);
            if (playerEntity instanceof Player) {
                Player player = (Player)playerEntity;
                HarpoonItemPickupHandler.resetHarpoonGunState(player);
                tag.remove("HarpoonTethered");
                tag.remove("TetherPlayerId");
                tag.remove("TetherEndTime");
                LOGGER.debug("Experience orb picked up, resetting harpoon gun for player {}", (Object)player.getName().getString());
            }
        }
    }

    private static void resetHarpoonGunState(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        boolean reset = false;
        if (mainHand.getItem() == CreateFisheryItems.PNEUMATIC_HARPOON_GUN.get()) {
            boolean bl = reset = HarpoonItemPickupHandler.resetItemStack(mainHand, player) || reset;
        }
        if (offHand.getItem() == CreateFisheryItems.PNEUMATIC_HARPOON_GUN.get()) {
            boolean bl = reset = HarpoonItemPickupHandler.resetItemStack(offHand, player) || reset;
        }
        if (reset) {
            Level world = player.level();
            List harpoons = world.getEntitiesOfClass(TetheredHarpoonEntity.class, player.getBoundingBox().inflate(100.0), e -> e.getOwner() == player && !e.isRetrieving());
            harpoons.forEach(TetheredHarpoonEntity::startRetrieving);
        }
    }

    private static boolean resetItemStack(ItemStack itemstack, Player player) {
        CustomData customData = (CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (customData.copyTag().getBoolean("tagPullingItem")) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> {
                tag.putBoolean("tagHooked", false);
                tag.putBoolean("tagPullingItem", false);
                tag.remove("tagPulledEntityId");
                tag.remove("tagHookedEntityId");
                tag.remove("xPostion");
                tag.remove("yPostion");
                tag.remove("zPostion");
                tag.remove("AccumulatedAirConsumption");
                tag.putLong("CooldownEndTick", player.level().getGameTime() + 5L);
            });
            LOGGER.debug("Reset harpoon gun state for player {}", (Object)player.getName().getString());
            return true;
        }
        return false;
    }
}

