/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.event;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="createfisheryindustry")
public class HarpoonTetherHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HarpoonTetherHandler.class);
    private static final double MAX_TETHER_DISTANCE = 1.0;
    private static final double TETHER_SPEED = 0.2;
    private static final double TETHER_UPWARD_FORCE = 0.1;

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        CompoundTag tag;
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (level.isClientSide) {
            return;
        }
        if ((entity instanceof ItemEntity || entity instanceof ExperienceOrb) && (tag = entity.getPersistentData()).getBoolean("HarpoonTethered")) {
            long tetherEndTime = tag.getLong("TetherEndTime");
            int playerId = tag.getInt("TetherPlayerId");
            Player player = (Player)level.getEntity(playerId);
            if (level.getGameTime() >= tetherEndTime || player == null || !player.isAlive()) {
                tag.remove("HarpoonTethered");
                tag.remove("TetherPlayerId");
                tag.remove("TetherEndTime");
                return;
            }
            Vec3 playerPos = player.position().add(0.0, (double)player.getEyeHeight() * 0.5, 0.0);
            Vec3 entityPos = entity.position();
            double dx = playerPos.x - entityPos.x;
            double dy = playerPos.y - entityPos.y;
            double dz = playerPos.z - entityPos.z;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (distance < 1.0) {
                tag.remove("HarpoonTethered");
                tag.remove("TetherPlayerId");
                tag.remove("TetherEndTime");
                return;
            }
            Vec3 motion = new Vec3(dx * 0.2, dy * 0.2 + 0.1, dz * 0.2);
            entity.setDeltaMovement(motion);
        }
    }
}

