/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.item;

import com.adonis.createfisheryindustry.item.HarpoonPouchContents;
import com.adonis.createfisheryindustry.item.HarpoonPouchTooltip;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.math.Fraction;

@OnlyIn(value=Dist.CLIENT)
public class ClientHarpoonPouchTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"createfisheryindustry", (String)"container/pouch/background");
    private static final int MARGIN_Y = 4;
    private static final int BORDER_WIDTH = 1;
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 20;
    private final HarpoonPouchContents contents;

    public ClientHarpoonPouchTooltip(HarpoonPouchTooltip tooltip) {
        this.contents = tooltip.contents();
    }

    public int getHeight() {
        return this.backgroundHeight() + 4;
    }

    public int getWidth(Font font) {
        return this.backgroundWidth();
    }

    private int backgroundWidth() {
        return this.gridSizeX() * 18 + 2;
    }

    private int backgroundHeight() {
        return this.gridSizeY() * 20 + 2;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        int gridX = this.gridSizeX();
        int gridY = this.gridSizeY();
        guiGraphics.blitSprite(BACKGROUND_SPRITE, x, y, this.backgroundWidth(), this.backgroundHeight());
        boolean isFull = this.contents.weight().compareTo(Fraction.ONE) >= 0;
        int itemIndex = 0;
        for (int row = 0; row < gridY; ++row) {
            for (int col = 0; col < gridX; ++col) {
                int slotX = x + col * 18 + 1;
                int slotY = y + row * 20 + 1;
                this.renderSlot(slotX, slotY, itemIndex++, isFull, guiGraphics, font);
            }
        }
    }

    private void renderSlot(int x, int y, int itemIndex, boolean isFull, GuiGraphics guiGraphics, Font font) {
        if (itemIndex >= this.contents.size()) {
            this.blit(guiGraphics, x, y, isFull ? Texture.BLOCKED_SLOT : Texture.SLOT);
        } else {
            this.blit(guiGraphics, x, y, Texture.SLOT);
            ItemStack itemstack = this.contents.getItemUnsafe(itemIndex);
            guiGraphics.renderItem(itemstack, x + 1, y + 1, itemIndex);
            guiGraphics.renderItemDecorations(font, itemstack, x + 1, y + 1);
            if (itemIndex == 0) {
                AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(x + 1), (int)(y + 1), (int)0);
            }
        }
    }

    private void blit(GuiGraphics guiGraphics, int x, int y, Texture texture) {
        guiGraphics.blitSprite(texture.sprite, x, y, 0, texture.w, texture.h);
    }

    private int gridSizeX() {
        return Math.max(2, (int)Math.ceil(Math.sqrt((double)this.contents.size() + 1.0)));
    }

    private int gridSizeY() {
        return (int)Math.ceil(((double)this.contents.size() + 1.0) / (double)this.gridSizeX());
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Texture {
        SLOT(ResourceLocation.fromNamespaceAndPath((String)"createfisheryindustry", (String)"container/pouch/slot"), 18, 20),
        BLOCKED_SLOT(ResourceLocation.fromNamespaceAndPath((String)"createfisheryindustry", (String)"container/pouch/blocked_slot"), 18, 20);

        public final ResourceLocation sprite;
        public final int w;
        public final int h;

        private Texture(ResourceLocation sprite, int w, int h) {
            this.sprite = sprite;
            this.w = w;
            this.h = h;
        }
    }
}

