/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.item;

import com.adonis.createfisheryindustry.item.HarpoonItem;
import com.adonis.createfisheryindustry.item.HarpoonPouchContents;
import com.adonis.createfisheryindustry.item.HarpoonPouchTooltip;
import com.adonis.createfisheryindustry.registry.CreateFisheryComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class HarpoonPouchItem
extends Item {
    private static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);
    private static final int TOOLTIP_MAX_WEIGHT = 4;

    public HarpoonPouchItem(Item.Properties properties) {
        super(properties);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        if (!stack.has((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get())) {
            stack.set((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
        }
    }

    public static float getFullnessDisplay(ItemStack stack) {
        HarpoonPouchContents contents = (HarpoonPouchContents)stack.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
        return contents.weight().floatValue();
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        int inserted;
        if (stack.getCount() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        HarpoonPouchContents contents = (HarpoonPouchContents)stack.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
        HarpoonPouchContents.Mutable mutableContents = new HarpoonPouchContents.Mutable(contents);
        ItemStack slotItem = slot.getItem();
        if (slotItem.isEmpty()) {
            ItemStack removed = mutableContents.removeOne();
            if (removed != null) {
                this.playRemoveOneSound((Entity)player);
                ItemStack remaining = slot.safeInsert(removed);
                mutableContents.tryInsert(remaining);
                stack.set((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)mutableContents.toImmutable());
                return true;
            }
        } else if ((slotItem.getItem() instanceof HarpoonItem || slotItem.getItem() == Items.TRIDENT) && (inserted = mutableContents.tryTransfer(slot, player)) > 0) {
            this.playInsertSound((Entity)player);
            stack.set((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)mutableContents.toImmutable());
            return true;
        }
        return false;
    }

    private static boolean isValidForPouch(ItemStack stack) {
        return stack.getItem() instanceof HarpoonItem || stack.getItem() == Items.TRIDENT;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        int inserted;
        if (stack.getCount() != 1 || action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        HarpoonPouchContents contents = (HarpoonPouchContents)stack.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
        HarpoonPouchContents.Mutable mutableContents = new HarpoonPouchContents.Mutable(contents);
        if (other.isEmpty()) {
            ItemStack removed = mutableContents.removeOne();
            if (removed != null) {
                this.playRemoveOneSound((Entity)player);
                access.set(removed);
            }
        } else if (other.getItem() instanceof HarpoonItem && (inserted = mutableContents.tryInsert(other)) > 0) {
            this.playInsertSound((Entity)player);
        }
        stack.set((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)mutableContents.toImmutable());
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (HarpoonPouchItem.dropContents(stack, player)) {
            this.playDropContentsSound((Entity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        HarpoonPouchContents contents = (HarpoonPouchContents)stack.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
        return contents.weight().compareTo(Fraction.ZERO) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        HarpoonPouchContents contents = (HarpoonPouchContents)stack.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate((Fraction)contents.weight(), (int)12), 13);
    }

    public int getBarColor(ItemStack stack) {
        return BAR_COLOR;
    }

    private static boolean dropContents(ItemStack stack, Player player) {
        HarpoonPouchContents contents = (HarpoonPouchContents)stack.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
        if (!contents.isEmpty()) {
            stack.set((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
            if (player instanceof ServerPlayer) {
                contents.itemsCopy().forEach(item -> player.drop(item, true));
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (stack.has(DataComponents.HIDE_TOOLTIP) || stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return Optional.empty();
        }
        HarpoonPouchContents contents = (HarpoonPouchContents)stack.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
        return Optional.of(new HarpoonPouchTooltip(contents));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        HarpoonPouchContents contents = (HarpoonPouchContents)stack.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
        int weight = Mth.mulAndTruncate((Fraction)contents.weight(), (int)4);
        tooltip.add((Component)Component.translatable((String)"item.createfisheryindustry.harpoon_pouch.fullness", (Object[])new Object[]{weight, 4}));
    }

    public void onDestroyed(ItemEntity itemEntity) {
        HarpoonPouchContents contents = (HarpoonPouchContents)itemEntity.getItem().getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
        if (!contents.isEmpty()) {
            itemEntity.getItem().set((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, contents.itemsCopy());
        }
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }
}

