/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.item;

import com.adonis.createfisheryindustry.client.renderer.PneumaticHarpoonGunItemRenderer;
import com.adonis.createfisheryindustry.entity.TetheredHarpoonEntity;
import com.adonis.createfisheryindustry.procedures.PneumaticHarpoonGunItemInHandTickProcedure;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PneumaticHarpoonGunItem
extends Item
implements CustomArmPoseItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(PneumaticHarpoonGunItem.class);
    public static final int MAX_DAMAGE = 250;
    private static final int LAUNCH_AIR_CONSUMPTION = 5;
    private static final int COOLDOWN_TICKS = 10;
    private static final double MAX_RANGE = 50.0;

    public PneumaticHarpoonGunItem(Item.Properties properties) {
        super(properties.stacksTo(1).durability(250));
    }

    private static int maxUses() {
        return (Integer)AllConfigs.server().equipment.maxExtendoGripActions.get();
    }

    private boolean isValidTarget(Entity entity) {
        if (entity.isSpectator()) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            return true;
        }
        if (entity instanceof ItemEntity) {
            return true;
        }
        if (entity instanceof ExperienceOrb) {
            return true;
        }
        return entity.isPickable();
    }

    private HitResult getPlayerTarget(Player player, double range) {
        double blockDist;
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 endPos = eyePos.add(lookVec.scale(range));
        AABB searchBox = new AABB(eyePos, endPos).inflate(1.5);
        Entity closestEntity = null;
        double closestDistance = range * range;
        for (Entity entity : player.level().getEntities((Entity)player, searchBox)) {
            double distance;
            AABB entityBox;
            Optional hitPos;
            if (!this.isValidTarget(entity) || !(hitPos = (entityBox = entity.getBoundingBox().inflate((double)entity.getPickRadius())).clip(eyePos, endPos)).isPresent() || !((distance = eyePos.distanceToSqr((Vec3)hitPos.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        ClipContext clipContext = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult blockHit = player.level().clip(clipContext);
        if (closestEntity != null && closestDistance < (blockDist = eyePos.distanceToSqr(blockHit.getLocation()))) {
            return new EntityHitResult(closestEntity);
        }
        return blockHit;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (selected || player.getOffhandItem() == itemstack) {
                PneumaticHarpoonGunItemInHandTickProcedure.execute((LevelAccessor)world, player.getX(), player.getY(), player.getZ(), (Entity)player, itemstack);
                CustomData customData = (CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                if (customData.copyTag().contains("CooldownEndTick")) {
                    long cooldownEndTick = customData.copyTag().getLong("CooldownEndTick");
                    if (world.getGameTime() >= cooldownEndTick) {
                        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.remove("CooldownEndTick"));
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!world.isClientSide()) {
            List activeHarpoons;
            CustomData customData = (CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            boolean tagHooked = customData.copyTag().getBoolean("tagHooked");
            if (customData.copyTag().contains("CooldownEndTick")) {
                long cooldownEndTick = customData.copyTag().getLong("CooldownEndTick");
                if (world.getGameTime() < cooldownEndTick) {
                    return InteractionResultHolder.pass((Object)itemstack);
                }
            }
            if (!(activeHarpoons = world.getEntitiesOfClass(TetheredHarpoonEntity.class, player.getBoundingBox().inflate(100.0), e -> e.getOwner() == player && !e.isRetrieving())).isEmpty() || tagHooked) {
                activeHarpoons.forEach(TetheredHarpoonEntity::startRetrieving);
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> {
                    tag.putBoolean("tagHooked", false);
                    tag.remove("tagHookedEntityId");
                    tag.remove("xPostion");
                    tag.remove("yPostion");
                    tag.remove("zPostion");
                    tag.remove("AccumulatedAirConsumption");
                    tag.putLong("CooldownEndTick", world.getGameTime() + 10L);
                });
                player.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.armor.equip_chain")), 1.0f, 1.0f);
                return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)false);
            }
            HitResult hitResult = this.getPlayerTarget(player, 50.0);
            if (player.isShiftKeyDown() && !(hitResult instanceof EntityHitResult)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    sp.displayClientMessage((Component)Component.translatable((String)"create_fishery.pneumatic_harpoon_gun.must_aim_entity"), true);
                }
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (hitResult.getType() == HitResult.Type.MISS) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!BacktankUtil.canAbsorbDamage((LivingEntity)player, (int)PneumaticHarpoonGunItem.maxUses())) {
                itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            Vec3 eyePos = player.getEyePosition(1.0f);
            Vec3 hitPos = hitResult.getLocation();
            TetheredHarpoonEntity harpoon = new TetheredHarpoonEntity(world, player, eyePos);
            Vec3 direction = hitPos.subtract(eyePos).normalize();
            harpoon.setYRot((float)(Math.atan2(direction.x, direction.z) * 57.29577951308232));
            harpoon.setXRot((float)(Math.atan2(direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z)) * 57.29577951308232));
            world.addFreshEntity((Entity)harpoon);
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult entityHit = (EntityHitResult)hitResult;
                Entity target = entityHit.getEntity();
                if (target instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)target;
                    Vec3 targetPos = living.position().add(0.0, (double)living.getBbHeight() * 0.5, 0.0);
                    harpoon.setPos(targetPos);
                    harpoon.setHitEntity((Entity)living, harpoon.tickCount);
                    float baseDamage = 7.0f;
                    int impalingLevel = itemstack.getEnchantmentLevel((Holder)player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.IMPALING));
                    if (impalingLevel > 0) {
                        baseDamage += (float)impalingLevel * 2.5f;
                    }
                    living.hurt(world.damageSources().trident((Entity)harpoon, (Entity)player), baseDamage);
                    living.setLastHurtByPlayer(player);
                    harpoon.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.trident.hit")), 1.0f, 1.0f);
                } else if (target instanceof ItemEntity || target instanceof ExperienceOrb) {
                    Vec3 targetPos = target.position();
                    harpoon.setPos(targetPos);
                    long tetherEndTime = world.getGameTime() + 200L;
                    CompoundTag tag3 = target.getPersistentData();
                    tag3.putBoolean("HarpoonTethered", true);
                    tag3.putInt("TetherPlayerId", player.getId());
                    tag3.putLong("TetherEndTime", tetherEndTime);
                    Vec3 pullDirection = eyePos.subtract(targetPos).normalize();
                    target.setDeltaMovement(pullDirection.scale(0.8));
                    target.hasImpulse = true;
                    if (target instanceof ItemEntity) {
                        ItemEntity itemEntity = (ItemEntity)target;
                        itemEntity.setPickUpDelay(10);
                    }
                    harpoon.startRetrieving();
                    CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag2 -> {
                        tag2.putBoolean("tagPullingItem", true);
                        tag2.putInt("tagPulledEntityId", target.getId());
                    });
                    harpoon.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.fishing_bobber.retrieve")), 1.0f, 1.0f);
                } else {
                    Vec3 targetPos = target.position();
                    harpoon.setPos(targetPos);
                    harpoon.startRetrieving();
                    harpoon.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.fishing_bobber.retrieve")), 1.0f, 1.0f);
                }
            } else if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)hitResult;
                harpoon.setPos(hitPos);
                harpoon.setAnchored(blockHit.getBlockPos());
                harpoon.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.trident.hit_ground")), 1.0f, 1.0f);
            }
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> {
                tag.putFloat("AccumulatedAirConsumption", 0.0f);
                tag.putBoolean("tagHooked", true);
            });
            player.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), 1.0f, 1.0f);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)world.isClientSide());
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.MENDING)) {
            return true;
        }
        if (enchantment.is(Enchantments.UNBREAKING)) {
            return true;
        }
        if (enchantment.is(Enchantments.IMPALING)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public boolean isBarVisible(ItemStack stack) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return this.isBarVisibleClient(stack);
        }
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)PneumaticHarpoonGunItem.maxUses());
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isBarVisibleClient(ItemStack stack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return stack.isDamaged();
        }
        List backtanks = BacktankUtil.getAllWithAir((LivingEntity)player);
        if (backtanks.isEmpty()) {
            return stack.isDamaged();
        }
        return BacktankUtil.isBarVisible((ItemStack)((ItemStack)backtanks.get(0)), (int)PneumaticHarpoonGunItem.maxUses()) || stack.isDamaged();
    }

    public int getBarWidth(ItemStack stack) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return this.getBarWidthClient(stack);
        }
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)PneumaticHarpoonGunItem.maxUses());
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getBarWidthClient(ItemStack stack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return Math.round(13.0f - (float)stack.getDamageValue() * 13.0f / (float)stack.getMaxDamage());
        }
        List backtanks = BacktankUtil.getAllWithAir((LivingEntity)player);
        if (backtanks.isEmpty()) {
            return Math.round(13.0f - (float)stack.getDamageValue() * 13.0f / (float)stack.getMaxDamage());
        }
        if (BacktankUtil.getAir((ItemStack)((ItemStack)backtanks.get(0))) > 0) {
            return BacktankUtil.getBarWidth((ItemStack)((ItemStack)backtanks.get(0)), (int)PneumaticHarpoonGunItem.maxUses());
        }
        return Math.round(13.0f - (float)stack.getDamageValue() * 13.0f / (float)stack.getMaxDamage());
    }

    public int getBarColor(ItemStack stack) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return this.getBarColorClient(stack);
        }
        return BacktankUtil.getBarColor((ItemStack)stack, (int)PneumaticHarpoonGunItem.maxUses());
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getBarColorClient(ItemStack stack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return super.getBarColor(stack);
        }
        List backtanks = BacktankUtil.getAllWithAir((LivingEntity)player);
        if (backtanks.isEmpty()) {
            return super.getBarColor(stack);
        }
        if (BacktankUtil.getAir((ItemStack)((ItemStack)backtanks.get(0))) > 0) {
            return BacktankUtil.getBarColor((ItemStack)((ItemStack)backtanks.get(0)), (int)PneumaticHarpoonGunItem.maxUses());
        }
        return super.getBarColor(stack);
    }

    @Nullable
    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        return player.getUsedItemHand() == hand ? HumanoidModel.ArmPose.BOW_AND_ARROW : HumanoidModel.ArmPose.ITEM;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new PneumaticHarpoonGunItemRenderer()));
    }
}

