/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.mixin;

import com.adonis.createfisheryindustry.item.CopperDivingLeggingsItem;
import com.adonis.createfisheryindustry.item.NetheriteDivingLeggingsItem;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class}, priority=1200)
public abstract class SprintProtectionMixin {
    @Inject(method={"setSprinting"}, at={@At(value="HEAD")}, cancellable=true)
    private void protectUnderwaterSprint(boolean sprinting, CallbackInfo ci) {
        SprintProtectionMixin sprintProtectionMixin = this;
        if (sprintProtectionMixin instanceof Player) {
            Player player = (Player)sprintProtectionMixin;
            if (!sprinting && SprintProtectionMixin.shouldMaintainUnderwaterSprint(player)) {
                ci.cancel();
            }
        }
    }

    private static boolean shouldMaintainUnderwaterSprint(Player player) {
        boolean hasDivingBoots = player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof DivingBootsItem;
        boolean hasDivingLeggings = player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof CopperDivingLeggingsItem || player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof NetheriteDivingLeggingsItem;
        boolean inFluid = player.isInWater() || player.isInLava();
        boolean hasUnderwaterSprintFlag = player.getPersistentData().getBoolean("CFI_UnderwaterSprintActive");
        return hasDivingBoots && hasDivingLeggings && inFluid && hasUnderwaterSprintFlag;
    }
}

