/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.procedures;

import com.adonis.createfisheryindustry.entity.TetheredHarpoonEntity;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PneumaticHarpoonGunItemInHandTickProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(PneumaticHarpoonGunItemInHandTickProcedure.class);
    private static final double TRACTION_SPEED = 0.5;
    private static final float AIR_CONSUMPTION_RATE_ENTITY = 0.05f;
    private static final float AIR_CONSUMPTION_RATE_BLOCK = 0.1f;
    private static final double MIN_DISTANCE_SQR = 2.0;

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CustomData customData = (CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        boolean tagHooked = customData.copyTag().getBoolean("tagHooked");
        if (!tagHooked) {
            return;
        }
        if (!world.isClientSide()) {
            int hookedEntityId;
            if (BacktankUtil.canAbsorbDamage((LivingEntity)player, (int)PneumaticHarpoonGunItemInHandTickProcedure.maxUses())) {
                List backtanks = BacktankUtil.getAllWithAir((LivingEntity)player);
                float airConsumptionRate = customData.copyTag().contains("tagHookedEntityId") ? 0.05f : 0.1f;
                float currAccumulatedAir = customData.copyTag().getFloat("AccumulatedAirConsumption");
                float newAccumulatedAir = currAccumulatedAir + airConsumptionRate;
                if (newAccumulatedAir >= 1.0f && !backtanks.isEmpty()) {
                    BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)((ItemStack)backtanks.get(0)), (int)1);
                    float finalAccumulatedAir = newAccumulatedAir - 1.0f;
                    CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putFloat("AccumulatedAirConsumption", finalAccumulatedAir));
                } else {
                    CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putFloat("AccumulatedAirConsumption", newAccumulatedAir));
                }
            }
            if ((hookedEntityId = customData.copyTag().getInt("tagHookedEntityId")) > 0) {
                Entity target = ((Level)world).getEntity(hookedEntityId);
                if (target != null && target.isAlive()) {
                    double distanceSqr = player.distanceToSqr(target);
                    if (distanceSqr > 2.0) {
                        double distance = Math.sqrt(distanceSqr);
                        Vec3 playerPos = player.position().add(0.0, (double)player.getBbHeight() * 0.5, 0.0);
                        Vec3 targetPos = target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0);
                        Vec3 pull = playerPos.subtract(targetPos).scale(0.5 / distance);
                        target.setDeltaMovement(target.getDeltaMovement().multiply(0.8, 0.8, 0.8).add(pull));
                        target.hurtMarked = true;
                        PneumaticHarpoonGunItemInHandTickProcedure.playTractionSound(world, player);
                    } else {
                        PneumaticHarpoonGunItemInHandTickProcedure.resetHookState(itemstack, world, player);
                    }
                } else {
                    PneumaticHarpoonGunItemInHandTickProcedure.resetHookState(itemstack, world, player);
                }
                return;
            }
            if (customData.copyTag().contains("xPostion")) {
                double zPos;
                double yPos;
                double xPos = customData.copyTag().getDouble("xPostion");
                BlockPos blockPos = BlockPos.containing((double)xPos, (double)(yPos = customData.copyTag().getDouble("yPostion")), (double)(zPos = customData.copyTag().getDouble("zPostion")));
                if (!world.isEmptyBlock(blockPos)) {
                    double distanceSqr = player.distanceToSqr(xPos, yPos, zPos);
                    if (distanceSqr > 2.0) {
                        double distance = Math.sqrt(distanceSqr);
                        Vec3 pull = new Vec3(xPos - player.getX(), yPos - player.getY(), zPos - player.getZ()).scale(0.5 / distance);
                        player.setDeltaMovement(player.getDeltaMovement().multiply(0.8, 0.8, 0.8).add(pull));
                        player.hurtMarked = true;
                        if (player.getDeltaMovement().y() >= -0.2) {
                            player.fallDistance = 0.0f;
                        }
                        PneumaticHarpoonGunItemInHandTickProcedure.playTractionSound(world, player);
                    } else {
                        PneumaticHarpoonGunItemInHandTickProcedure.resetHookState(itemstack, world, player);
                    }
                } else {
                    PneumaticHarpoonGunItemInHandTickProcedure.resetHookState(itemstack, world, player);
                }
            }
        }
    }

    private static void resetHookState(ItemStack itemstack, LevelAccessor world, Player player) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> {
            tag.putBoolean("tagHooked", false);
            tag.remove("tagHookedEntityId");
            tag.remove("xPostion");
            tag.remove("yPostion");
            tag.remove("zPostion");
            tag.remove("AccumulatedAirConsumption");
        });
        world.getEntitiesOfClass(TetheredHarpoonEntity.class, player.getBoundingBox().inflate(100.0), e -> e.getOwner() == player).forEach(TetheredHarpoonEntity::startRetrieving);
    }

    private static void playTractionSound(LevelAccessor world, Player player) {
        if (world instanceof Level) {
            Level level = (Level)world;
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.armor.equip_chain")), SoundSource.PLAYERS, 0.25f, 0.5f);
        }
    }

    private static int maxUses() {
        return (Integer)AllConfigs.server().equipment.maxExtendoGripActions.get();
    }
}

