/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.recipe;

import com.adonis.createfisheryindustry.CreateFisheryMod;
import com.adonis.createfisheryindustry.recipe.PeelingRecipe;
import com.adonis.createfisheryindustry.recipe.PeelingRecipeParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.DataMapHooks;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

@EventBusSubscriber(modid="createfisheryindustry")
public class CreateFisheryRecipeManager {
    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        RecipeManager recipeManager = server.getRecipeManager();
        try {
            ArrayList allRecipes = new ArrayList(recipeManager.getRecipes());
            int deoxidationCount = CreateFisheryRecipeManager.addDeoxidationRecipes(allRecipes);
            int dewaxingCount = CreateFisheryRecipeManager.addDewaxingRecipes(allRecipes);
            int strippingCount = CreateFisheryRecipeManager.addLogStrippingRecipes(allRecipes);
            recipeManager.replaceRecipes(allRecipes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int addDeoxidationRecipes(List<RecipeHolder<?>> recipes) {
        int count = 0;
        if (DataMapHooks.INVERSE_OXIDIZABLES_DATAMAP.isEmpty()) {
            return 0;
        }
        for (Map.Entry entry : DataMapHooks.INVERSE_OXIDIZABLES_DATAMAP.entrySet()) {
            Block oxidized = (Block)entry.getKey();
            Block deoxidized = (Block)entry.getValue();
            Item oxidizedItem = oxidized.asItem();
            Item deoxidizedItem = deoxidized.asItem();
            if (oxidizedItem == Items.AIR || deoxidizedItem == Items.AIR) continue;
            ResourceLocation oxidizedId = BuiltInRegistries.BLOCK.getKey((Object)oxidized);
            ResourceLocation recipeId = CreateFisheryMod.asResource("auto_deoxidation/" + oxidizedId.getPath());
            boolean exists = recipes.stream().anyMatch(holder -> holder.id().equals((Object)recipeId));
            if (exists) continue;
            try {
                PeelingRecipeParams params = PeelingRecipeParams.builder().require((ItemLike)oxidizedItem).output((ItemLike)deoxidizedItem).build();
                PeelingRecipe recipe = new PeelingRecipe(params);
                RecipeHolder holder2 = new RecipeHolder(recipeId, (Recipe)recipe);
                recipes.add(holder2);
                ++count;
            }
            catch (Exception exception) {}
        }
        return count;
    }

    private static int addDewaxingRecipes(List<RecipeHolder<?>> recipes) {
        int count = 0;
        if (DataMapHooks.INVERSE_WAXABLES_DATAMAP.isEmpty()) {
            return 0;
        }
        for (Map.Entry entry : DataMapHooks.INVERSE_WAXABLES_DATAMAP.entrySet()) {
            Block waxed = (Block)entry.getKey();
            Block dewaxed = (Block)entry.getValue();
            Item waxedItem = waxed.asItem();
            Item dewaxedItem = dewaxed.asItem();
            if (waxedItem == Items.AIR || dewaxedItem == Items.AIR) continue;
            ResourceLocation waxedId = BuiltInRegistries.BLOCK.getKey((Object)waxed);
            ResourceLocation recipeId = CreateFisheryMod.asResource("auto_dewaxing/" + waxedId.getPath());
            boolean exists = recipes.stream().anyMatch(holder -> holder.id().equals((Object)recipeId));
            if (exists) continue;
            try {
                PeelingRecipeParams params = PeelingRecipeParams.builder().require((ItemLike)waxedItem).output((ItemLike)dewaxedItem).build();
                PeelingRecipe recipe = new PeelingRecipe(params);
                RecipeHolder holder2 = new RecipeHolder(recipeId, (Recipe)recipe);
                recipes.add(holder2);
                ++count;
            }
            catch (Exception exception) {}
        }
        return count;
    }

    private static int addLogStrippingRecipes(List<RecipeHolder<?>> recipes) {
        int count = 0;
        for (Map.Entry entry : BuiltInRegistries.BLOCK.entrySet()) {
            Block block = (Block)entry.getValue();
            ResourceLocation blockId = ((ResourceKey)entry.getKey()).location();
            String path = blockId.getPath();
            if (!path.contains("log") || path.contains("stripped")) continue;
            String strippedPath = "stripped_" + path;
            ResourceLocation strippedId = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)strippedPath);
            if (!BuiltInRegistries.BLOCK.containsKey(strippedId)) continue;
            Block strippedBlock = (Block)BuiltInRegistries.BLOCK.get(strippedId);
            Item logItem = block.asItem();
            Item strippedItem = strippedBlock.asItem();
            if (logItem == Items.AIR || strippedItem == Items.AIR) continue;
            ResourceLocation recipeId = CreateFisheryMod.asResource("auto_stripping/" + blockId.getNamespace() + "/" + path);
            boolean exists = recipes.stream().anyMatch(holder -> holder.id().equals((Object)recipeId));
            if (exists) continue;
            try {
                PeelingRecipeParams params = PeelingRecipeParams.builder().require((ItemLike)logItem).output((ItemLike)strippedItem).build();
                PeelingRecipe recipe = new PeelingRecipe(params);
                RecipeHolder holder2 = new RecipeHolder(recipeId, (Recipe)recipe);
                recipes.add(holder2);
                ++count;
            }
            catch (Exception exception) {}
        }
        return count;
    }
}

