/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.recipe;

import com.adonis.createfisheryindustry.recipe.CreateFisheryRecipeTypes;
import com.adonis.createfisheryindustry.recipe.PeelingRecipeParams;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlocks;
import com.google.common.collect.ImmutableList;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
public class PeelingRecipe
extends ProcessingRecipe<RecipeInput, PeelingRecipeParams>
implements IAssemblyRecipe {
    public PeelingRecipe(PeelingRecipeParams params) {
        super((IRecipeTypeInfo)CreateFisheryRecipeTypes.PEELING, (ProcessingRecipeParams)params);
    }

    public ItemStack getPrimaryOutput() {
        if (this.getRollableResults().isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ((ProcessingOutput)this.getRollableResults().get(0)).getStack();
    }

    public List<ProcessingOutput> getSecondaryOutputs() {
        if (this.getRollableResults().size() <= 1) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.getRollableResults().subList(1, this.getRollableResults().size()));
    }

    public List<ItemStack> rollResultsFor(List<ProcessingOutput> specificOutputs) {
        return super.rollResults(specificOutputs);
    }

    public List<ItemStack> rollResults() {
        return super.rollResults();
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 9;
    }

    protected boolean canSpecifyDuration() {
        return false;
    }

    public boolean matches(RecipeInput input, Level level) {
        if (this.getIngredients().isEmpty()) {
            return false;
        }
        if (input instanceof SingleRecipeInput) {
            SingleRecipeInput singleInput = (SingleRecipeInput)input;
            return ((Ingredient)this.getIngredients().get(0)).test(singleInput.item());
        }
        if (input.size() > 0) {
            return ((Ingredient)this.getIngredients().get(0)).test(input.getItem(0));
        }
        return false;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
        list.addAll((Collection<Ingredient>)this.getIngredients());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        return CreateLang.translateDirect((String)"recipe.assembly.peeling", (Object[])new Object[0]);
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)CreateFisheryBlocks.MECHANICAL_PEELER.get());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> SequencedAssemblySubCategory.AssemblyCutting::new;
    }
}

