/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import draylar.identity.ability.AbilityRegistry;
import draylar.identity.api.IdentityTickHandlers;
import draylar.identity.api.PlayerFavorites;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.SafeTagManager;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.network.NetworkHandler;
import draylar.identity.network.ServerNetworking;
import draylar.identity.network.impl.VillagerIdentitiesPackets;
import draylar.identity.registry.IdentityCommands;
import draylar.identity.registry.IdentityEntityTags;
import draylar.identity.registry.IdentityEventHandlers;
import io.netty.buffer.Unpooled;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identity {
    public static final String MODID = "identity";
    public static final Logger LOGGER = LoggerFactory.getLogger(Identity.class);

    public void initialize() {
        IdentityEntityTags.init();
        AbilityRegistry.init();
        IdentityEventHandlers.initialize();
        IdentityCommands.init();
        ServerNetworking.initialize();
        ServerNetworking.registerUseAbilityPacketHandler();
        Identity.registerJoinSyncPacket();
        IdentityTickHandlers.initialize();
        LifecycleEvent.SERVER_STARTING.register(server -> SafeTagManager.loadAll(server));
    }

    public static void registerJoinSyncPacket() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.writeBoolean(IdentityConfig.getInstance().enableClientSwapMenu());
            packet.writeBoolean(IdentityConfig.getInstance().showPlayerNametag());
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.CONFIG_SYNC, (FriendlyByteBuf)packet);
            PlayerUnlocks.sync(player);
            PlayerFavorites.sync(player);
            VillagerIdentitiesPackets.sendSync(player);
        });
    }

    public static ResourceLocation id(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static boolean hasFlyingPermissions(ServerPlayer player) {
        boolean hasPermission = false;
        LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
        if (identity == null) {
            return hasPermission;
        }
        return IdentityConfig.getInstance().enableFlight() && Identity.isAbleToFly(identity);
    }

    private static boolean isAbleToFly(LivingEntity identity) {
        if (identity == null) {
            return false;
        }
        EntityType type = identity.m_6095_();
        ResourceLocation id = EntityType.m_20613_((EntityType)type);
        String idString = id.toString();
        IdentityConfig config = IdentityConfig.getInstance();
        if (config.removedFlyingEntities().contains(idString)) {
            return false;
        }
        if (config.extraFlyingEntities().contains(idString)) {
            return true;
        }
        return type.m_204039_(IdentityEntityTags.FLYING) || SafeTagManager.isCustomFlying(type);
    }

    public static boolean identity$isAquatic(LivingEntity identity) {
        if (identity == null) {
            return false;
        }
        EntityType type = identity.m_6095_();
        ResourceLocation id = EntityType.m_20613_((EntityType)type);
        String idString = id.toString();
        IdentityConfig config = IdentityConfig.getInstance();
        if (config.removedAquaticEntities().contains(idString)) {
            return false;
        }
        if (config.extraAquaticEntities().contains(idString)) {
            return true;
        }
        return type.m_204039_(IdentityEntityTags.BREATHE_UNDERWATER) || SafeTagManager.isCustomBreatheUnderwater(type);
    }

    public static int getCooldown(EntityType<?> type) {
        String id = BuiltInRegistries.f_256780_.m_7981_(type).toString();
        return IdentityConfig.getInstance().getAbilityCooldownMap().getOrDefault(id, 20);
    }
}

