/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.api;

import dev.architectury.networking.NetworkManager;
import draylar.identity.Identity;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.NetworkHandler;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerIdentity {
    public static LivingEntity getIdentity(Player player) {
        return ((PlayerDataProvider)player).getIdentity();
    }

    public static IdentityType<?> getIdentityType(Player player) {
        return ((PlayerDataProvider)player).getIdentityType();
    }

    public static Map<String, CompoundTag> getVillagerIdentities(Player player) {
        return ((PlayerDataProvider)player).getVillagerIdentities();
    }

    public static void setVillagerIdentity(Player player, String key, CompoundTag identity) {
        ((PlayerDataProvider)player).setVillagerIdentity(key, identity);
    }

    public static void removeVillagerIdentity(Player player, String key) {
        ((PlayerDataProvider)player).removeVillagerIdentity(key);
    }

    public static boolean updateIdentity(ServerPlayer player, IdentityType<?> type, LivingEntity entity) {
        if (entity == null) {
            ((PlayerDataProvider)player).setIdentityType(type);
            return ((PlayerDataProvider)player).updateIdentity(null);
        }
        if (entity.getClass().getName().equals("com.github.kay9.dragonmounts.dragon.TameableDragon")) {
            try {
                Method getBreed = entity.getClass().getMethod("getBreed", new Class[0]);
                Object breed = getBreed.invoke((Object)entity, new Object[0]);
                if (breed == null) {
                    player.m_5661_((Component)Component.m_237113_((String)"This dragon identity is broken (no breed). Identity not applied."), false);
                    return false;
                }
            }
            catch (Throwable t) {
                Identity.LOGGER.warn("[Identity] Failed to validate DragonMounts dragon breed", t);
                return false;
            }
        }
        ((PlayerDataProvider)player).setIdentityType(type);
        return ((PlayerDataProvider)player).updateIdentity(entity);
    }

    public static void sync(ServerPlayer player) {
        PlayerIdentity.sync(player, player);
    }

    public static void sync(ServerPlayer changed, ServerPlayer packetTarget) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag entityTag = new CompoundTag();
        LivingEntity identity = PlayerIdentity.getIdentity((Player)changed);
        if (identity != null) {
            identity.m_20240_(entityTag);
        }
        packet.m_130077_(changed.m_20148_());
        packet.m_130070_(identity == null ? "minecraft:empty" : BuiltInRegistries.f_256780_.m_7981_((Object)identity.m_6095_()).toString());
        packet.m_130079_(entityTag);
        NetworkManager.sendToPlayer((ServerPlayer)packetTarget, (ResourceLocation)NetworkHandler.IDENTITY_SYNC, (FriendlyByteBuf)packet);
    }
}

