/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.api;

import draylar.identity.registry.IdentityEntityTags;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;

public class SafeTagManager {
    private static final Set<ResourceLocation> CUSTOM_FLYING_ENTITIES = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_BREATHE_UNDERWATER_ENTITIES = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_FIRE_IMMUNE_ENTITIES = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_SLOW_FALLING = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_BURNS_IN_DAYLIGHT = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_CANT_SWIM = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_HURT_BY_HEAT = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_LAVA_WALKING = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_PIGLIN_FRIENDLY = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_RAVAGER_RIDING = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_UNDROWNABLE = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_WOLF_PREY = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUSTOM_FOX_PREY = new HashSet<ResourceLocation>();

    public static void loadAll(MinecraftServer server) {
        Registry entityTypeRegistry = server.m_206579_().m_175515_(Registries.f_256939_);
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_FLYING), CUSTOM_FLYING_ENTITIES, "custom_flying");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_BREATHE_UNDERWATER), CUSTOM_BREATHE_UNDERWATER_ENTITIES, "custom_breathe_underwater");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_FIRE_IMMUNE), CUSTOM_FIRE_IMMUNE_ENTITIES, "custom_fire_immune");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_SLOW_FALLING), CUSTOM_SLOW_FALLING, "custom_slow_falling");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_BURNS_IN_DAYLIGHT), CUSTOM_BURNS_IN_DAYLIGHT, "custom_burns_in_daylight");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_CANT_SWIM), CUSTOM_CANT_SWIM, "custom_cant_swim");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_HURT_BY_HEAT), CUSTOM_HURT_BY_HEAT, "custom_hurt_by_high_temperature");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_LAVA_WALKING), CUSTOM_LAVA_WALKING, "custom_lava_walking");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_PIGLIN_FRIENDLY), CUSTOM_PIGLIN_FRIENDLY, "custom_piglin_friendly");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_RAVAGER_RIDING), CUSTOM_RAVAGER_RIDING, "custom_ravager_riding");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_UNDROWNABLE), CUSTOM_UNDROWNABLE, "custom_undrownable");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_WOLF_PREY), CUSTOM_WOLF_PREY, "custom_wolf_prey");
        SafeTagManager.loadTagSafely(entityTypeRegistry.m_203431_(IdentityEntityTags.CUSTOM_FOX_PREY), CUSTOM_FOX_PREY, "custom_fox_prey");
    }

    private static void loadTagSafely(Optional<HolderSet.Named<EntityType<?>>> tagListOpt, Set<ResourceLocation> targetSet, String tagName) {
        targetSet.clear();
        if (tagListOpt.isPresent()) {
            for (Holder entry : tagListOpt.get()) {
                ResourceLocation id = EntityType.m_20613_((EntityType)((EntityType)entry.m_203334_()));
                if (id != null) {
                    targetSet.add(id);
                    continue;
                }
                System.out.println("[Identity] Skipping missing entity in " + tagName);
            }
            System.out.println("[Identity] Loaded " + targetSet.size() + " entries into " + tagName);
        } else {
            System.out.println("[Identity] Warning: Tag not found: " + tagName);
        }
    }

    public static boolean isCustomFlying(EntityType<?> type) {
        return CUSTOM_FLYING_ENTITIES.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomBreatheUnderwater(EntityType<?> type) {
        return CUSTOM_BREATHE_UNDERWATER_ENTITIES.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomFireImmune(EntityType<?> type) {
        return CUSTOM_FIRE_IMMUNE_ENTITIES.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomSlowFalling(EntityType<?> type) {
        return CUSTOM_SLOW_FALLING.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomBurnsInDaylight(EntityType<?> type) {
        return CUSTOM_BURNS_IN_DAYLIGHT.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomCantSwim(EntityType<?> type) {
        return CUSTOM_CANT_SWIM.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomHurtByHeat(EntityType<?> type) {
        return CUSTOM_HURT_BY_HEAT.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomLavaWalking(EntityType<?> type) {
        return CUSTOM_LAVA_WALKING.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomPiglinFriendly(EntityType<?> type) {
        return CUSTOM_PIGLIN_FRIENDLY.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomRavagerRiding(EntityType<?> type) {
        return CUSTOM_RAVAGER_RIDING.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomUndrownable(EntityType<?> type) {
        return CUSTOM_UNDROWNABLE.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomWolfPrey(EntityType<?> type) {
        return CUSTOM_WOLF_PREY.contains(EntityType.m_20613_(type));
    }

    public static boolean isCustomFoxPrey(EntityType<?> type) {
        return CUSTOM_FOX_PREY.contains(EntityType.m_20613_(type));
    }
}

