/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.api.platform.IdentityPlatform;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.screen.widget.EntityWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class IdentityCommand {
    private static final Map<String, Consumer<Boolean>> BOOLEAN_SETTERS = new LinkedHashMap<String, Consumer<Boolean>>();
    private static final Map<String, IntConsumer> INT_SETTERS = new LinkedHashMap<String, IntConsumer>();
    private static final Map<String, Consumer<Float>> FLOAT_SETTERS = new LinkedHashMap<String, Consumer<Float>>();
    private static final List<String> STRING_OPTIONS = new ArrayList<String>();
    private static final SuggestionProvider<CommandSourceStack> BOOLEAN_OPTION_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82970_(BOOLEAN_SETTERS.keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> INT_OPTION_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82970_(INT_SETTERS.keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> FLOAT_OPTION_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82970_(FLOAT_SETTERS.keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> STRING_OPTION_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82970_(STRING_OPTIONS, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> FORCED_IDENTITY_SUGGESTIONS = (context, builder) -> {
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.add("none");
        BuiltInRegistries.f_256780_.m_6566_().forEach(id -> suggestions.add(id.toString()));
        return SharedSuggestionProvider.m_82970_(suggestions, (SuggestionsBuilder)builder);
    };

    private static LiteralArgumentBuilder<CommandSourceStack> createListCommand(CommandBuildContext registryAccess) {
        LiteralArgumentBuilder listBuilder = Commands.m_82127_((String)"list");
        listBuilder.then(IdentityCommand.createStringListNode("allowed_swappers", () -> IdentityConfig.getInstance().allowedSwappers(), true, "player"));
        listBuilder.then(IdentityCommand.createStringListNode("advancements_required_for_flight", () -> IdentityConfig.getInstance().advancementsRequiredForFlight(), false, "advancement"));
        listBuilder.then(IdentityCommand.createEntityListNode("extra_aquatic_entities", () -> IdentityConfig.getInstance().extraAquaticEntities(), registryAccess));
        listBuilder.then(IdentityCommand.createEntityListNode("removed_aquatic_entities", () -> IdentityConfig.getInstance().removedAquaticEntities(), registryAccess));
        listBuilder.then(IdentityCommand.createEntityListNode("extra_flying_entities", () -> IdentityConfig.getInstance().extraFlyingEntities(), registryAccess));
        listBuilder.then(IdentityCommand.createEntityListNode("removed_flying_entities", () -> IdentityConfig.getInstance().removedFlyingEntities(), registryAccess));
        return listBuilder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createMapCommand(CommandBuildContext registryAccess) {
        LiteralArgumentBuilder mapBuilder = Commands.m_82127_((String)"map");
        mapBuilder.then(IdentityCommand.createAbilityCooldownCommands(registryAccess));
        mapBuilder.then(IdentityCommand.createRequiredKillCommands(registryAccess));
        return mapBuilder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createStringListNode(String literal, Supplier<List<String>> listSupplier, boolean caseInsensitive, String valueArgumentName) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)literal).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)valueArgumentName, (ArgumentType)StringArgumentType.string()).executes(ctx -> IdentityCommand.addToList((CommandSourceStack)ctx.getSource(), listSupplier, caseInsensitive, literal, StringArgumentType.getString((CommandContext)ctx, (String)valueArgumentName)))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)valueArgumentName, (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(new ArrayList((Collection)listSupplier.get()), (SuggestionsBuilder)builder)).executes(ctx -> IdentityCommand.removeFromList((CommandSourceStack)ctx.getSource(), listSupplier, caseInsensitive, literal, StringArgumentType.getString((CommandContext)ctx, (String)valueArgumentName)))))).then(Commands.m_82127_((String)"clear").executes(ctx -> IdentityCommand.clearList((CommandSourceStack)ctx.getSource(), listSupplier, literal)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createEntityListNode(String literal, Supplier<List<String>> listSupplier, CommandBuildContext registryAccess) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)literal).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registryAccess, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(ctx -> {
            ResourceLocation id = ResourceArgument.m_247713_((CommandContext)ctx, (String)"entity").m_205785_().m_135782_();
            return IdentityCommand.addToList((CommandSourceStack)ctx.getSource(), listSupplier, false, literal, id.toString());
        })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"entity", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(new ArrayList((Collection)listSupplier.get()), (SuggestionsBuilder)builder)).executes(ctx -> IdentityCommand.removeFromList((CommandSourceStack)ctx.getSource(), listSupplier, false, literal, StringArgumentType.getString((CommandContext)ctx, (String)"entity")))))).then(Commands.m_82127_((String)"clear").executes(ctx -> IdentityCommand.clearList((CommandSourceStack)ctx.getSource(), listSupplier, literal)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createAbilityCooldownCommands(CommandBuildContext registryAccess) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ability_cooldowns").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registryAccess, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).then(Commands.m_82129_((String)"cooldown", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ResourceLocation id = ResourceArgument.m_247713_((CommandContext)ctx, (String)"entity").m_205785_().m_135782_();
            int cooldown = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"cooldown");
            return IdentityCommand.setAbilityCooldown((CommandSourceStack)ctx.getSource(), id.toString(), cooldown);
        }))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"entity", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(IdentityConfig.getInstance().getAbilityCooldownMap().keySet(), (SuggestionsBuilder)builder)).executes(ctx -> IdentityCommand.removeAbilityCooldown((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"entity")))))).then(Commands.m_82127_((String)"clear").executes(ctx -> IdentityCommand.clearAbilityCooldowns((CommandSourceStack)ctx.getSource())));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createRequiredKillCommands(CommandBuildContext registryAccess) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"required_kills").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registryAccess, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).then(Commands.m_82129_((String)"kills", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ResourceLocation id = ResourceArgument.m_247713_((CommandContext)ctx, (String)"entity").m_205785_().m_135782_();
            int kills = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"kills");
            return IdentityCommand.setRequiredKillOverride((CommandSourceStack)ctx.getSource(), id.toString(), kills);
        }))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"entity", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(IdentityConfig.getInstance().getRequiredKillsByType().keySet(), (SuggestionsBuilder)builder)).executes(ctx -> IdentityCommand.removeRequiredKillOverride((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"entity")))))).then(Commands.m_82127_((String)"clear").executes(ctx -> IdentityCommand.clearRequiredKillOverrides((CommandSourceStack)ctx.getSource())));
    }

    private static int addToList(CommandSourceStack source, Supplier<List<String>> supplier, boolean caseInsensitive, String listName, String value) {
        boolean exists;
        List<String> list = supplier.get();
        boolean bl = exists = caseInsensitive ? list.stream().anyMatch(entry -> entry.equalsIgnoreCase(value)) : list.contains(value);
        if (exists) {
            source.m_81352_((Component)Component.m_237113_((String)(value + " is already present in " + IdentityCommand.formatKey(listName))));
            return 0;
        }
        list.add(value);
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Added " + value + " to " + IdentityCommand.formatKey(listName))));
        return 1;
    }

    private static int removeFromList(CommandSourceStack source, Supplier<List<String>> supplier, boolean caseInsensitive, String listName, String value) {
        List<String> list = supplier.get();
        boolean removed = caseInsensitive ? list.removeIf(entry -> entry.equalsIgnoreCase(value)) : list.remove(value);
        if (!removed) {
            source.m_81352_((Component)Component.m_237113_((String)(value + " is not present in " + IdentityCommand.formatKey(listName))));
            return 0;
        }
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Removed " + value + " from " + IdentityCommand.formatKey(listName))));
        return 1;
    }

    private static int clearList(CommandSourceStack source, Supplier<List<String>> supplier, String listName) {
        List<String> list = supplier.get();
        if (list.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)(IdentityCommand.formatKey(listName) + " is already empty")), false);
            return 0;
        }
        list.clear();
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Cleared " + IdentityCommand.formatKey(listName))));
        return 1;
    }

    private static int setAbilityCooldown(CommandSourceStack source, String entityId, int cooldown) {
        IdentityConfig.getInstance().getAbilityCooldownMap().put(entityId, cooldown);
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Set ability cooldown for " + entityId + " to " + cooldown)));
        return 1;
    }

    private static int removeAbilityCooldown(CommandSourceStack source, String entityId) {
        Integer removed = IdentityConfig.getInstance().getAbilityCooldownMap().remove(entityId);
        if (removed == null) {
            source.m_81352_((Component)Component.m_237113_((String)("No ability cooldown override exists for " + entityId)));
            return 0;
        }
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Removed ability cooldown override for " + entityId)));
        return 1;
    }

    private static int clearAbilityCooldowns(CommandSourceStack source) {
        Map<String, Integer> map = IdentityConfig.getInstance().getAbilityCooldownMap();
        if (map.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"Ability cooldown overrides are already empty"), false);
            return 0;
        }
        map.clear();
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)"Cleared all ability cooldown overrides"));
        return 1;
    }

    private static int setRequiredKillOverride(CommandSourceStack source, String entityId, int kills) {
        IdentityConfig.getInstance().getRequiredKillsByType().put(entityId, kills);
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Set required kills for " + entityId + " to " + kills)));
        return 1;
    }

    private static int removeRequiredKillOverride(CommandSourceStack source, String entityId) {
        Integer removed = IdentityConfig.getInstance().getRequiredKillsByType().remove(entityId);
        if (removed == null) {
            source.m_81352_((Component)Component.m_237113_((String)("No required kill override exists for " + entityId)));
            return 0;
        }
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Removed required kill override for " + entityId)));
        return 1;
    }

    private static int clearRequiredKillOverrides(CommandSourceStack source) {
        Map<String, Integer> map = IdentityConfig.getInstance().getRequiredKillsByType();
        if (map.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"Required kill overrides are already empty"), false);
            return 0;
        }
        map.clear();
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)"Cleared all required kill overrides"));
        return 1;
    }

    private static int setBooleanOption(CommandSourceStack source, String option, boolean value) {
        String key = option.toLowerCase(Locale.ROOT);
        Consumer<Boolean> setter = BOOLEAN_SETTERS.get(key);
        if (setter == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Unknown boolean option: " + option)));
            return 0;
        }
        setter.accept(value);
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Set " + IdentityCommand.formatKey(key) + " to " + value)));
        return 1;
    }

    private static int setIntegerOption(CommandSourceStack source, String option, int value) {
        String key = option.toLowerCase(Locale.ROOT);
        IntConsumer setter = INT_SETTERS.get(key);
        if (setter == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Unknown integer option: " + option)));
            return 0;
        }
        if ("max_health".equals(key) && value < 1) {
            source.m_81352_((Component)Component.m_237113_((String)"max health must be at least 1"));
            return 0;
        }
        setter.accept(value);
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Set " + IdentityCommand.formatKey(key) + " to " + value)));
        return 1;
    }

    private static int setFloatOption(CommandSourceStack source, String option, float value) {
        String key = option.toLowerCase(Locale.ROOT);
        Consumer<Float> setter = FLOAT_SETTERS.get(key);
        if (setter == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Unknown float option: " + option)));
            return 0;
        }
        if (value <= 0.0f) {
            source.m_81352_((Component)Component.m_237113_((String)"fly speed must be greater than 0"));
            return 0;
        }
        setter.accept(Float.valueOf(value));
        IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Set " + IdentityCommand.formatKey(key) + " to " + value)));
        return 1;
    }

    private static int setStringOption(CommandSourceStack source, String option, String rawValue) {
        String key = option.toLowerCase(Locale.ROOT);
        if (!STRING_OPTIONS.contains(key)) {
            source.m_81352_((Component)Component.m_237113_((String)("Unknown string option: " + option)));
            return 0;
        }
        if ("forced_identity".equals(key)) {
            if (rawValue.equalsIgnoreCase("none") || rawValue.equalsIgnoreCase("null")) {
                IdentityConfig.getInstance().setForcedIdentity(null);
                IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)"Cleared forced identity"));
                return 1;
            }
            ResourceLocation identifier = ResourceLocation.m_135820_((String)rawValue);
            if (identifier == null || !BuiltInRegistries.f_256780_.m_7804_(identifier)) {
                source.m_81352_((Component)Component.m_237113_((String)("Unknown entity: " + rawValue)));
                return 0;
            }
            IdentityConfig.getInstance().setForcedIdentity(identifier.toString());
            IdentityCommand.persistConfig(source, (Component)Component.m_237113_((String)("Set forced identity to " + String.valueOf(identifier))));
            return 1;
        }
        return 0;
    }

    private static int reloadConfig(CommandSourceStack source) {
        if (IdentityPlatform.getReloader() == null) {
            source.m_81352_((Component)Component.m_237113_((String)"No config reloader is registered"));
            return 0;
        }
        IdentityPlatform.getReloader().reloadConfig();
        source.m_288197_(() -> Component.m_237113_((String)"Reloaded Identity config"), true);
        return 1;
    }

    private static void persistConfig(CommandSourceStack source, Component message) {
        source.m_288197_(() -> message, true);
        if (IdentityPlatform.getReloader() != null) {
            IdentityPlatform.getReloader().saveConfig();
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"Unable to save config changes because no reloader is registered"));
        }
    }

    private static String formatKey(String key) {
        return key.replace('_', ' ');
    }

    public static void register() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, b) -> {
            LiteralCommandNode rootNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"identity").requires(source -> source.m_6761_(2))).build();
            LiteralCommandNode grantNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"grant").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"everything").executes(context -> {
                ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
                for (IdentityType<?> type : IdentityType.getAllTypes(player.m_9236_())) {
                    if (PlayerUnlocks.has((Player)player, type)) continue;
                    PlayerUnlocks.unlock(player, type);
                }
                return 1;
            }))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"identity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registryAccess, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(context -> {
                IdentityCommand.grant(((CommandSourceStack)context.getSource()).m_230896_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ResourceArgument.m_247713_((CommandContext)context, (String)"identity").m_205785_().m_135782_(), null);
                return 1;
            })).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
                CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
                IdentityCommand.grant(((CommandSourceStack)context.getSource()).m_230896_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ResourceArgument.m_247713_((CommandContext)context, (String)"identity").m_205785_().m_135782_(), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode revokeNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"revoke").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"everything").executes(context -> {
                ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
                for (IdentityType<?> type : IdentityType.getAllTypes(player.m_9236_())) {
                    if (!PlayerUnlocks.has((Player)player, type)) continue;
                    PlayerUnlocks.revoke(player, type);
                }
                return 1;
            }))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"identity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registryAccess, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(context -> {
                IdentityCommand.revoke(((CommandSourceStack)context.getSource()).m_230896_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ResourceArgument.m_247713_((CommandContext)context, (String)"identity").m_205785_().m_135782_(), null);
                return 1;
            })).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
                CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
                IdentityCommand.revoke(((CommandSourceStack)context.getSource()).m_230896_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ResourceArgument.m_247713_((CommandContext)context, (String)"identity").m_205785_().m_135782_(), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode equip = ((LiteralArgumentBuilder)Commands.m_82127_((String)"equip").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"identity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registryAccess, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(context -> {
                IdentityCommand.equip(((CommandSourceStack)context.getSource()).m_230896_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ResourceArgument.m_247713_((CommandContext)context, (String)"identity").m_205785_().m_135782_(), null);
                return 1;
            })).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
                CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
                IdentityCommand.equip(((CommandSourceStack)context.getSource()).m_230896_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ResourceArgument.m_247713_((CommandContext)context, (String)"identity").m_205785_().m_135782_(), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode unequip = ((LiteralArgumentBuilder)Commands.m_82127_((String)"unequip").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
                IdentityCommand.unequip(((CommandSourceStack)context.getSource()).m_230896_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"));
                return 1;
            }))).build();
            LiteralCommandNode test = ((LiteralArgumentBuilder)Commands.m_82127_((String)"test").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"not").then(Commands.m_82129_((String)"identity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registryAccess, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(context -> IdentityCommand.testNot(((CommandSourceStack)context.getSource()).m_230896_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ResourceArgument.m_247713_((CommandContext)context, (String)"identity").m_205785_().m_135782_()))))).then(Commands.m_82129_((String)"identity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registryAccess, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(context -> IdentityCommand.test(((CommandSourceStack)context.getSource()).m_230896_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ResourceArgument.m_247713_((CommandContext)context, (String)"identity").m_205785_().m_135782_()))))).build();
            LiteralCommandNode offsetNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"offset").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
                int v;
                EntityWidget.VERTICAL_OFFSET = v = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Entity\u2011grid Y\u2011offset set to \u00a7e" + v + "\u00a7r")), false);
                return 1;
            }))).build();
            LiteralCommandNode whitelistNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"whitelist").then(Commands.m_82127_((String)"enable").executes(ctx -> {
                IdentityConfig.getInstance().setEnableSwaps(false);
                if (IdentityConfig.getInstance().logCommands()) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Enabled identity whitelist"), true);
                }
                return 1;
            }))).then(Commands.m_82127_((String)"disable").executes(ctx -> {
                IdentityConfig.getInstance().setEnableSwaps(true);
                if (IdentityConfig.getInstance().logCommands()) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Disabled identity whitelist"), true);
                }
                return 1;
            }))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
                IdentityConfig.getInstance().allowedSwappers().add(name);
                if (IdentityConfig.getInstance().logCommands()) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Added " + name + " to identity whitelist")), true);
                }
                return 1;
            })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
                IdentityConfig.getInstance().allowedSwappers().removeIf(n -> n.equalsIgnoreCase(name));
                if (IdentityConfig.getInstance().logCommands()) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed " + name + " from identity whitelist")), true);
                }
                return 1;
            })))).build();
            LiteralArgumentBuilder configBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"config").then(Commands.m_82127_((String)"boolean").then(Commands.m_82129_((String)"option", (ArgumentType)StringArgumentType.word()).suggests(BOOLEAN_OPTION_SUGGESTIONS).then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> IdentityCommand.setBooleanOption((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"), BoolArgumentType.getBool((CommandContext)ctx, (String)"value"))))))).then(Commands.m_82127_((String)"integer").then(Commands.m_82129_((String)"option", (ArgumentType)StringArgumentType.word()).suggests(INT_OPTION_SUGGESTIONS).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> IdentityCommand.setIntegerOption((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"))))))).then(Commands.m_82127_((String)"float").then(Commands.m_82129_((String)"option", (ArgumentType)StringArgumentType.word()).suggests(FLOAT_OPTION_SUGGESTIONS).then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> IdentityCommand.setFloatOption((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"))))))).then(Commands.m_82127_((String)"string").then(Commands.m_82129_((String)"option", (ArgumentType)StringArgumentType.word()).suggests(STRING_OPTION_SUGGESTIONS).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests(FORCED_IDENTITY_SUGGESTIONS).executes(ctx -> IdentityCommand.setStringOption((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"), StringArgumentType.getString((CommandContext)ctx, (String)"value"))))))).then(IdentityCommand.createListCommand(registryAccess))).then(IdentityCommand.createMapCommand(registryAccess))).then(Commands.m_82127_((String)"reload").executes(ctx -> IdentityCommand.reloadConfig((CommandSourceStack)ctx.getSource())));
            rootNode.addChild((CommandNode)grantNode);
            rootNode.addChild((CommandNode)revokeNode);
            rootNode.addChild((CommandNode)equip);
            rootNode.addChild((CommandNode)unequip);
            rootNode.addChild((CommandNode)test);
            rootNode.addChild((CommandNode)offsetNode);
            rootNode.addChild((CommandNode)whitelistNode);
            rootNode.addChild((CommandNode)configBuilder.build());
            dispatcher.getRoot().addChild((CommandNode)rootNode);
        });
    }

    private static int test(ServerPlayer source, ServerPlayer player, ResourceLocation identity) {
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(identity);
        if (PlayerIdentity.getIdentity((Player)player) != null && PlayerIdentity.getIdentity((Player)player).m_6095_().equals(type)) {
            if (IdentityConfig.getInstance().logCommands()) {
                source.m_5661_((Component)Component.m_237110_((String)"identity.test_positive", (Object[])new Object[]{player.m_5446_(), Component.m_237115_((String)type.m_20675_())}), true);
            }
            return 1;
        }
        if (IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)Component.m_237110_((String)"identity.test_failed", (Object[])new Object[]{player.m_5446_(), Component.m_237115_((String)type.m_20675_())}), true);
        }
        return 0;
    }

    private static int testNot(ServerPlayer source, ServerPlayer player, ResourceLocation identity) {
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(identity);
        if (PlayerIdentity.getIdentity((Player)player) != null && !PlayerIdentity.getIdentity((Player)player).m_6095_().equals(type)) {
            if (IdentityConfig.getInstance().logCommands()) {
                source.m_5661_((Component)Component.m_237110_((String)"identity.test_failed", (Object[])new Object[]{player.m_5446_(), Component.m_237115_((String)type.m_20675_())}), true);
            }
            return 1;
        }
        if (IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)Component.m_237110_((String)"identity.test_positive", (Object[])new Object[]{player.m_5446_(), Component.m_237115_((String)type.m_20675_())}), true);
        }
        return 0;
    }

    private static void grant(ServerPlayer source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        IdentityType<EntityType> type = new IdentityType<EntityType>((EntityType)BuiltInRegistries.f_256780_.m_7745_(id));
        MutableComponent name = Component.m_237115_((String)type.getEntityType().m_20675_());
        if (nbt != null) {
            CompoundTag copy = nbt.m_6426_();
            copy.m_128359_("id", id.toString());
            ServerLevel serverWorld = source.m_284548_();
            Entity loaded = EntityType.m_20645_((CompoundTag)copy, (Level)serverWorld, it -> it);
            if (loaded instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)loaded;
                type = new IdentityType<LivingEntity>(living);
                name = type.createTooltipText((EntityType)living);
            }
        }
        if (!PlayerUnlocks.has((Player)player, type)) {
            boolean result = PlayerUnlocks.unlock(player, type);
            if (result && IdentityConfig.getInstance().logCommands()) {
                player.m_5661_((Component)Component.m_237110_((String)"identity.unlock_entity", (Object[])new Object[]{name}), true);
                source.m_5661_((Component)Component.m_237110_((String)"identity.grant_success", (Object[])new Object[]{name, player.m_5446_()}), true);
            }
        } else if (IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)Component.m_237110_((String)"identity.already_has", (Object[])new Object[]{player.m_5446_(), name}), true);
        }
    }

    private static void revoke(ServerPlayer source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        IdentityType<EntityType> type = new IdentityType<EntityType>((EntityType)BuiltInRegistries.f_256780_.m_7745_(id));
        MutableComponent name = Component.m_237115_((String)type.getEntityType().m_20675_());
        if (nbt != null) {
            CompoundTag copy = nbt.m_6426_();
            copy.m_128359_("id", id.toString());
            ServerLevel serverWorld = source.m_284548_();
            Entity loaded = EntityType.m_20645_((CompoundTag)copy, (Level)serverWorld, it -> it);
            if (loaded instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)loaded;
                type = new IdentityType<LivingEntity>(living);
                name = type.createTooltipText((EntityType)living);
            }
        }
        if (PlayerUnlocks.has((Player)player, type)) {
            PlayerUnlocks.revoke(player, type);
            if (IdentityConfig.getInstance().logCommands()) {
                player.m_5661_((Component)Component.m_237110_((String)"identity.revoke_entity", (Object[])new Object[]{name}), true);
                source.m_5661_((Component)Component.m_237110_((String)"identity.revoke_success", (Object[])new Object[]{name, player.m_5446_()}), true);
            }
        } else if (IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)Component.m_237110_((String)"identity.does_not_have", (Object[])new Object[]{player.m_5446_(), name}), true);
        }
    }

    private static void equip(ServerPlayer source, ServerPlayer player, ResourceLocation identity, @Nullable CompoundTag nbt) {
        boolean result;
        LivingEntity living;
        IdentityType<LivingEntity> defaultType;
        Entity created;
        if (nbt != null) {
            CompoundTag copy = nbt.m_6426_();
            copy.m_128359_("id", identity.toString());
            ServerLevel serverWorld = source.m_284548_();
            created = EntityType.m_20645_((CompoundTag)copy, (Level)serverWorld, it -> it);
        } else {
            EntityType entity = (EntityType)BuiltInRegistries.f_256780_.m_7745_(identity);
            created = entity.m_20615_(player.m_9236_());
        }
        if (created instanceof LivingEntity && (defaultType = IdentityType.from(living = (LivingEntity)created)) != null && (result = PlayerIdentity.updateIdentity(player, defaultType, (LivingEntity)created)) && IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)Component.m_237110_((String)"identity.equip_success", (Object[])new Object[]{Component.m_237115_((String)created.m_6095_().m_20675_()), player.m_5446_()}), true);
        }
    }

    private static void unequip(ServerPlayer source, ServerPlayer player) {
        boolean result = PlayerIdentity.updateIdentity(player, null, null);
        if (result && IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)Component.m_237110_((String)"identity.unequip_success", (Object[])new Object[]{player.m_5446_()}), false);
        }
    }

    static {
        BOOLEAN_SETTERS.put("overlay_identity_unlocks", value -> IdentityConfig.getInstance().setOverlayIdentityUnlocks((boolean)value));
        BOOLEAN_SETTERS.put("overlay_identity_revokes", value -> IdentityConfig.getInstance().setOverlayIdentityRevokes((boolean)value));
        BOOLEAN_SETTERS.put("revoke_identity_on_death", value -> IdentityConfig.getInstance().setRevokeIdentityOnDeath((boolean)value));
        BOOLEAN_SETTERS.put("identities_equip_items", value -> IdentityConfig.getInstance().setIdentitiesEquipItems((boolean)value));
        BOOLEAN_SETTERS.put("identities_equip_armor", value -> IdentityConfig.getInstance().setIdentitiesEquipArmor((boolean)value));
        BOOLEAN_SETTERS.put("show_player_nametag", value -> IdentityConfig.getInstance().setShowPlayerNametag((boolean)value));
        BOOLEAN_SETTERS.put("render_own_nametag", value -> IdentityConfig.getInstance().setRenderOwnNameTag((boolean)value));
        BOOLEAN_SETTERS.put("hostiles_ignore_hostile_identity_player", value -> IdentityConfig.getInstance().setHostilesIgnoreHostileIdentityPlayer((boolean)value));
        BOOLEAN_SETTERS.put("hostiles_forget_new_hostile_identity_player", value -> IdentityConfig.getInstance().setHostilesForgetNewHostileIdentityPlayer((boolean)value));
        BOOLEAN_SETTERS.put("wolves_attack_identity_prey", value -> IdentityConfig.getInstance().setWolvesAttackIdentityPrey((boolean)value));
        BOOLEAN_SETTERS.put("owned_wolves_attack_identity_prey", value -> IdentityConfig.getInstance().setOwnedWolvesAttackIdentityPrey((boolean)value));
        BOOLEAN_SETTERS.put("villagers_run_from_identities", value -> IdentityConfig.getInstance().setVillagersRunFromIdentities((boolean)value));
        BOOLEAN_SETTERS.put("foxes_attack_identity_prey", value -> IdentityConfig.getInstance().setFoxesAttackIdentityPrey((boolean)value));
        BOOLEAN_SETTERS.put("use_identity_sounds", value -> IdentityConfig.getInstance().setUseIdentitySounds((boolean)value));
        BOOLEAN_SETTERS.put("play_ambient_sounds", value -> IdentityConfig.getInstance().setPlayAmbientSounds((boolean)value));
        BOOLEAN_SETTERS.put("hear_self_ambient", value -> IdentityConfig.getInstance().setHearSelfAmbient((boolean)value));
        BOOLEAN_SETTERS.put("enable_flight", value -> IdentityConfig.getInstance().setEnableFlight((boolean)value));
        BOOLEAN_SETTERS.put("enable_client_swap_menu", value -> IdentityConfig.getInstance().setEnableClientSwapMenu((boolean)value));
        BOOLEAN_SETTERS.put("enable_swaps", value -> IdentityConfig.getInstance().setEnableSwaps((boolean)value));
        BOOLEAN_SETTERS.put("allow_self_trading", value -> IdentityConfig.getInstance().setAllowSelfTrading((boolean)value));
        BOOLEAN_SETTERS.put("force_change_new", value -> IdentityConfig.getInstance().setForceChangeNew((boolean)value));
        BOOLEAN_SETTERS.put("force_change_always", value -> IdentityConfig.getInstance().setForceChangeAlways((boolean)value));
        BOOLEAN_SETTERS.put("log_commands", value -> IdentityConfig.getInstance().setLogCommands((boolean)value));
        BOOLEAN_SETTERS.put("kill_for_identity", value -> IdentityConfig.getInstance().setKillForIdentity((boolean)value));
        BOOLEAN_SETTERS.put("scaling_health", value -> IdentityConfig.getInstance().setScalingHealth((boolean)value));
        BOOLEAN_SETTERS.put("warden_is_blinded", value -> IdentityConfig.getInstance().setWardenIsBlinded((boolean)value));
        BOOLEAN_SETTERS.put("warden_blinds_nearby", value -> IdentityConfig.getInstance().setWardenBlindsNearby((boolean)value));
        INT_SETTERS.put("hostility_time", value -> IdentityConfig.getInstance().setHostilityTime(value));
        INT_SETTERS.put("max_health", value -> IdentityConfig.getInstance().setMaxHealth(value));
        INT_SETTERS.put("enderman_ability_teleport_distance", value -> IdentityConfig.getInstance().setEndermanAbilityTeleportDistance(value));
        INT_SETTERS.put("required_kills_for_identity", value -> IdentityConfig.getInstance().setRequiredKillsForIdentity(value));
        FLOAT_SETTERS.put("fly_speed", value -> IdentityConfig.getInstance().setFlySpeed(value.floatValue()));
        STRING_OPTIONS.add("forced_identity");
    }
}

