/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.platform.IdentityConfig;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;

public class VillagerCommand {
    public static void register() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, selection) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"identity_villager").requires(src -> true)).then(Commands.m_82127_((String)"list").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            Map<String, CompoundTag> map = PlayerIdentity.getVillagerIdentities((Player)player);
            if (map.isEmpty()) {
                player.m_5661_((Component)Component.m_237113_((String)"You have no saved villager professions."), false);
                return 1;
            }
            player.m_5661_((Component)Component.m_237113_((String)"Saved villager professions:"), false);
            map.forEach((name, tag) -> {
                String prof = tag.m_128461_("ProfessionId");
                String dim = tag.m_128461_("WorkstationDim");
                long posLong = tag.m_128441_("WorkstationPos") ? tag.m_128454_("WorkstationPos") : Long.MIN_VALUE;
                BlockPos blockPos = posLong == Long.MIN_VALUE ? null : BlockPos.m_122022_((long)posLong);
                String location = blockPos == null ? "?" : blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_();
                player.m_5661_((Component)Component.m_237113_((String)("- " + name + " -> " + prof + " @ " + dim + " " + location)), false);
            });
            return 1;
        }))).then(Commands.m_82127_((String)"show").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            Map<String, CompoundTag> map = PlayerIdentity.getVillagerIdentities((Player)player);
            if (!map.containsKey(name)) {
                player.m_5661_((Component)Component.m_237113_((String)("No villager saved under name: " + name)), false);
                return 0;
            }
            CompoundTag tag = map.get(name);
            String prof = tag.m_128461_("ProfessionId");
            String dim = tag.m_128461_("WorkstationDim");
            long posLong = tag.m_128441_("WorkstationPos") ? tag.m_128454_("WorkstationPos") : Long.MIN_VALUE;
            BlockPos blockPos = posLong == Long.MIN_VALUE ? null : BlockPos.m_122022_((long)posLong);
            String location = blockPos == null ? "?" : blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_();
            player.m_5661_((Component)Component.m_237113_((String)("Villager '" + name + "' profession: " + prof + " @ " + dim + " " + location)), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"trade").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"myself").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (!IdentityConfig.getInstance().allowSelfTrading()) {
                player.m_5661_((Component)Component.m_237115_((String)"identity.profession.trade.self_disabled"), false);
                return 0;
            }
            LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
            if (!(identity instanceof Villager)) {
                player.m_5661_((Component)Component.m_237115_((String)"identity.profession.trade.require_villager"), false);
                return 0;
            }
            Villager villager = (Villager)identity;
            villager.m_6071_((Player)player, InteractionHand.MAIN_HAND);
            return 1;
        })))));
    }

    private VillagerCommand() {
    }
}

