/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.forge.config;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class EntityPickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<ResourceLocation> onPick;
    private EditBox searchBox;
    private EntityList list;

    public EntityPickerScreen(Screen parent, Consumer<ResourceLocation> onPick) {
        super((Component)Component.m_237113_((String)"Select Entity"));
        this.parent = parent;
        this.onPick = onPick;
    }

    protected void m_7856_() {
        int cx = this.f_96543_ / 2;
        this.searchBox = new EditBox(this.f_96547_, cx - 150, 20, 300, 20, (Component)Component.m_237119_());
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search entities\u2026"));
        this.searchBox.m_94151_(s -> this.refresh());
        this.m_7787_((GuiEventListener)this.searchBox);
        this.list = new EntityList(this.f_96541_, this.f_96543_, this.f_96544_ - 80, 50, this.f_96544_ - 60, 20);
        this.list.m_93488_(false);
        this.list.m_93496_(false);
        this.m_7787_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(cx - 150, this.f_96544_ - 30, 120, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Add Selected"), b -> {
            EntityList.Entry sel = this.list.getSelectedEntry();
            if (sel != null) {
                this.onPick.accept(sel.id);
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(cx + 30, this.f_96544_ - 30, 120, 20).m_253136_());
        this.refresh();
    }

    private void refresh() {
        String q = this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        List ids = BuiltInRegistries.f_256780_.m_6566_().stream().sorted(Comparator.comparing(ResourceLocation::toString)).filter(id -> {
            if (q.isEmpty()) {
                return true;
            }
            EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(id);
            String name = type == null ? "" : Component.m_237115_((String)type.m_20675_()).getString();
            String s = id.toString().toLowerCase(Locale.ROOT);
            return s.contains(q) || name.toLowerCase(Locale.ROOT).contains(q);
        }).collect(Collectors.toList());
        this.list.clearAll();
        for (ResourceLocation id2 : ids) {
            EntityList entityList = this.list;
            Objects.requireNonNull(entityList);
            this.list.addRow(entityList.new EntityList.Entry(id2));
        }
    }

    public boolean m_7043_() {
        return true;
    }

    public void m_88315_(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        this.m_280273_(ctx);
        this.list.m_88315_(ctx, mouseX, mouseY, delta);
        super.m_88315_(ctx, mouseX, mouseY, delta);
        ctx.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 6, 0xFFFFFF);
    }

    static class EntityList
    extends ObjectSelectionList<Entry> {
        EntityList(Minecraft mc, int w, int h, int top, int bottom, int itemH) {
            super(mc, w, h, top, bottom, itemH);
        }

        public void addRow(Entry e) {
            super.m_7085_((AbstractSelectionList.Entry)e);
        }

        public void clearAll() {
            super.m_93516_();
        }

        public Entry getSelectedEntry() {
            return (Entry)super.m_93511_();
        }

        public void select(Entry e) {
            super.m_6987_((AbstractSelectionList.Entry)e);
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            final ResourceLocation id;

            Entry(ResourceLocation id) {
                this.id = id;
            }

            public void m_6311_(GuiGraphics ctx, int idx, int y, int x, int w, int h, int mouseX, int mouseY, boolean hovered, float delta) {
                EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(this.id);
                String nice = type == null ? this.id.toString() : Component.m_237115_((String)type.m_20675_()).getString() + " (" + String.valueOf(this.id) + ")";
                ctx.m_280056_(Minecraft.m_91087_().f_91062_, nice, x + 4, y + 6, 0xFFFFFF, false);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                EntityList.this.select(this);
                return true;
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.id.toString());
            }
        }
    }
}

