/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.forge.mixin;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.EntityCockroach;
import com.mojang.authlib.GameProfile;
import draylar.identity.api.PlayerIdentity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerEntityMixin
extends AbstractClientPlayer {
    @Unique
    private boolean identity$forceDanceActive = false;

    public ClientPlayerEntityMixin(ClientLevel world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(method={"handleStatus"}, at={@At(value="HEAD")})
    private void identity$onHandleStatus(byte status, CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        LivingEntity livingEntity = PlayerIdentity.getIdentity((Player)player);
        if (livingEntity instanceof EntityCockroach) {
            EntityCockroach cockroach = (EntityCockroach)livingEntity;
            if (status == 67) {
                this.identity$forceDanceActive = true;
            } else if (status == 68) {
                this.identity$forceDanceActive = false;
                cockroach.setMaracas(false);
                cockroach.setNearestMusician(null);
            } else if (status == 69) {
                cockroach.setMaracas(true);
                AlexsMobs.PROXY.onEntityStatus((Entity)cockroach, (byte)67);
                for (EntityCockroach roach : this.m_9236_().m_6443_(EntityCockroach.class, this.identity$getMusicianDistance(), EntitySelector.f_20408_)) {
                    if (roach.hasMaracas()) continue;
                    roach.setNearestMusician(this.m_20148_());
                }
            }
        }
    }

    @Unique
    private AABB identity$getMusicianDistance() {
        return this.m_20191_().m_82377_(10.0, 10.0, 10.0);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void identity$tickDance(CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        LivingEntity morph = PlayerIdentity.getIdentity((Player)player);
        if (!(morph instanceof EntityCockroach)) {
            return;
        }
        EntityCockroach cockroach = (EntityCockroach)morph;
        boolean dancing = this.identity$forceDanceActive;
        if (!dancing && cockroach.danceProgress == 0.0f) {
            cockroach.setDancing(false);
            cockroach.m_6818_(player.m_20183_(), false);
        } else {
            cockroach.setDancing(dancing);
            cockroach.m_6818_(player.m_20183_(), dancing);
        }
        if (cockroach.hasMaracas()) {
            cockroach.setNearestMusician(player.m_20148_());
        } else {
            cockroach.setNearestMusician(null);
            cockroach.setMaracas(false);
            this.identity$tellOtherCockroachesToStopDancing(cockroach, player);
        }
        cockroach.m_8119_();
    }

    @Unique
    private void identity$tellOtherCockroachesToStopDancing(EntityCockroach cockroach, LocalPlayer player) {
        for (EntityCockroach roach : this.m_9236_().m_6443_(EntityCockroach.class, this.identity$getMusicianDistance(), EntitySelector.f_20408_)) {
            if (roach == cockroach || !roach.hasMaracas() || roach.getNearestMusician().m_20148_() != player.m_20148_()) continue;
            roach.setMaracas(false);
            roach.setDancing(false);
            roach.m_6818_(player.m_20183_(), false);
        }
    }
}

