/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import draylar.identity.api.PlayerHostility;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.SafeTagManager;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.registry.IdentityEntityTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PiglinAi.class})
public class PiglinBrainMixin {
    @Inject(method={"isPreferredAttackTarget"}, at={@At(value="RETURN")}, cancellable=true)
    private static void shouldAttackIdentity(Piglin piglin, LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        boolean shouldAttack = (Boolean)cir.getReturnValue();
        if (shouldAttack && target instanceof Player) {
            Player player = (Player)target;
            LivingEntity identity = PlayerIdentity.getIdentity(player);
            boolean hasHostility = PlayerHostility.hasHostility(player);
            if (identity != null) {
                if (identity.m_6095_().m_204039_(IdentityEntityTags.PIGLIN_FRIENDLY) || SafeTagManager.isCustomPiglinFriendly(identity.m_6095_())) {
                    cir.setReturnValue((Object)false);
                } else if (IdentityConfig.getInstance().hostilesIgnoreHostileIdentityPlayer() && identity instanceof Enemy) {
                    if (!hasHostility) {
                        cir.setReturnValue((Object)false);
                    } else {
                        cir.setReturnValue((Object)true);
                    }
                }
            }
        }
    }
}

