/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import draylar.identity.Identity;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.SafeTagManager;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.compat.LivingEntityCompatAccessor;
import draylar.identity.mixin.LivingEntityMixin;
import draylar.identity.mixin.accessor.EntityAccessor;
import draylar.identity.mixin.accessor.IronGolemEntityAccessor;
import draylar.identity.mixin.accessor.MobEntityAccessor;
import draylar.identity.mixin.accessor.RavagerEntityAccessor;
import draylar.identity.registry.IdentityEntityTags;
import draylar.identity.util.AttributeSync;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin {
    private int identity_ambientSoundChance = 0;

    @Shadow
    public abstract boolean m_5833_();

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    public abstract boolean m_6069_();

    private PlayerEntityMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void identity$loadForcedIdentity(CallbackInfo ci) {
        EntityType foundType;
        String forced;
        ServerPlayer serverPlayerEntity;
        LivingEntity active;
        PlayerEntityMixin playerEntityMixin = this;
        if (playerEntityMixin instanceof ServerPlayer && (active = PlayerIdentity.getIdentity((Player)(serverPlayerEntity = (ServerPlayer)playerEntityMixin))) == null && (forced = IdentityConfig.getInstance().getForcedIdentity()) != null && (foundType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(forced))) != null) {
            PlayerIdentity.updateIdentity(serverPlayerEntity, new IdentityType<EntityType>(foundType), (LivingEntity)foundType.m_20615_(this.m_9236_()));
        }
    }

    @Inject(method={"getDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (identity != null) {
            cir.setReturnValue((Object)identity.m_6972_(pose));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickAquaticBreathingOutsideWater(CallbackInfo ci) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (identity != null && Identity.identity$isAquatic(identity)) {
            int air = this.m_20146_();
            if (this.m_6084_() && !this.m_20072_()) {
                int i = EnchantmentHelper.m_44918_((LivingEntity)((LivingEntity)this));
                if (i > 0) {
                    if (this.f_19796_.m_188503_(i + 1) <= 0) {
                        this.m_20301_(air - 1);
                    }
                } else {
                    this.m_20301_(air - 1);
                }
                if (this.m_20146_() == -20) {
                    this.m_20301_(0);
                    this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
                }
            } else {
                this.m_20301_(300);
            }
        }
    }

    @Inject(method={"getActiveEyeHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void identity_getActiveEyeHeight(Pose pose, EntityDimensions dimensions, CallbackInfoReturnable<Float> cir) {
        Player playerEntity = (Player)this;
        try {
            LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
            if (identity != null) {
                cir.setReturnValue((Object)Float.valueOf(((LivingEntityCompatAccessor)identity).callGetActiveEyeHeight(this.m_20089_(), this.m_6972_(this.m_20089_()))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_20236_(Pose pose) {
        Player playerEntity = (Player)this;
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (identity != null) {
            return identity.m_20236_(pose);
        }
        return this.m_6380_(pose, this.m_6972_(pose));
    }

    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getHurtSound(DamageSource source, CallbackInfoReturnable<SoundEvent> cir) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (IdentityConfig.getInstance().useIdentitySounds() && identity != null) {
            cir.setReturnValue((Object)((LivingEntityCompatAccessor)identity).callGetHurtSound(source));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickAmbientSounds(CallbackInfo ci) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (!this.m_9236_().f_46443_ && IdentityConfig.getInstance().playAmbientSounds() && identity instanceof Mob) {
            Mob mobIdentity = (Mob)identity;
            if (this.m_6084_() && this.f_19796_.m_188503_(1000) < this.identity_ambientSoundChance++) {
                this.identity_ambientSoundChance = -mobIdentity.m_8100_();
                SoundEvent sound = ((MobEntityAccessor)mobIdentity).callGetAmbientSound();
                if (sound != null) {
                    float volume = ((LivingEntityCompatAccessor)mobIdentity).callGetSoundVolume();
                    float pitch = ((LivingEntityCompatAccessor)mobIdentity).callGetSoundPitch();
                    if (IdentityConfig.getInstance().hearSelfAmbient()) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, this.m_5720_(), volume, pitch);
                    } else {
                        this.m_9236_().m_6263_((Player)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, this.m_5720_(), volume, pitch);
                    }
                }
            }
        }
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (IdentityConfig.getInstance().useIdentitySounds() && identity != null) {
            cir.setReturnValue((Object)((LivingEntityCompatAccessor)identity).callGetDeathSound());
        }
    }

    @Inject(method={"getFallSounds"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFallSounds(CallbackInfoReturnable<LivingEntity.Fallsounds> cir) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (IdentityConfig.getInstance().useIdentitySounds() && identity != null) {
            cir.setReturnValue((Object)identity.m_196493_());
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    protected void identity_tryAttack(Entity target, CallbackInfo ci) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (identity instanceof IronGolem) {
            IronGolem golem = (IronGolem)identity;
            ((IronGolemEntityAccessor)golem).setAttackTicksLeft(10);
        }
        if (identity instanceof Warden) {
            Warden warden = (Warden)identity;
            warden.f_219313_.m_216977_(this.f_19797_);
        }
        if (identity instanceof Ravager) {
            Ravager ravager = (Ravager)identity;
            ((RavagerEntityAccessor)ravager).setAttackTick(10);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickGolemAttackTicks(CallbackInfo ci) {
        IronGolem golem;
        IronGolemEntityAccessor accessor;
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (identity instanceof IronGolem && (accessor = (IronGolemEntityAccessor)(golem = (IronGolem)identity)).getAttackTicksLeft() > 0) {
            accessor.setAttackTicksLeft(accessor.getAttackTicksLeft() - 1);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickRavagerAttackTicks(CallbackInfo ci) {
        Ravager ravager;
        RavagerEntityAccessor accessor;
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (identity instanceof Ravager && (accessor = (RavagerEntityAccessor)(ravager = (Ravager)identity)).getAttackTick() > 0) {
            accessor.setAttackTick(accessor.getAttackTick() - 1);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickWardenSneakingAnimation(CallbackInfo ci) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (identity instanceof Warden) {
            Warden warden = (Warden)identity;
            if (this.m_6144_()) {
                if (!warden.f_219316_.m_216984_()) {
                    warden.f_219316_.m_216977_(this.f_19797_);
                }
            } else {
                warden.f_219316_.m_216973_();
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickFire(CallbackInfo ci) {
        boolean bl;
        EntityType type;
        Player player = (Player)this;
        LivingEntity identity = PlayerIdentity.getIdentity(player);
        if (!player.m_9236_().f_46443_ && !player.m_7500_() && !player.m_5833_() && identity != null && ((type = identity.m_6095_()).m_204039_(IdentityEntityTags.BURNS_IN_DAYLIGHT) || SafeTagManager.isCustomBurnsInDaylight(type)) && (bl = this.isInDaylight())) {
            if (player.m_9236_().m_46471_()) {
                return;
            }
            ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
            if (!helmet.m_41619_() && helmet.m_41763_()) {
                helmet.m_41721_(helmet.m_41773_() + player.m_217043_().m_188503_(2));
                if (helmet.m_41773_() >= helmet.m_41776_()) {
                    player.m_21166_(EquipmentSlot.HEAD);
                    player.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                }
                bl = false;
            }
            if (bl) {
                player.m_20254_(8);
            }
        }
    }

    @Unique
    private boolean isInDaylight() {
        if (this.m_9236_().m_46461_() && !this.m_9236_().f_46443_) {
            float brightnessAtEyes = this.m_213856_();
            BlockPos daylightTestPosition = new BlockPos((int)this.m_20185_(), (int)Math.round(this.m_20186_()), (int)this.m_20189_());
            if (this.m_20202_() instanceof Boat) {
                daylightTestPosition = daylightTestPosition.m_7494_();
            }
            return brightnessAtEyes > 0.5f && this.f_19796_.m_188501_() * 30.0f < (brightnessAtEyes - 0.4f) * 2.0f && this.m_9236_().m_45527_(daylightTestPosition);
        }
        return false;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickTemperature(CallbackInfo ci) {
        Biome biome;
        EntityType type;
        Player player = (Player)this;
        LivingEntity identity = PlayerIdentity.getIdentity(player);
        if (!(player.m_7500_() || player.m_5833_() || identity == null || !(type = identity.m_6095_()).m_204039_(IdentityEntityTags.HURT_BY_HIGH_TEMPERATURE) && !SafeTagManager.isCustomHurtByHeat(type) || (biome = (Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_()).m_198904_(this.m_20183_()))) {
            player.m_6469_(this.m_269291_().m_269549_(), 1.0f);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickIdentity(CallbackInfo ci) {
        Player player;
        LivingEntity identity;
        if (!this.m_9236_().f_46443_ && (identity = PlayerIdentity.getIdentity(player = (Player)this)) != null) {
            identity.m_20343_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            identity.m_5616_(player.m_6080_());
            identity.m_6862_(((LivingEntityCompatAccessor)player).isJumping());
            identity.m_6858_(player.m_20142_());
            identity.m_21317_(player.m_21234_());
            identity.m_20331_(true);
            identity.m_20242_(true);
            identity.m_20260_(player.m_6144_());
            identity.m_20282_(player.m_6069_());
            identity.m_6672_(player.m_7655_());
            identity.m_20124_(player.m_20089_());
            if (identity instanceof TamableAnimal) {
                ((TamableAnimal)identity).m_21837_(player.m_6144_());
                ((TamableAnimal)identity).m_21839_(player.m_6144_());
            }
            ((EntityAccessor)identity).identity_callSetFlag(7, player.m_21255_());
            ((LivingEntityCompatAccessor)identity).callTickActiveItemStack();
            PlayerIdentity.sync((ServerPlayer)player);
            AttributeSync.syncMaxHealth((ServerPlayer)player);
        }
    }
}

