/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.model.ArmRenderingManipulator;
import draylar.identity.api.model.EntityArms;
import draylar.identity.api.model.EntityUpdater;
import draylar.identity.api.model.EntityUpdaters;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.compat.LivingEntityCompatAccessor;
import draylar.identity.mixin.LimbAnimatorAccessor;
import draylar.identity.mixin.accessor.EntityAccessor;
import draylar.identity.mixin.accessor.LivingEntityRendererAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerEntityRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Shadow
    protected static HumanoidModel.ArmPose m_117794_(AbstractClientPlayer player, InteractionHand hand) {
        return null;
    }

    private PlayerEntityRendererMixin(EntityRendererProvider.Context ctx, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderInject(AbstractClientPlayer player, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, CallbackInfo ci) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
        if (identity != null) {
            EntityRenderer renderer;
            LimbAnimatorAccessor target = (LimbAnimatorAccessor)identity.f_267362_;
            LimbAnimatorAccessor source = (LimbAnimatorAccessor)player.f_267362_;
            target.setPrevSpeed(source.getPrevSpeed());
            target.setSpeed(source.getSpeed());
            target.setPos(source.getPos());
            identity.f_20911_ = player.f_20911_;
            identity.f_20913_ = player.f_20913_;
            identity.f_20920_ = player.f_20920_;
            identity.f_20921_ = player.f_20921_;
            identity.f_20883_ = player.f_20883_;
            identity.f_20884_ = player.f_20884_;
            identity.f_20885_ = player.f_20885_;
            identity.f_20886_ = player.f_20886_;
            identity.f_19797_ = player.f_19797_;
            identity.f_20912_ = player.f_20912_;
            identity.m_6853_(player.m_20096_());
            identity.m_20256_(player.m_20184_());
            identity.m_20260_(player.m_6144_());
            identity.m_6858_(player.m_20142_());
            identity.m_20282_(player.m_6069_());
            identity.m_6672_(player.m_7655_());
            identity.m_20124_(player.m_20089_());
            ((EntityAccessor)identity).setVehicle(player.m_20202_());
            ((EntityAccessor)identity).setTouchingWater(player.m_20069_());
            if (identity instanceof Phantom) {
                identity.m_146926_(-player.m_146909_());
                identity.f_19860_ = -player.f_19860_;
            } else {
                identity.m_146926_(player.m_146909_());
                identity.f_19860_ = player.f_19860_;
            }
            if (IdentityConfig.getInstance().identitiesEquipItems()) {
                identity.m_8061_(EquipmentSlot.MAINHAND, player.m_6844_(EquipmentSlot.MAINHAND));
                identity.m_8061_(EquipmentSlot.OFFHAND, player.m_6844_(EquipmentSlot.OFFHAND));
            }
            if (IdentityConfig.getInstance().identitiesEquipArmor()) {
                identity.m_8061_(EquipmentSlot.HEAD, player.m_6844_(EquipmentSlot.HEAD));
                identity.m_8061_(EquipmentSlot.CHEST, player.m_6844_(EquipmentSlot.CHEST));
                identity.m_8061_(EquipmentSlot.LEGS, player.m_6844_(EquipmentSlot.LEGS));
                identity.m_8061_(EquipmentSlot.FEET, player.m_6844_(EquipmentSlot.FEET));
            }
            if (identity instanceof Mob) {
                ((Mob)identity).m_21561_(player.m_6117_());
            }
            identity.m_20124_(player.m_20089_());
            identity.m_6672_(player.m_7655_() == null ? InteractionHand.MAIN_HAND : player.m_7655_());
            ((LivingEntityCompatAccessor)identity).callSetLivingFlag(1, player.m_6117_());
            identity.m_21252_();
            ((LivingEntityCompatAccessor)identity).callTickActiveItemStack();
            EntityUpdater updater = EntityUpdaters.getUpdater(identity.m_6095_());
            if (updater != null) {
                updater.update((Player)player, identity);
            }
            if ((renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)identity)) instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
                this.identity_setBipedIdentityModelPose(player, identity, livingRenderer);
            }
            renderer.m_7392_((Entity)identity, f, g, matrixStack, vertexConsumerProvider, light);
            if (IdentityConfig.getInstance().showPlayerNametag() && (player != Minecraft.m_91087_().f_91074_ || IdentityConfig.getInstance().shouldRenderOwnNameTag())) {
                this.m_7649_((Entity)player, player.m_5446_(), matrixStack, vertexConsumerProvider, light);
            }
            ci.cancel();
        }
    }

    private void identity_setBipedIdentityModelPose(AbstractClientPlayer player, LivingEntity identity, LivingEntityRenderer identityRenderer) {
        EntityModel entityModel = identityRenderer.m_7200_();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel identityBipedModel = (HumanoidModel)entityModel;
        if (identity.m_5833_()) {
            identityBipedModel.m_8009_(false);
            identityBipedModel.f_102808_.f_104207_ = true;
            identityBipedModel.f_102809_.f_104207_ = true;
        } else {
            identityBipedModel.m_8009_(true);
            identityBipedModel.f_102809_.f_104207_ = player.m_36170_(PlayerModelPart.HAT);
            identityBipedModel.f_102817_ = identity.m_6047_();
            HumanoidModel.ArmPose mainHandPose = PlayerEntityRendererMixin.m_117794_(player, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose offHandPose = PlayerEntityRendererMixin.m_117794_(player, InteractionHand.OFF_HAND);
            if (mainHandPose.m_102897_()) {
                HumanoidModel.ArmPose armPose = offHandPose = identity.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (identity.m_5737_() == HumanoidArm.RIGHT) {
                identityBipedModel.f_102816_ = mainHandPose;
                identityBipedModel.f_102815_ = offHandPose;
            } else {
                identityBipedModel.f_102816_ = offHandPose;
                identityBipedModel.f_102815_ = mainHandPose;
            }
        }
    }

    @Inject(method={"getPositionOffset"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyPositionOffset(AbstractClientPlayer player, float f, CallbackInfoReturnable<Vec3> cir) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
        if (identity != null && identity instanceof TamableAnimal) {
            cir.setReturnValue((Object)super.m_7860_((Entity)player, f));
        }
    }

    @Inject(method={"renderArm"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        EntityRenderer renderer;
        LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
        if (identity != null && (renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)identity)) instanceof LivingEntityRenderer) {
            LivingEntityRenderer rendererCasted = (LivingEntityRenderer)renderer;
            EntityModel model = ((LivingEntityRenderer)renderer).m_7200_();
            arm = null;
            sleeve = null;
            if (model instanceof PlayerModel) {
                arm = ((PlayerModel)model).f_102811_;
                sleeve = ((PlayerModel)model).f_103375_;
            } else if (model instanceof HumanoidModel) {
                arm = ((HumanoidModel)model).f_102811_;
                sleeve = null;
            } else {
                Tuple<ModelPart, ArmRenderingManipulator<?>> pair = EntityArms.get(identity, model);
                if (pair != null) {
                    arm = (ModelPart)pair.m_14418_();
                    ((ArmRenderingManipulator)pair.m_14419_()).run(matrices, model);
                    matrices.m_85837_(0.0, -0.35, 0.5);
                }
            }
            model.f_102608_ = 0.0f;
            model.m_6973_((Entity)identity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (arm != null) {
                arm.f_104203_ = 0.0f;
                arm.m_104301_(matrices, vertexConsumers.m_6299_(((LivingEntityRendererAccessor)rendererCasted).callGetRenderLayer(identity, true, false, true)), light, OverlayTexture.f_118083_);
            }
            if (sleeve != null) {
                sleeve.f_104203_ = 0.0f;
                sleeve.m_104301_(matrices, vertexConsumers.m_6299_(((LivingEntityRendererAccessor)rendererCasted).callGetRenderLayer(identity, true, false, true)), light, OverlayTexture.f_118083_);
            }
            ci.cancel();
        }
    }
}

