/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network;

import dev.architectury.networking.NetworkManager;
import draylar.identity.IdentityClient;
import draylar.identity.api.ApplicablePacket;
import draylar.identity.impl.DimensionsRefresher;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.NetworkHandler;
import draylar.identity.network.client.VillagerProfessionClient;
import draylar.identity.network.impl.FavoritePackets;
import draylar.identity.network.impl.UnlockPackets;
import draylar.identity.network.impl.VillagerIdentitiesPackets;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.Nullable;

public class ClientNetworking
implements NetworkHandler {
    public static void registerPacketHandlers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)NetworkHandler.IDENTITY_SYNC, ClientNetworking::handleIdentitySyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)NetworkHandler.FAVORITE_SYNC, FavoritePackets::handleFavoriteSyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)NetworkHandler.ABILITY_SYNC, ClientNetworking::handleAbilitySyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)NetworkHandler.UNLOCK_SYNC, UnlockPackets::handleUnlockSyncPacket);
        VillagerIdentitiesPackets.registerClientHandler();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)NetworkHandler.CONFIG_SYNC, ClientNetworking::handleConfigurationSyncPacket);
        VillagerProfessionClient.registerClientHandler();
    }

    public static void runOrQueue(NetworkManager.PacketContext context, ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            IdentityClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }

    public static void sendAbilityRequest() {
        NetworkManager.sendToServer((ResourceLocation)USE_ABILITY, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()));
    }

    public static void handleIdentitySyncPacket(FriendlyByteBuf packet, NetworkManager.PacketContext context) {
        UUID uuid = packet.m_130259_();
        String id = packet.m_130277_();
        CompoundTag entityNbt = packet.m_130260_();
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable Player syncTarget = player.m_20193_().m_46003_(uuid);
            if (syncTarget != null) {
                PlayerDataProvider data = (PlayerDataProvider)syncTarget;
                if (id.equals("minecraft:empty")) {
                    data.setIdentity(null);
                    ((DimensionsRefresher)syncTarget).identity_refreshDimensions();
                    return;
                }
                if (entityNbt != null) {
                    entityNbt.m_128359_("id", id);
                    Optional type = EntityType.m_20637_((CompoundTag)entityNbt);
                    if (type.isPresent()) {
                        LivingEntity identity = data.getIdentity();
                        if (identity == null || !((EntityType)type.get()).equals(identity.m_6095_())) {
                            identity = (LivingEntity)((EntityType)type.get()).m_20615_(syncTarget.m_9236_());
                            data.setIdentity(identity);
                            ((DimensionsRefresher)syncTarget).identity_refreshDimensions();
                            syncTarget.m_274367_(identity.m_274421_());
                            syncTarget.m_20256_(syncTarget.m_20184_().m_82542_(1.0, 0.0, 1.0));
                            syncTarget.f_19789_ = 0.0f;
                            syncTarget.f_19854_ = syncTarget.m_20185_();
                            syncTarget.f_19855_ = syncTarget.m_20186_();
                            syncTarget.f_19856_ = syncTarget.m_20189_();
                            syncTarget.f_19812_ = true;
                            ClientNetworking.ensureSafePosition(syncTarget);
                            syncTarget.m_6210_();
                        }
                        if (identity != null) {
                            identity.m_20258_(entityNbt);
                        }
                    }
                }
            }
        });
    }

    private static void ensureSafePosition(Player player) {
        if (player.m_5830_()) {
            double safeY = player.m_20186_();
            for (int i = 1; i <= 2; ++i) {
                if (player.m_9236_().m_8055_(player.m_20183_().m_6630_(i)).m_60796_((BlockGetter)player.m_9236_(), player.m_20183_().m_6630_(i))) continue;
                safeY = player.m_20186_() + (double)i;
                break;
            }
            player.m_6034_(player.m_20185_(), safeY, player.m_20189_());
        }
    }

    public static void handleAbilitySyncPacket(FriendlyByteBuf packet, NetworkManager.PacketContext context) {
        int cooldown = packet.readInt();
        ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider)player).setAbilityCooldown(cooldown));
    }

    public static void handleConfigurationSyncPacket(FriendlyByteBuf packet, NetworkManager.PacketContext context) {
        boolean enableClientSwapMenu = packet.readBoolean();
        boolean showPlayerNametag = packet.readBoolean();
    }

    private ClientNetworking() {
    }
}

