/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network.impl;

import dev.architectury.networking.NetworkManager;
import draylar.identity.api.PlayerFavorites;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.ClientNetworking;
import draylar.identity.network.NetworkHandler;
import io.netty.buffer.Unpooled;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class FavoritePackets {
    public static void sendFavoriteRequest(IdentityType<?> type, boolean favorite) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130085_(BuiltInRegistries.f_256780_.m_7981_(type.getEntityType()));
        packet.writeInt(type.getVariantData());
        packet.writeBoolean(favorite);
        NetworkManager.sendToServer((ResourceLocation)ClientNetworking.FAVORITE_UPDATE, (FriendlyByteBuf)packet);
    }

    public static void registerFavoriteRequestHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)NetworkHandler.FAVORITE_UPDATE, (buf, context) -> {
            EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(buf.m_130281_());
            int variant = buf.readInt();
            boolean favorite = buf.readBoolean();
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            context.getPlayer().m_20194_().execute(() -> {
                @Nullable IdentityType<Z> type = IdentityType.from(entityType, variant);
                if (type != null) {
                    if (favorite) {
                        PlayerFavorites.favorite(player, type);
                    } else {
                        PlayerFavorites.unfavorite(player, type);
                    }
                }
            });
        });
    }

    public static void sendFavoriteSync(ServerPlayer player) {
        Set<IdentityType<?>> favorites = ((PlayerDataProvider)player).getFavorites();
        CompoundTag tag = new CompoundTag();
        ListTag idList = new ListTag();
        favorites.forEach(type -> idList.add((Object)type.writeCompound()));
        tag.m_128365_("FavoriteIdentities", (Tag)idList);
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130079_(tag);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.FAVORITE_SYNC, (FriendlyByteBuf)packet);
    }

    public static void handleFavoriteSyncPacket(FriendlyByteBuf packet, NetworkManager.PacketContext context) {
        CompoundTag tag = packet.m_130260_();
        ClientNetworking.runOrQueue(context, player -> {
            PlayerDataProvider data = (PlayerDataProvider)player;
            data.getFavorites().clear();
            ListTag idList = tag.m_128437_("FavoriteIdentities", 10);
            idList.forEach(compound -> data.getFavorites().add(IdentityType.from((CompoundTag)compound)));
        });
    }
}

