/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network.impl;

import dev.architectury.networking.NetworkManager;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.ClientNetworking;
import draylar.identity.network.NetworkHandler;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class UnlockPackets {
    private static final String UNLOCK_KEY = "UnlockedIdentities";

    public static void handleUnlockSyncPacket(FriendlyByteBuf packet, NetworkManager.PacketContext context) {
        CompoundTag nbt = packet.m_130260_();
        if (nbt != null) {
            ListTag list = nbt.m_128437_(UNLOCK_KEY, 10);
            ClientNetworking.runOrQueue(context, player -> {
                ((PlayerDataProvider)player).getUnlocked().clear();
                list.forEach(idTag -> ((PlayerDataProvider)player).getUnlocked().add(IdentityType.from((CompoundTag)idTag)));
            });
        }
    }

    public static void sendSyncPacket(ServerPlayer player) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag compound = new CompoundTag();
        ListTag idList = new ListTag();
        ((PlayerDataProvider)player).getUnlocked().forEach(type -> idList.add((Object)type.writeCompound()));
        compound.m_128365_(UNLOCK_KEY, (Tag)idList);
        packet.m_130079_(compound);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.UNLOCK_SYNC, (FriendlyByteBuf)packet);
    }
}

