/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network.impl;

import dev.architectury.networking.NetworkManager;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.ClientNetworking;
import draylar.identity.network.NetworkHandler;
import draylar.identity.screen.IdentityScreen;
import io.netty.buffer.Unpooled;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VillagerIdentitiesPackets {
    public static void sendSync(ServerPlayer player) {
        PlayerDataProvider data = (PlayerDataProvider)player;
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag root = new CompoundTag();
        CompoundTag villagerTag = new CompoundTag();
        for (Map.Entry<String, CompoundTag> entry : data.getVillagerIdentities().entrySet()) {
            villagerTag.m_128365_(entry.getKey(), (Tag)entry.getValue().m_6426_());
        }
        root.m_128365_("VillagerIdentities", (Tag)villagerTag);
        String active = data.getActiveVillagerKey();
        if (active != null && !active.isEmpty()) {
            root.m_128359_("ActiveVillagerKey", active);
        }
        packet.m_130079_(root);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.VILLAGER_IDENTITIES_SYNC, (FriendlyByteBuf)packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerClientHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)NetworkHandler.VILLAGER_IDENTITIES_SYNC, (buf, context) -> {
            CompoundTag root = buf.m_130260_();
            ClientNetworking.runOrQueue(context, player -> {
                if (root == null) {
                    return;
                }
                PlayerDataProvider data = (PlayerDataProvider)player;
                data.getVillagerIdentities().clear();
                CompoundTag villagerTag = root.m_128469_("VillagerIdentities");
                for (String key : villagerTag.m_128431_()) {
                    data.getVillagerIdentities().put(key, villagerTag.m_128469_(key));
                }
                String active = root.m_128425_("ActiveVillagerKey", 8) ? root.m_128461_("ActiveVillagerKey") : null;
                data.setActiveVillagerKey(active == null || active.isEmpty() ? null : active);
                Minecraft mc = Minecraft.m_91087_();
                Screen patt2658$temp = mc.f_91080_;
                if (patt2658$temp instanceof IdentityScreen) {
                    IdentityScreen screen = (IdentityScreen)patt2658$temp;
                    screen.m_6574_(mc, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
                }
            });
        });
    }
}

