/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import draylar.identity.Identity;
import draylar.identity.api.PlayerFavorites;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.mixin.accessor.ScreenAccessor;
import draylar.identity.screen.widget.EntityWidget;
import draylar.identity.screen.widget.HelpWidget;
import draylar.identity.screen.widget.PlayerWidget;
import draylar.identity.screen.widget.SearchWidget;
import draylar.identity.util.IdentityCompatUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class IdentityScreen
extends Screen {
    private final List<IdentityType<?>> unlocked = new ArrayList();
    private final Map<IdentityType<?>, LivingEntity> renderEntities = new LinkedHashMap();
    private final List<EntityWidget> entityWidgets = new ArrayList<EntityWidget>();
    private final Map<IdentityType<?>, String> villagerNames = new LinkedHashMap();
    private SearchWidget searchBar;
    private PlayerWidget playerButton;
    private Button helpButton;
    private String lastSearch = "";
    private int scrollY = 0;

    public IdentityScreen() {
        super((Component)Component.m_237113_((String)""));
    }

    public double getScaleFactor() {
        assert (this.f_96541_ != null);
        return this.f_96541_.m_91268_().m_85449_();
    }

    protected void m_7856_() {
        super.m_7856_();
        ((ScreenAccessor)((Object)this)).getSelectables().removeIf(w -> w instanceof EntityWidget);
        this.m_6702_().removeIf(w -> w instanceof EntityWidget);
        this.entityWidgets.clear();
        this.scrollY = 0;
        this.searchBar = this.createSearchBar();
        this.playerButton = this.createPlayerButton();
        this.helpButton = this.createHelpButton();
        this.m_142416_((GuiEventListener)this.searchBar);
        this.m_142416_((GuiEventListener)this.playerButton);
        this.m_142416_((GuiEventListener)this.helpButton);
        LocalPlayer player = this.f_96541_.f_91074_;
        if (player == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        this.loadEntities(this.f_96541_);
        this.unlocked.addAll(this.renderEntities.keySet().stream().filter(t -> PlayerUnlocks.has((Player)player, t) || player.m_7500_() || this.isVillagerEntry((IdentityType<?>)t)).collect(Collectors.toList()));
        this.unlocked.sort((a, b) -> PlayerFavorites.has((Player)player, a) ? -1 : 1);
        this.populateEntities(player, this.unlocked);
        this.searchBar.m_94151_(text -> {
            this.m_94725_((GuiEventListener)this.searchBar);
            if (!this.lastSearch.equals(text)) {
                ((ScreenAccessor)((Object)this)).getSelectables().removeIf(w -> w instanceof EntityWidget);
                this.m_6702_().removeIf(w -> w instanceof EntityWidget);
                this.entityWidgets.clear();
                String q = text.toLowerCase();
                List<IdentityType<?>> filtered = this.unlocked.stream().filter(t -> q.isEmpty() || t.getEntityType().m_20675_().toLowerCase().contains(q) || this.isVillagerEntry((IdentityType<?>)t) && this.villagerNames.getOrDefault(t, "").toLowerCase().contains(q)).collect(Collectors.toList());
                this.populateEntities(player, filtered);
                this.lastSearch = text;
                this.scrollY = 0;
            }
        });
    }

    private void loadEntities(Minecraft client) {
        for (IdentityType<?> type : IdentityType.getAllTypes((Level)client.f_91073_)) {
            if (IdentityCompatUtils.isBlacklistedEntityType(type.getEntityType())) continue;
            try {
                Object e = type.create((Level)client.f_91073_);
                this.renderEntities.put(type, (LivingEntity)e);
            }
            catch (Exception e) {
                IdentityCompatUtils.markIncompatibleEntityType(type.getEntityType());
                Identity.LOGGER.warn("Failed to create identity " + type.getEntityType().m_20675_(), (Throwable)e);
            }
        }
        try {
            if (client.f_91074_ != null) {
                IdentityType<EntityType> baseVillager;
                PlayerDataProvider data = (PlayerDataProvider)client.f_91074_;
                ArrayList<String> keys = new ArrayList<String>(data.getVillagerIdentities().keySet());
                Collections.sort(keys);
                int i = 0;
                for (String key : keys) {
                    CompoundTag tag = data.getVillagerIdentities().get(key);
                    CompoundTag copy = tag.m_6426_();
                    copy.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_((Object)EntityType.f_20492_).toString());
                    Entity loaded = EntityType.m_20645_((CompoundTag)copy, (Level)client.f_91073_, it -> it);
                    if (!(loaded instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)loaded;
                    IdentityType idType = new IdentityType(EntityType.f_20492_, 1000000 + i);
                    String display = tag.m_128441_("IdentityName") ? tag.m_128461_("IdentityName") : key;
                    this.villagerNames.put(idType, display == null ? key : display);
                    if (display != null && !display.isEmpty()) {
                        living.m_6593_((Component)Component.m_237113_((String)display));
                    }
                    this.renderEntities.put(idType, living);
                    ++i;
                }
                if (!keys.isEmpty() && !this.renderEntities.containsKey(baseVillager = new IdentityType<EntityType>(EntityType.f_20492_))) {
                    try {
                        EntityType e = baseVillager.create((Level)client.f_91073_);
                        this.renderEntities.put(baseVillager, (LivingEntity)e);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isVillagerEntry(IdentityType<?> t) {
        return t.getEntityType() == EntityType.f_20492_ && t.getVariantData() >= 1000000;
    }

    private void populateEntities(LocalPlayer player, List<IdentityType<?>> list) {
        int perRow = 7;
        int marginX = 15;
        boolean startY = false;
        Window win = this.f_96541_.m_91268_();
        float cellW = ((float)win.m_85445_() - 30.0f) / 7.0f;
        float cellH = (float)win.m_85446_() / 5.0f;
        IdentityType<LivingEntity> current = IdentityType.from(PlayerIdentity.getIdentity((Player)player));
        ArrayList invalid = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            IdentityType<?> type = list.get(i);
            int xIdx = i % 7;
            int yIdx = i / 7;
            int x = 15 + Math.round(cellW * (float)xIdx);
            int y = 0 + Math.round(cellH * (float)yIdx);
            boolean isCurr = current != null && current.equals(type);
            boolean fav = PlayerFavorites.has((Player)player, type);
            try {
                EntityWidget<LivingEntity> widget = new EntityWidget<LivingEntity>(x, y, Math.round(cellW), Math.round(cellH), type, this.renderEntities.get(type), this, fav, isCurr);
                this.m_142416_((GuiEventListener)widget);
                this.entityWidgets.add(widget);
                continue;
            }
            catch (Exception e) {
                Identity.LOGGER.warn("Failed to add identity " + type.getEntityType().m_20675_(), (Throwable)e);
                invalid.add(type);
            }
        }
        if (!invalid.isEmpty()) {
            this.unlocked.removeAll(invalid);
            this.renderEntities.keySet().removeAll(invalid);
        }
    }

    private int getHeaderHeight() {
        return this.searchBar.m_252907_() + this.searchBar.m_93694_() + 5;
    }

    public void m_88315_(GuiGraphics ctx, int mx, int my, float delta) {
        this.m_280273_(ctx);
        this.renderEntityGrid(ctx, mx, my, delta);
        if (this.unlocked.isEmpty()) {
            String hint = Component.m_237115_((String)"identity.menu_hint").getString();
            int w = this.f_96541_.f_91062_.m_92895_(hint);
            int x = (this.f_96541_.m_91268_().m_85443_() - w) / 2;
            int y = this.f_96541_.m_91268_().m_85444_() / 2;
            ctx.m_280056_(this.f_96541_.f_91062_, hint, x, y, 0xFFFFFF, true);
        }
        this.searchBar.m_88315_(ctx, mx, my, delta);
        this.playerButton.m_88315_(ctx, mx, my, delta);
        this.helpButton.m_88315_(ctx, mx, my, delta);
    }

    private void renderEntityGrid(GuiGraphics ctx, int mx, int my, float delta) {
        double sf = this.f_96541_.m_91268_().m_85449_();
        int headerH = this.getHeaderHeight();
        int viewH = this.f_96544_ - headerH;
        int scrollTop = this.scrollY;
        int scrollBot = this.scrollY + viewH;
        RenderSystem.enableScissor((int)0, (int)((int)((double)headerH * sf)), (int)((int)((double)this.f_96543_ * sf)), (int)((int)((double)viewH * sf)));
        ctx.m_280168_().m_85836_();
        ctx.m_280168_().m_252880_(0.0f, (float)(headerH - this.scrollY), 0.0f);
        for (EntityWidget w : this.entityWidgets) {
            int wh;
            int wy = w.m_252907_();
            if (wy + (wh = w.m_93694_()) < scrollTop || wy > scrollBot) continue;
            w.m_88315_(ctx, mx, my + this.scrollY - headerH, delta);
        }
        ctx.m_280168_().m_85849_();
        RenderSystem.disableScissor();
        for (EntityWidget w : this.entityWidgets) {
            if (!w.m_5953_(mx, my + this.scrollY - headerH)) continue;
            ctx.m_280557_(this.f_96541_.f_91062_, w.getHoverName(), mx, my);
            break;
        }
    }

    public double getEffectiveGuiScale() {
        int raw = (Integer)this.f_96541_.f_91066_.m_231928_().m_231551_();
        return raw == 0 ? this.f_96541_.m_91268_().m_85449_() : (double)raw;
    }

    public boolean m_6050_(double mx, double my, double amount) {
        if (this.entityWidgets.isEmpty()) {
            return false;
        }
        int rowH = this.entityWidgets.get(0).m_93694_();
        int rows = (int)Math.ceil((float)this.unlocked.size() / 7.0f);
        int totalH = rows * rowH;
        int viewH = this.f_96544_ - this.getHeaderHeight();
        int bottomPadding = 10;
        int maxY = Math.max(0, totalH - viewH + bottomPadding);
        this.scrollY = Math.max(0, Math.min(this.scrollY - (int)(amount * (double)rowH), maxY));
        return true;
    }

    public void m_6574_(Minecraft client, int width, int height) {
        super.m_6574_(client, width, height);
        this.m_169413_();
        this.scrollY = 0;
        LocalPlayer player = client.f_91074_;
        if (player != null) {
            this.renderEntities.clear();
            this.villagerNames.clear();
            this.loadEntities(client);
            this.unlocked.clear();
            this.unlocked.addAll(this.renderEntities.keySet().stream().filter(t -> PlayerUnlocks.has((Player)player, t) || player.m_7500_() || this.isVillagerEntry((IdentityType<?>)t)).collect(Collectors.toList()));
            this.unlocked.sort((a, b) -> PlayerFavorites.has((Player)player, a) ? -1 : 1);
            this.populateEntities(player, this.unlocked);
        }
    }

    public boolean m_6375_(double mx, double my, int button) {
        int hh = this.getHeaderHeight();
        if (my >= (double)hh) {
            double adjY = my + (double)this.scrollY - (double)hh;
            for (EntityWidget w : this.entityWidgets) {
                if (!w.m_6375_(mx, adjY, button)) continue;
                return true;
            }
        }
        if (my < (double)hh) {
            return this.searchBar.m_6375_(mx, my, button) || this.playerButton.m_6375_(mx, my, button) || this.helpButton.m_6375_(mx, my, button);
        }
        return super.m_6375_(mx, my, button);
    }

    public void m_7379_() {
        this.entityWidgets.forEach(EntityWidget::dispose);
        super.m_7379_();
    }

    public void m_169413_() {
        ((ScreenAccessor)((Object)this)).getSelectables().removeIf(w -> w instanceof EntityWidget);
        this.m_6702_().removeIf(w -> w instanceof EntityWidget);
        this.entityWidgets.clear();
        this.scrollY = 0;
    }

    public boolean m_7043_() {
        return false;
    }

    public void disableAll() {
        for (EntityWidget w : this.entityWidgets) {
            w.setActive(false);
        }
    }

    private SearchWidget createSearchBar() {
        assert (this.f_96541_ != null);
        float w = (float)this.f_96541_.m_91268_().m_85445_() / 4.0f;
        return new SearchWidget((float)this.f_96541_.m_91268_().m_85445_() / 2.0f - w / 2.0f, 5.0f, w, 20.0f);
    }

    private PlayerWidget createPlayerButton() {
        assert (this.f_96541_ != null);
        float cx = (float)this.f_96541_.m_91268_().m_85445_() / 2.0f;
        return new PlayerWidget(cx + (float)this.f_96541_.m_91268_().m_85445_() / 8.0f + 5.0f, 7.0f, 15.0f, 15.0f, this);
    }

    private Button createHelpButton() {
        assert (this.f_96541_ != null);
        float cx = (float)this.f_96541_.m_91268_().m_85445_() / 2.0f;
        return new HelpWidget((int)(cx - (float)this.f_96541_.m_91268_().m_85445_() / 8.0f - 5.0f) - 30, 5, 20, 20);
    }

    public int getGuiScale() {
        assert (this.f_96541_ != null);
        return (Integer)this.f_96541_.f_91066_.m_231928_().m_231551_();
    }
}

