/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.util;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AbilityUtils {
    public static EntityHitResult raycastEntities(Player player, double maxDistance) {
        Vec3 eyePosition = player.m_146892_();
        Vec3 viewVector = player.m_20252_(1.0f);
        Vec3 targetPosition = eyePosition.m_82549_(viewVector.m_82490_(maxDistance));
        BlockHitResult blockHit = player.m_9236_().m_45547_(new ClipContext(eyePosition, targetPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double blockDistance = blockHit.m_6662_() == HitResult.Type.BLOCK ? eyePosition.m_82554_(blockHit.m_82450_()) : maxDistance;
        EntityHitResult closestEntityHit = null;
        double closestDistance = blockDistance;
        AABB searchBox = player.m_20191_().m_82369_(viewVector.m_82490_(maxDistance)).m_82400_(1.0);
        List entities = player.m_9236_().m_6249_((Entity)player, searchBox, entity -> entity.m_6097_() && entity instanceof LivingEntity);
        for (Entity entity2 : entities) {
            double entityDistance;
            AABB entityBox = entity2.m_20191_().m_82400_((double)entity2.m_6143_());
            Vec3 intersection = entityBox.m_82371_(eyePosition, targetPosition).orElse(null);
            if (intersection == null || !((entityDistance = eyePosition.m_82554_(intersection)) < closestDistance)) continue;
            closestEntityHit = new EntityHitResult(entity2, intersection);
            closestDistance = entityDistance;
        }
        return closestEntityHit;
    }

    public static List<LivingEntity> raycastNearbyEntities(Player player, double maxDistance) {
        Vec3 eyePosition = player.m_146892_();
        Vec3 viewVector = player.m_20252_(1.0f);
        AABB box = player.m_20191_().m_82369_(viewVector.m_82490_(maxDistance)).m_82400_(1.5);
        return player.m_9236_().m_6443_(LivingEntity.class, box, entity -> entity != player && entity.m_6097_());
    }

    public static void knockbackNearbyEntities(Player player, float radius, double strength) {
        Level world = player.m_9236_();
        for (LivingEntity livingEntity : world.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)radius), entity -> entity != player)) {
            double dx = livingEntity.m_20185_() - player.m_20185_();
            double dz = livingEntity.m_20189_() - player.m_20189_();
            double distance = Math.max(Math.sqrt(dx * dx + dz * dz), 0.001);
            livingEntity.m_5997_(dx / distance * strength, 0.1, dz / distance * strength);
        }
    }

    public static void dashForward(Player player, double distance) {
        Vec3 look = player.m_20252_(1.0f);
        player.m_20334_(look.f_82479_ * distance, player.m_20184_().f_82480_, look.f_82481_ * distance);
        player.f_19864_ = true;
    }

    public static void dropRandomItemFromInventory(Player player) {
        if (!player.m_150109_().m_7983_()) {
            Random random = new Random();
            int slot = random.nextInt(player.m_150109_().m_6643_() - 1);
            if (!player.m_150109_().m_8020_(slot).m_41619_()) {
                player.m_20000_((ItemLike)player.m_150109_().m_8020_(slot).m_41720_(), 1);
                player.m_150109_().m_7407_(slot, 1);
            }
        }
    }

    public static void healNearbyPlayers(Player player, float radius, float healAmount) {
        Level world = player.m_9236_();
        for (LivingEntity livingEntity : world.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)radius), entity -> entity instanceof Player)) {
            livingEntity.m_5634_(healAmount);
        }
    }

    public static void randomMorphNearby(Player player) {
        System.out.println("Morphing into a nearby entity...");
    }

    public static void constrictNearby(Player player, float radius) {
        Level world = player.m_9236_();
        List entities = world.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)radius), entity -> entity != player);
        for (LivingEntity living : entities) {
            living.m_20256_(Vec3.f_82478_);
            living.f_19864_ = true;
            living.m_147244_(true);
        }
    }

    public static void dashUpward(Player player, double power) {
        Vec3 current = player.m_20184_();
        player.m_20334_(current.f_82479_, power, current.f_82481_);
        player.f_19864_ = true;
    }

    public static void waterDash(Player player, double power) {
        if (player.m_20069_()) {
            Vec3 look = player.m_20252_(1.0f);
            Vec3 current = player.m_20184_();
            Vec3 added = new Vec3(look.f_82479_ * power, look.f_82480_ * 0.5, look.f_82481_ * power);
            player.m_20256_(current.m_82549_(added));
            player.f_19864_ = true;
        }
    }

    public static void shortTeleportForward(Player player, double distance) {
        Vec3 look = player.m_20252_(1.0f);
        Vec3 target = player.m_20182_().m_82549_(look.m_82490_(distance));
        player.m_6021_(target.f_82479_, target.f_82480_, target.f_82481_);
    }

    public static void pullEntityTowardPlayer(Player player, LivingEntity target, double strength) {
        Vec3 direction = player.m_20182_().m_82546_(target.m_20182_()).m_82541_();
        target.m_20334_(direction.f_82479_ * strength, 0.2, direction.f_82481_ * strength);
        target.f_19864_ = true;
    }

    public static void poisonNearbyEnemies(Player player, float radius, int durationTicks, int amplifier) {
        Level world = player.m_9236_();
        for (LivingEntity entity : world.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)radius), e -> e != player)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, durationTicks, amplifier));
        }
    }

    public static BlockPos findNearbyJukebox(Level world, BlockPos origin) {
        double radius = 3.46;
        int blockRadius = (int)Math.ceil(radius);
        int originChunkX = origin.m_123341_() >> 4;
        int originChunkZ = origin.m_123343_() >> 4;
        int chunkRadius = (blockRadius >> 4) + 1;
        for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
            for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                LevelChunk chunk = world.m_6325_(originChunkX + dx, originChunkZ + dz);
                if (!(chunk instanceof LevelChunk)) continue;
                LevelChunk worldChunk = chunk;
                for (BlockEntity be : worldChunk.m_62954_().values()) {
                    JukeboxBlockEntity jukebox;
                    if (!(be instanceof JukeboxBlockEntity) || !(jukebox = (JukeboxBlockEntity)be).m_58899_().m_123314_((Vec3i)origin, radius)) continue;
                    return jukebox.m_58899_();
                }
            }
        }
        return null;
    }
}

