/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.util;

import dev.architectury.platform.Platform;
import draylar.identity.Identity;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class IdentityCompatUtils {
    private static final Set<ResourceLocation> INCOMPATIBLE_TYPES = new HashSet<ResourceLocation>();

    public static boolean isBlacklistedEntityType(EntityType<?> type) {
        ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_(type);
        if (INCOMPATIBLE_TYPES.contains(id)) {
            return true;
        }
        return id.m_135827_().equals("dragonmounts") && id.m_135815_().equals("dragon");
    }

    public static void markIncompatibleEntityType(EntityType<?> type) {
        ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_(type);
        INCOMPATIBLE_TYPES.add(id);
        Identity.LOGGER.warn("Marked incompatible identity {}", (Object)id);
    }

    public static boolean isAlexsMobsLoaded() {
        return Platform.isModLoaded((String)"alexsmobs");
    }

    public static boolean isNaturalistLoaded() {
        return Platform.isModLoaded((String)"naturalist");
    }
}

