/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin.player;

import dev.architectury.event.EventResult;
import draylar.identity.Identity;
import draylar.identity.api.FlightHelper;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.SafeTagManager;
import draylar.identity.api.event.IdentitySwapCallback;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.DimensionsRefresher;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.mixin.EntityTrackerAccessor;
import draylar.identity.mixin.ThreadedAnvilChunkStorageAccessor;
import draylar.identity.registry.IdentityEntityTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1584;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityDataMixin
extends class_1309
implements PlayerDataProvider {
    @Unique
    private static final String ABILITY_COOLDOWN_KEY = "AbilityCooldown";
    @Unique
    private final Set<IdentityType<?>> unlocked = new HashSet();
    @Unique
    private final Set<IdentityType<?>> favorites = new HashSet();
    @Unique
    private int remainingTime = 0;
    @Unique
    private int abilityCooldown = 0;
    @Unique
    private class_1309 identity = null;
    @Unique
    private IdentityType<?> identityType = null;
    @Unique
    private final Map<String, class_2487> villagerIdentities = new HashMap<String, class_2487>();
    @Unique
    @Nullable
    private String activeVillagerKey = null;

    @Shadow
    public abstract void method_5783(class_3414 var1, float var2, float var3);

    private PlayerEntityDataMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    private void readNbt(class_2487 tag, CallbackInfo info) {
        String storedKey;
        this.unlocked.clear();
        class_2499 unlockedIdList = tag.method_10554("UnlockedMorphs", 8);
        unlockedIdList.forEach(entityRegistryID -> {
            class_2960 id = new class_2960(entityRegistryID.method_10714());
            if (class_7923.field_41177.method_10250(id)) {
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
                this.unlocked.add(new IdentityType<class_1299>(type));
            }
        });
        class_2499 unlockedIdentityList = tag.method_10554("UnlockedIdentities", 10);
        unlockedIdentityList.forEach(compound -> {
            IdentityType<?> type = IdentityType.from((class_2487)compound);
            if (type != null) {
                this.unlocked.add(type);
            }
        });
        this.favorites.clear();
        class_2499 favoriteIdList = tag.method_10554("FavoriteIdentities", 8);
        favoriteIdList.forEach(registryID -> {
            class_2960 id = new class_2960(registryID.method_10714());
            if (class_7923.field_41177.method_10250(id)) {
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
                this.favorites.add(new IdentityType<class_1299>(type));
            }
        });
        class_2499 favoriteTypeList = tag.method_10554("FavoriteIdentitiesV2", 8);
        favoriteTypeList.forEach(compound -> {
            IdentityType<?> type = IdentityType.from((class_2487)compound);
            if (type != null) {
                this.favorites.add(type);
            }
        });
        this.abilityCooldown = tag.method_10550(ABILITY_COOLDOWN_KEY);
        this.remainingTime = tag.method_10550("RemainingHostilityTime");
        this.readCurrentIdentity(tag.method_10562("CurrentIdentity"));
        if (this.identity != null) {
            ((class_1657)this).method_49477(this.identity.method_49476());
        } else {
            ((class_1657)this).method_49477(0.6f);
        }
        this.villagerIdentities.clear();
        class_2487 villagerTag = tag.method_10562("VillagerIdentities");
        for (String key : villagerTag.method_10541()) {
            this.villagerIdentities.put(key, villagerTag.method_10562(key));
        }
        this.activeVillagerKey = tag.method_10573("ActiveVillagerKey", 8) ? ((storedKey = tag.method_10558("ActiveVillagerKey")).isEmpty() ? null : storedKey) : null;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    private void writeNbt(class_2487 tag, CallbackInfo info) {
        class_2499 idList = new class_2499();
        this.unlocked.forEach(identity -> idList.add((Object)identity.writeCompound()));
        tag.method_10566("UnlockedIdentities", (class_2520)idList);
        idList = new class_2499();
        this.favorites.forEach(entityId -> idList.add((Object)entityId.writeCompound()));
        tag.method_10566("FavoriteIdentitiesV2", (class_2520)idList);
        tag.method_10569(ABILITY_COOLDOWN_KEY, this.abilityCooldown);
        tag.method_10569("RemainingHostilityTime", this.remainingTime);
        tag.method_10566("CurrentIdentity", (class_2520)this.writeCurrentIdentity(new class_2487()));
        class_2487 villagerTag = new class_2487();
        this.villagerIdentities.forEach((key, value) -> villagerTag.method_10566(key, (class_2520)value.method_10553()));
        tag.method_10566("VillagerIdentities", (class_2520)villagerTag);
        if (this.activeVillagerKey != null && !this.activeVillagerKey.isEmpty()) {
            tag.method_10582("ActiveVillagerKey", this.activeVillagerKey);
        }
    }

    @Unique
    private class_2487 writeCurrentIdentity(class_2487 tag) {
        class_2487 entityTag = new class_2487();
        if (this.identity != null) {
            this.identity.method_5647(entityTag);
            if (this.identityType != null) {
                this.identityType.writeEntityNbt(entityTag);
            }
        }
        tag.method_10582("id", this.identity == null ? "minecraft:empty" : class_7923.field_41177.method_10221((Object)this.identity.method_5864()).toString());
        tag.method_10566("EntityData", (class_2520)entityTag);
        return tag;
    }

    @Unique
    public void readCurrentIdentity(class_2487 tag) {
        class_2487 entityTag;
        Optional type = class_1299.method_17684((class_2487)tag);
        if (tag.method_10558("id").equals("minecraft:empty")) {
            this.identity = null;
            ((DimensionsRefresher)((Object)this)).identity_refreshDimensions();
        } else if (type.isPresent() && (entityTag = tag.method_10562("EntityData")) != null) {
            if (this.identity == null || !((class_1299)type.get()).equals(this.identity.method_5864())) {
                this.identity = (class_1309)((class_1299)type.get()).method_5883(this.method_37908());
                ((DimensionsRefresher)((Object)this)).identity_refreshDimensions();
            }
            this.identity.method_5651(entityTag);
            this.identityType = IdentityType.fromEntityNbt(tag);
        }
    }

    @Override
    @Unique
    public Set<IdentityType<?>> getUnlocked() {
        return this.unlocked;
    }

    @Override
    public void setUnlocked(Set<IdentityType<?>> unlocked) {
        this.unlocked.clear();
        this.unlocked.addAll(unlocked);
    }

    @Override
    @Unique
    public Set<IdentityType<?>> getFavorites() {
        return this.favorites;
    }

    @Override
    public void setFavorites(Set<IdentityType<?>> favorites) {
        this.favorites.clear();
        this.favorites.addAll(favorites);
    }

    @Override
    @Unique
    public int getRemainingHostilityTime() {
        return this.remainingTime;
    }

    @Override
    @Unique
    public void setRemainingHostilityTime(int max) {
        this.remainingTime = max;
    }

    @Override
    @Unique
    public int getAbilityCooldown() {
        return this.abilityCooldown;
    }

    @Override
    @Unique
    public void setAbilityCooldown(int abilityCooldown) {
        this.abilityCooldown = abilityCooldown;
    }

    @Override
    @Unique
    public class_1309 getIdentity() {
        return this.identity;
    }

    @Override
    public IdentityType<?> getIdentityType() {
        return this.identityType;
    }

    @Override
    public void setIdentityType(@Nullable IdentityType<?> type) {
        this.identityType = type;
    }

    @Override
    public Map<String, class_2487> getVillagerIdentities() {
        return this.villagerIdentities;
    }

    @Override
    public void setVillagerIdentity(String key, class_2487 identity) {
        if (identity == null) {
            this.villagerIdentities.remove(key);
        } else {
            this.villagerIdentities.put(key, identity);
        }
    }

    @Override
    public void removeVillagerIdentity(String key) {
        this.villagerIdentities.remove(key);
        if (this.activeVillagerKey != null && this.activeVillagerKey.equals(key)) {
            this.activeVillagerKey = null;
        }
    }

    @Override
    @Nullable
    public String getActiveVillagerKey() {
        return this.activeVillagerKey;
    }

    @Override
    public void setActiveVillagerKey(@Nullable String key) {
        this.activeVillagerKey = key;
    }

    @Override
    @Unique
    public void setIdentity(class_1309 identity) {
        this.identity = identity;
        if (!(identity instanceof class_1646)) {
            this.activeVillagerKey = null;
        }
    }

    @Override
    @Unique
    public boolean updateIdentity(@Nullable class_1309 identity) {
        double newMax;
        double oldMax;
        class_1657 player = (class_1657)this;
        EventResult result = ((IdentitySwapCallback)IdentitySwapCallback.EVENT.invoker()).swap((class_3222)player, identity);
        if (result.isFalse()) {
            return false;
        }
        this.identity = identity;
        if (!(identity instanceof class_1646)) {
            this.activeVillagerKey = null;
        }
        ((DimensionsRefresher)player).identity_refreshDimensions();
        if (identity != null) {
            player.method_49477(identity.method_49476());
        } else {
            player.method_49477(0.6f);
        }
        if (identity != null && IdentityConfig.getInstance().scalingHealth()) {
            oldMax = player.method_5996(class_5134.field_23716).method_6201();
            newMax = Math.min((float)IdentityConfig.getInstance().maxHealth(), identity.method_6063());
            this.identity$scaleHealth(player, oldMax, newMax);
        }
        if (identity == null && IdentityConfig.getInstance().scalingHealth()) {
            oldMax = player.method_5996(class_5134.field_23716).method_6201();
            newMax = 20.0;
            this.identity$scaleHealth(player, oldMax, newMax);
        }
        class_3222 serverPlayerEntity = (class_3222)player;
        if (Identity.hasFlyingPermissions((class_3222)player)) {
            FlightHelper.grantFlightTo(serverPlayerEntity);
            player.method_31549().method_7248(IdentityConfig.getInstance().flySpeed());
            player.method_7355();
        } else {
            FlightHelper.revokeFlight(serverPlayerEntity);
            player.method_31549().method_7248(0.05f);
            player.method_7355();
        }
        if (player.method_5854() instanceof class_1584) {
            if (identity == null) {
                player.method_5848();
            } else if (!identity.method_5864().method_20210(IdentityEntityTags.RAVAGER_RIDING) || SafeTagManager.isCustomRavagerRiding(identity.method_5864())) {
                player.method_5848();
            }
        }
        if (!player.method_37908().field_9236) {
            PlayerIdentity.sync((class_3222)player);
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((class_3218)player.method_37908()).method_14178().field_17254).getEntityTrackers();
            Object tracking = trackers.get(player.method_5628());
            ((EntityTrackerAccessor)tracking).getListeners().forEach(listener -> PlayerIdentity.sync((class_3222)player, listener.method_32311()));
        }
        return true;
    }

    @Unique
    private void identity$scaleHealth(class_1657 player, double oldMax, double newMax) {
        double currentHealth = player.method_6032();
        double ratio = oldMax > 0.0 ? currentHealth / oldMax : 1.0;
        double scaledHealth = class_3532.method_15350((double)(ratio * newMax), (double)1.0, (double)newMax);
        player.method_5996(class_5134.field_23716).method_6192(newMax);
        player.method_6033((float)scaledHealth);
    }
}

