/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network.impl;

import dev.architectury.networking.NetworkManager;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.NetworkHandler;
import draylar.identity.network.impl.VillagerIdentitiesPackets;
import io.netty.buffer.Unpooled;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7477;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class VillagerProfessionPackets {
    public static void openScreen(class_3222 player, class_2960 professionId, class_2338 pos, class_2960 worldId, String existingName, String existingProfessionId) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10812(professionId);
        packet.method_10807(pos);
        packet.method_10812(worldId);
        packet.writeBoolean(existingName != null);
        if (existingName != null) {
            packet.method_10814(existingName);
            packet.method_10814(existingProfessionId == null ? "" : existingProfessionId);
        }
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)NetworkHandler.OPEN_PROFESSION_SCREEN, (class_2540)packet);
    }

    public static void sendSetProfession(class_2960 professionId, String name, boolean reset, class_2338 pos, class_2960 worldId, String originalName) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10812(professionId);
        packet.method_10814(name);
        packet.writeBoolean(reset);
        packet.method_10807(pos);
        packet.method_10812(worldId);
        packet.writeBoolean(originalName != null);
        if (originalName != null) {
            packet.method_10814(originalName);
        }
        NetworkManager.sendToServer((class_2960)NetworkHandler.SET_PROFESSION, (class_2540)packet);
    }

    public static void registerServerHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)NetworkHandler.SET_PROFESSION, (buf, context) -> {
            class_2960 professionId = buf.method_10810();
            String name = buf.method_19772();
            boolean reset = buf.readBoolean();
            class_2338 pos = buf.method_10811();
            class_2960 worldId = buf.method_10810();
            boolean hasOriginal = buf.readBoolean();
            String originalName = hasOriginal ? buf.method_19772() : null;
            class_3222 player = (class_3222)context.getPlayer();
            context.getPlayer().method_5682().execute(() -> VillagerProfessionPackets.handleServerRequest(player, professionId, name, reset, pos, worldId, originalName));
        });
    }

    private static void handleServerRequest(class_3222 player, class_2960 professionId, String rawName, boolean reset, class_2338 pos, class_2960 worldId, String originalName) {
        PlayerDataProvider data = (PlayerDataProvider)player;
        Map<String, class_2487> map = data.getVillagerIdentities();
        long workstationPos = pos.method_10063();
        String trimmedName = rawName.trim();
        String existingKey = null;
        if (originalName != null && map.containsKey(originalName) && VillagerProfessionPackets.matchesWorkstation(map.get(originalName), worldId, workstationPos)) {
            existingKey = originalName;
        }
        if (existingKey == null) {
            for (Map.Entry<String, class_2487> entry : map.entrySet()) {
                if (!VillagerProfessionPackets.matchesWorkstation(entry.getValue(), worldId, workstationPos)) continue;
                existingKey = entry.getKey();
                break;
            }
        }
        if (reset) {
            if (existingKey != null) {
                data.removeVillagerIdentity(existingKey);
                player.method_7353((class_2561)class_2561.method_43469((String)"identity.profession.removed", (Object[])new Object[]{existingKey}), false);
                PlayerIdentity.sync(player);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"identity.profession.none"), false);
            }
            return;
        }
        if (trimmedName.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"identity.profession.require_name"), false);
            return;
        }
        if (map.containsKey(trimmedName) && (existingKey == null || !existingKey.equals(trimmedName))) {
            player.method_7353((class_2561)class_2561.method_43469((String)"identity.profession.name_conflict", (Object[])new Object[]{trimmedName}), false);
            return;
        }
        class_3218 world = player.method_5682().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)worldId));
        if (world == null || !world.method_27983().equals(player.method_37908().method_27983())) {
            player.method_7353((class_2561)class_2561.method_43471((String)"identity.profession.invalid_world"), false);
            return;
        }
        if (class_7477.method_43989((class_2680)world.method_8320(pos)).isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"identity.profession.invalid_workstation"), false);
            return;
        }
        class_1309 class_13092 = PlayerIdentity.getIdentity((class_1657)player);
        if (!(class_13092 instanceof class_1646)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"identity.profession.missing_identity"), false);
            return;
        }
        class_1646 villager = (class_1646)class_13092;
        class_2487 tag = new class_2487();
        class_3852 profession = class_7923.field_41195.method_17966(professionId).orElse(class_3852.field_17051);
        villager.method_7195(new class_3850(villager.method_7231().method_16919(), profession, villager.method_7231().method_16925()));
        villager.method_5647(tag);
        tag.method_10582("ProfessionId", professionId.toString());
        tag.method_10582("WorkstationDim", worldId.toString());
        tag.method_10544("WorkstationPos", workstationPos);
        tag.method_10582("IdentityName", trimmedName);
        data.setVillagerIdentity(trimmedName, tag);
        if (existingKey != null && !existingKey.equals(trimmedName)) {
            data.removeVillagerIdentity(existingKey);
        }
        String activeKey = data.getActiveVillagerKey();
        if (existingKey != null && existingKey.equals(activeKey)) {
            data.setActiveVillagerKey(trimmedName);
        } else if (existingKey == null) {
            data.setActiveVillagerKey(trimmedName);
        }
        class_5250 professionText = class_2561.method_43470((String)professionId.toString());
        player.method_7353((class_2561)class_2561.method_43469((String)(existingKey != null ? "identity.profession.updated" : "identity.profession.saved"), (Object[])new Object[]{trimmedName, professionText}), false);
        world.method_14199((class_2394)class_2398.field_11211, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 10, 0.5, 0.5, 0.5, 0.0);
        PlayerIdentity.sync(player);
        VillagerIdentitiesPackets.sendSync(player);
    }

    private static boolean matchesWorkstation(class_2487 tag, class_2960 worldId, long workstationPos) {
        if (tag == null) {
            return false;
        }
        String dim = tag.method_10558("WorkstationDim");
        long storedPos = tag.method_10545("WorkstationPos") ? tag.method_10537("WorkstationPos") : Long.MIN_VALUE;
        return !dim.isEmpty() && storedPos != Long.MIN_VALUE && worldId.toString().equals(dim) && storedPos == workstationPos;
    }
}

