/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.api;

import draylar.identity.registry.IdentityEntityTags;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class SafeTagManager {
    private static final Set<class_2960> CUSTOM_FLYING_ENTITIES = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_BREATHE_UNDERWATER_ENTITIES = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_FIRE_IMMUNE_ENTITIES = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_SLOW_FALLING = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_BURNS_IN_DAYLIGHT = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_CANT_SWIM = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_HURT_BY_HEAT = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_LAVA_WALKING = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_PIGLIN_FRIENDLY = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_RAVAGER_RIDING = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_UNDROWNABLE = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_WOLF_PREY = new HashSet<class_2960>();
    private static final Set<class_2960> CUSTOM_FOX_PREY = new HashSet<class_2960>();

    public static void loadAll(MinecraftServer server) {
        class_2378 entityTypeRegistry = server.method_30611().method_30530(class_7924.field_41266);
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_FLYING), CUSTOM_FLYING_ENTITIES, "custom_flying");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_BREATHE_UNDERWATER), CUSTOM_BREATHE_UNDERWATER_ENTITIES, "custom_breathe_underwater");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_FIRE_IMMUNE), CUSTOM_FIRE_IMMUNE_ENTITIES, "custom_fire_immune");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_SLOW_FALLING), CUSTOM_SLOW_FALLING, "custom_slow_falling");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_BURNS_IN_DAYLIGHT), CUSTOM_BURNS_IN_DAYLIGHT, "custom_burns_in_daylight");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_CANT_SWIM), CUSTOM_CANT_SWIM, "custom_cant_swim");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_HURT_BY_HEAT), CUSTOM_HURT_BY_HEAT, "custom_hurt_by_high_temperature");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_LAVA_WALKING), CUSTOM_LAVA_WALKING, "custom_lava_walking");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_PIGLIN_FRIENDLY), CUSTOM_PIGLIN_FRIENDLY, "custom_piglin_friendly");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_RAVAGER_RIDING), CUSTOM_RAVAGER_RIDING, "custom_ravager_riding");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_UNDROWNABLE), CUSTOM_UNDROWNABLE, "custom_undrownable");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_WOLF_PREY), CUSTOM_WOLF_PREY, "custom_wolf_prey");
        SafeTagManager.loadTagSafely(entityTypeRegistry.method_40266(IdentityEntityTags.CUSTOM_FOX_PREY), CUSTOM_FOX_PREY, "custom_fox_prey");
    }

    private static void loadTagSafely(Optional<class_6885.class_6888<class_1299<?>>> tagListOpt, Set<class_2960> targetSet, String tagName) {
        targetSet.clear();
        if (tagListOpt.isPresent()) {
            for (class_6880 entry : tagListOpt.get()) {
                class_2960 id = class_1299.method_5890((class_1299)((class_1299)entry.comp_349()));
                if (id != null) {
                    targetSet.add(id);
                    continue;
                }
                System.out.println("[Identity] Skipping missing entity in " + tagName);
            }
            System.out.println("[Identity] Loaded " + targetSet.size() + " entries into " + tagName);
        } else {
            System.out.println("[Identity] Warning: Tag not found: " + tagName);
        }
    }

    public static boolean isCustomFlying(class_1299<?> type) {
        return CUSTOM_FLYING_ENTITIES.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomBreatheUnderwater(class_1299<?> type) {
        return CUSTOM_BREATHE_UNDERWATER_ENTITIES.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomFireImmune(class_1299<?> type) {
        return CUSTOM_FIRE_IMMUNE_ENTITIES.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomSlowFalling(class_1299<?> type) {
        return CUSTOM_SLOW_FALLING.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomBurnsInDaylight(class_1299<?> type) {
        return CUSTOM_BURNS_IN_DAYLIGHT.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomCantSwim(class_1299<?> type) {
        return CUSTOM_CANT_SWIM.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomHurtByHeat(class_1299<?> type) {
        return CUSTOM_HURT_BY_HEAT.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomLavaWalking(class_1299<?> type) {
        return CUSTOM_LAVA_WALKING.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomPiglinFriendly(class_1299<?> type) {
        return CUSTOM_PIGLIN_FRIENDLY.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomRavagerRiding(class_1299<?> type) {
        return CUSTOM_RAVAGER_RIDING.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomUndrownable(class_1299<?> type) {
        return CUSTOM_UNDROWNABLE.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomWolfPrey(class_1299<?> type) {
        return CUSTOM_WOLF_PREY.contains(class_1299.method_5890(type));
    }

    public static boolean isCustomFoxPrey(class_1299<?> type) {
        return CUSTOM_FOX_PREY.contains(class_1299.method_5890(type));
    }
}

