/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.util;

import java.util.List;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_2818;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class AbilityUtils {
    public static class_3966 raycastEntities(class_1657 player, double maxDistance) {
        class_243 eyePosition = player.method_33571();
        class_243 viewVector = player.method_5828(1.0f);
        class_243 targetPosition = eyePosition.method_1019(viewVector.method_1021(maxDistance));
        class_3965 blockHit = player.method_37908().method_17742(new class_3959(eyePosition, targetPosition, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        double blockDistance = blockHit.method_17783() == class_239.class_240.field_1332 ? eyePosition.method_1022(blockHit.method_17784()) : maxDistance;
        class_3966 closestEntityHit = null;
        double closestDistance = blockDistance;
        class_238 searchBox = player.method_5829().method_18804(viewVector.method_1021(maxDistance)).method_1014(1.0);
        List entities = player.method_37908().method_8333((class_1297)player, searchBox, entity -> entity.method_5732() && entity instanceof class_1309);
        for (class_1297 entity2 : entities) {
            double entityDistance;
            class_238 entityBox = entity2.method_5829().method_1014((double)entity2.method_5871());
            class_243 intersection = entityBox.method_992(eyePosition, targetPosition).orElse(null);
            if (intersection == null || !((entityDistance = eyePosition.method_1022(intersection)) < closestDistance)) continue;
            closestEntityHit = new class_3966(entity2, intersection);
            closestDistance = entityDistance;
        }
        return closestEntityHit;
    }

    public static List<class_1309> raycastNearbyEntities(class_1657 player, double maxDistance) {
        class_243 eyePosition = player.method_33571();
        class_243 viewVector = player.method_5828(1.0f);
        class_238 box = player.method_5829().method_18804(viewVector.method_1021(maxDistance)).method_1014(1.5);
        return player.method_37908().method_8390(class_1309.class, box, entity -> entity != player && entity.method_5732());
    }

    public static void knockbackNearbyEntities(class_1657 player, float radius, double strength) {
        class_1937 world = player.method_37908();
        for (class_1309 livingEntity : world.method_8390(class_1309.class, player.method_5829().method_1014((double)radius), entity -> entity != player)) {
            double dx = livingEntity.method_23317() - player.method_23317();
            double dz = livingEntity.method_23321() - player.method_23321();
            double distance = Math.max(Math.sqrt(dx * dx + dz * dz), 0.001);
            livingEntity.method_5762(dx / distance * strength, 0.1, dz / distance * strength);
        }
    }

    public static void dashForward(class_1657 player, double distance) {
        class_243 look = player.method_5828(1.0f);
        player.method_18800(look.field_1352 * distance, player.method_18798().field_1351, look.field_1350 * distance);
        player.field_6037 = true;
    }

    public static void dropRandomItemFromInventory(class_1657 player) {
        if (!player.method_31548().method_5442()) {
            Random random = new Random();
            int slot = random.nextInt(player.method_31548().method_5439() - 1);
            if (!player.method_31548().method_5438(slot).method_7960()) {
                player.method_5870((class_1935)player.method_31548().method_5438(slot).method_7909(), 1);
                player.method_31548().method_5434(slot, 1);
            }
        }
    }

    public static void healNearbyPlayers(class_1657 player, float radius, float healAmount) {
        class_1937 world = player.method_37908();
        for (class_1309 livingEntity : world.method_8390(class_1309.class, player.method_5829().method_1014((double)radius), entity -> entity instanceof class_1657)) {
            livingEntity.method_6025(healAmount);
        }
    }

    public static void randomMorphNearby(class_1657 player) {
        System.out.println("Morphing into a nearby entity...");
    }

    public static void constrictNearby(class_1657 player, float radius) {
        class_1937 world = player.method_37908();
        List entities = world.method_8390(class_1309.class, player.method_5829().method_1014((double)radius), entity -> entity != player);
        for (class_1309 living : entities) {
            living.method_18799(class_243.field_1353);
            living.field_6037 = true;
            living.method_35054(true);
        }
    }

    public static void dashUpward(class_1657 player, double power) {
        class_243 current = player.method_18798();
        player.method_18800(current.field_1352, power, current.field_1350);
        player.field_6037 = true;
    }

    public static void waterDash(class_1657 player, double power) {
        if (player.method_5799()) {
            class_243 look = player.method_5828(1.0f);
            class_243 current = player.method_18798();
            class_243 added = new class_243(look.field_1352 * power, look.field_1351 * 0.5, look.field_1350 * power);
            player.method_18799(current.method_1019(added));
            player.field_6037 = true;
        }
    }

    public static void shortTeleportForward(class_1657 player, double distance) {
        class_243 look = player.method_5828(1.0f);
        class_243 target = player.method_19538().method_1019(look.method_1021(distance));
        player.method_5859(target.field_1352, target.field_1351, target.field_1350);
    }

    public static void pullEntityTowardPlayer(class_1657 player, class_1309 target, double strength) {
        class_243 direction = player.method_19538().method_1020(target.method_19538()).method_1029();
        target.method_18800(direction.field_1352 * strength, 0.2, direction.field_1350 * strength);
        target.field_6037 = true;
    }

    public static void poisonNearbyEnemies(class_1657 player, float radius, int durationTicks, int amplifier) {
        class_1937 world = player.method_37908();
        for (class_1309 entity : world.method_8390(class_1309.class, player.method_5829().method_1014((double)radius), e -> e != player)) {
            entity.method_6092(new class_1293(class_1294.field_5899, durationTicks, amplifier));
        }
    }

    public static class_2338 findNearbyJukebox(class_1937 world, class_2338 origin) {
        double radius = 3.46;
        int blockRadius = (int)Math.ceil(radius);
        int originChunkX = origin.method_10263() >> 4;
        int originChunkZ = origin.method_10260() >> 4;
        int chunkRadius = (blockRadius >> 4) + 1;
        for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
            for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                class_2818 chunk = world.method_8497(originChunkX + dx, originChunkZ + dz);
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = chunk;
                for (class_2586 be : worldChunk.method_12214().values()) {
                    class_2619 jukebox;
                    if (!(be instanceof class_2619) || !(jukebox = (class_2619)be).method_11016().method_19771((class_2382)origin, radius)) continue;
                    return jukebox.method_11016();
                }
            }
        }
        return null;
    }
}

