/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import draylar.identity.Identity;
import draylar.identity.api.PlayerFavorites;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.mixin.accessor.ScreenAccessor;
import draylar.identity.screen.widget.EntityWidget;
import draylar.identity.screen.widget.HelpWidget;
import draylar.identity.screen.widget.PlayerWidget;
import draylar.identity.screen.widget.SearchWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.Gabou.gaboulibs.util.CompatUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class IdentityScreen
extends class_437 {
    private final List<IdentityType<?>> unlocked = new ArrayList();
    private final Map<IdentityType<?>, class_1309> renderEntities = new LinkedHashMap();
    private final List<EntityWidget> entityWidgets = new ArrayList<EntityWidget>();
    private final Map<IdentityType<?>, String> villagerNames = new LinkedHashMap();
    private SearchWidget searchBar;
    private PlayerWidget playerButton;
    private class_4185 helpButton;
    private String lastSearch = "";
    private int scrollY = 0;

    public IdentityScreen() {
        super((class_2561)class_2561.method_43470((String)""));
    }

    public double getScaleFactor() {
        assert (this.field_22787 != null);
        return this.field_22787.method_22683().method_4495();
    }

    protected void method_25426() {
        super.method_25426();
        ((ScreenAccessor)((Object)this)).getSelectables().removeIf(w -> w instanceof EntityWidget);
        this.method_25396().removeIf(w -> w instanceof EntityWidget);
        this.entityWidgets.clear();
        this.scrollY = 0;
        this.searchBar = this.createSearchBar();
        this.playerButton = this.createPlayerButton();
        this.helpButton = this.createHelpButton();
        this.method_37063((class_364)this.searchBar);
        this.method_37063((class_364)this.playerButton);
        this.method_37063((class_364)this.helpButton);
        class_746 player = this.field_22787.field_1724;
        if (player == null) {
            this.field_22787.method_1507(null);
            return;
        }
        this.loadEntities(this.field_22787);
        this.unlocked.addAll(this.renderEntities.keySet().stream().filter(t -> PlayerUnlocks.has((class_1657)player, t) || player.method_7337() || this.isVillagerEntry((IdentityType<?>)t)).collect(Collectors.toList()));
        this.unlocked.sort((a, b) -> PlayerFavorites.has((class_1657)player, a) ? -1 : 1);
        this.populateEntities(player, this.unlocked);
        this.searchBar.method_1863(text -> {
            this.method_20086((class_364)this.searchBar);
            if (!this.lastSearch.equals(text)) {
                ((ScreenAccessor)((Object)this)).getSelectables().removeIf(w -> w instanceof EntityWidget);
                this.method_25396().removeIf(w -> w instanceof EntityWidget);
                this.entityWidgets.clear();
                String q = text.toLowerCase();
                List<IdentityType<?>> filtered = this.unlocked.stream().filter(t -> q.isEmpty() || t.getEntityType().method_5882().toLowerCase().contains(q) || this.isVillagerEntry((IdentityType<?>)t) && this.villagerNames.getOrDefault(t, "").toLowerCase().contains(q)).collect(Collectors.toList());
                this.populateEntities(player, filtered);
                this.lastSearch = text;
                this.scrollY = 0;
            }
        });
    }

    private void loadEntities(class_310 client) {
        for (IdentityType<?> type : IdentityType.getAllTypes((class_1937)client.field_1687)) {
            if (CompatUtils.isBlacklistedEntityType((String)type.getEntityType().toString())) continue;
            try {
                Object e = type.create((class_1937)client.field_1687);
                this.renderEntities.put(type, (class_1309)e);
            }
            catch (Exception e) {
                CompatUtils.markIncompatibleEntityType((String)type.getEntityType().toString());
                Identity.LOGGER.warn("Failed to create identity " + type.getEntityType().method_5882(), (Throwable)e);
            }
        }
        try {
            if (client.field_1724 != null) {
                IdentityType<class_1299> baseVillager;
                PlayerDataProvider data = (PlayerDataProvider)client.field_1724;
                ArrayList<String> keys = new ArrayList<String>(data.getVillagerIdentities().keySet());
                Collections.sort(keys);
                int i = 0;
                for (String key : keys) {
                    class_2487 tag = data.getVillagerIdentities().get(key);
                    class_2487 copy = tag.method_10553();
                    copy.method_10582("id", class_7923.field_41177.method_10221((Object)class_1299.field_6077).toString());
                    class_1297 loaded = class_1299.method_17842((class_2487)copy, (class_1937)client.field_1687, it -> it);
                    if (!(loaded instanceof class_1309)) continue;
                    class_1309 living = (class_1309)loaded;
                    IdentityType idType = new IdentityType(class_1299.field_6077, 1000000 + i);
                    String display = tag.method_10545("IdentityName") ? tag.method_10558("IdentityName") : key;
                    this.villagerNames.put(idType, display == null ? key : display);
                    if (display != null && !display.isEmpty()) {
                        living.method_5665((class_2561)class_2561.method_43470((String)display));
                    }
                    this.renderEntities.put(idType, living);
                    ++i;
                }
                if (!keys.isEmpty() && !this.renderEntities.containsKey(baseVillager = new IdentityType<class_1299>(class_1299.field_6077))) {
                    try {
                        class_1299 e = baseVillager.create((class_1937)client.field_1687);
                        this.renderEntities.put(baseVillager, (class_1309)e);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isVillagerEntry(IdentityType<?> t) {
        return t.getEntityType() == class_1299.field_6077 && t.getVariantData() >= 1000000;
    }

    private void populateEntities(class_746 player, List<IdentityType<?>> list) {
        int perRow = 7;
        int marginX = 15;
        boolean startY = false;
        class_1041 win = this.field_22787.method_22683();
        float cellW = ((float)win.method_4486() - 30.0f) / 7.0f;
        float cellH = (float)win.method_4502() / 5.0f;
        IdentityType<class_1309> current = IdentityType.from(PlayerIdentity.getIdentity((class_1657)player));
        ArrayList invalid = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            IdentityType<?> type = list.get(i);
            int xIdx = i % 7;
            int yIdx = i / 7;
            int x = 15 + Math.round(cellW * (float)xIdx);
            int y = 0 + Math.round(cellH * (float)yIdx);
            boolean isCurr = current != null && current.equals(type);
            boolean fav = PlayerFavorites.has((class_1657)player, type);
            try {
                EntityWidget<class_1309> widget = new EntityWidget<class_1309>(x, y, Math.round(cellW), Math.round(cellH), type, this.renderEntities.get(type), this, fav, isCurr);
                this.method_37063((class_364)widget);
                this.entityWidgets.add(widget);
                continue;
            }
            catch (Exception e) {
                Identity.LOGGER.warn("Failed to add identity " + type.getEntityType().method_5882(), (Throwable)e);
                invalid.add(type);
            }
        }
        if (!invalid.isEmpty()) {
            this.unlocked.removeAll(invalid);
            this.renderEntities.keySet().removeAll(invalid);
        }
    }

    private int getHeaderHeight() {
        return this.searchBar.method_46427() + this.searchBar.method_25364() + 5;
    }

    public void method_25394(class_332 ctx, int mx, int my, float delta) {
        this.method_25420(ctx);
        this.renderEntityGrid(ctx, mx, my, delta);
        if (this.unlocked.isEmpty()) {
            String hint = class_2561.method_43471((String)"identity.menu_hint").getString();
            int w = this.field_22787.field_1772.method_1727(hint);
            int x = (this.field_22787.method_22683().method_4480() - w) / 2;
            int y = this.field_22787.method_22683().method_4507() / 2;
            ctx.method_51433(this.field_22787.field_1772, hint, x, y, 0xFFFFFF, true);
        }
        this.searchBar.method_25394(ctx, mx, my, delta);
        this.playerButton.method_25394(ctx, mx, my, delta);
        this.helpButton.method_25394(ctx, mx, my, delta);
    }

    private void renderEntityGrid(class_332 ctx, int mx, int my, float delta) {
        double sf = this.field_22787.method_22683().method_4495();
        int headerH = this.getHeaderHeight();
        int viewH = this.field_22790 - headerH;
        int scrollTop = this.scrollY;
        int scrollBot = this.scrollY + viewH;
        RenderSystem.enableScissor((int)0, (int)((int)((double)headerH * sf)), (int)((int)((double)this.field_22789 * sf)), (int)((int)((double)viewH * sf)));
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(0.0f, (float)(headerH - this.scrollY), 0.0f);
        for (EntityWidget w : this.entityWidgets) {
            int wh;
            int wy = w.method_46427();
            if (wy + (wh = w.method_25364()) < scrollTop || wy > scrollBot) continue;
            w.method_25394(ctx, mx, my + this.scrollY - headerH, delta);
        }
        ctx.method_51448().method_22909();
        RenderSystem.disableScissor();
        for (EntityWidget w : this.entityWidgets) {
            if (!w.method_25405(mx, my + this.scrollY - headerH)) continue;
            ctx.method_51438(this.field_22787.field_1772, w.getHoverName(), mx, my);
            break;
        }
    }

    public double getEffectiveGuiScale() {
        int raw = (Integer)this.field_22787.field_1690.method_42474().method_41753();
        return raw == 0 ? this.field_22787.method_22683().method_4495() : (double)raw;
    }

    public boolean method_25401(double mx, double my, double amount) {
        if (this.entityWidgets.isEmpty()) {
            return false;
        }
        int rowH = this.entityWidgets.get(0).method_25364();
        int rows = (int)Math.ceil((float)this.unlocked.size() / 7.0f);
        int totalH = rows * rowH;
        int viewH = this.field_22790 - this.getHeaderHeight();
        int bottomPadding = 10;
        int maxY = Math.max(0, totalH - viewH + bottomPadding);
        this.scrollY = Math.max(0, Math.min(this.scrollY - (int)(amount * (double)rowH), maxY));
        return true;
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.method_37067();
        this.scrollY = 0;
        class_746 player = client.field_1724;
        if (player != null) {
            this.renderEntities.clear();
            this.villagerNames.clear();
            this.loadEntities(client);
            this.unlocked.clear();
            this.unlocked.addAll(this.renderEntities.keySet().stream().filter(t -> PlayerUnlocks.has((class_1657)player, t) || player.method_7337() || this.isVillagerEntry((IdentityType<?>)t)).collect(Collectors.toList()));
            this.unlocked.sort((a, b) -> PlayerFavorites.has((class_1657)player, a) ? -1 : 1);
            this.populateEntities(player, this.unlocked);
        }
    }

    public boolean method_25402(double mx, double my, int button) {
        int hh = this.getHeaderHeight();
        if (my >= (double)hh) {
            double adjY = my + (double)this.scrollY - (double)hh;
            for (EntityWidget w : this.entityWidgets) {
                if (!w.method_25402(mx, adjY, button)) continue;
                return true;
            }
        }
        if (my < (double)hh) {
            return this.searchBar.method_25402(mx, my, button) || this.playerButton.method_25402(mx, my, button) || this.helpButton.method_25402(mx, my, button);
        }
        return super.method_25402(mx, my, button);
    }

    public void method_25419() {
        this.entityWidgets.forEach(EntityWidget::dispose);
        super.method_25419();
    }

    public void method_37067() {
        ((ScreenAccessor)((Object)this)).getSelectables().removeIf(w -> w instanceof EntityWidget);
        this.method_25396().removeIf(w -> w instanceof EntityWidget);
        this.entityWidgets.clear();
        this.scrollY = 0;
    }

    public boolean method_25421() {
        return false;
    }

    public void disableAll() {
        for (EntityWidget w : this.entityWidgets) {
            w.setActive(false);
        }
    }

    private SearchWidget createSearchBar() {
        assert (this.field_22787 != null);
        float w = (float)this.field_22787.method_22683().method_4486() / 4.0f;
        return new SearchWidget((float)this.field_22787.method_22683().method_4486() / 2.0f - w / 2.0f, 5.0f, w, 20.0f);
    }

    private PlayerWidget createPlayerButton() {
        assert (this.field_22787 != null);
        float cx = (float)this.field_22787.method_22683().method_4486() / 2.0f;
        return new PlayerWidget(cx + (float)this.field_22787.method_22683().method_4486() / 8.0f + 5.0f, 7.0f, 15.0f, 15.0f, this);
    }

    private class_4185 createHelpButton() {
        assert (this.field_22787 != null);
        float cx = (float)this.field_22787.method_22683().method_4486() / 2.0f;
        return new HelpWidget((int)(cx - (float)this.field_22787.method_22683().method_4486() / 8.0f - 5.0f) - 30, 5, 20, 20);
    }

    public int getGuiScale() {
        assert (this.field_22787 != null);
        return (Integer)this.field_22787.field_1690.method_42474().method_41753();
    }
}

