/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.screen.widget;

import draylar.identity.Identity;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.network.impl.FavoritePackets;
import draylar.identity.network.impl.SwapPackets;
import draylar.identity.screen.IdentityScreen;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_490;
import net.minecraft.class_6382;
import net.minecraft.class_7919;

public class EntityWidget<T extends class_1309>
extends class_4264 {
    public static int VERTICAL_OFFSET = 30;
    private static int BASE_Y_OFFSET = 10;
    private IdentityType<T> type;
    private T entity;
    private int size;
    private boolean active;
    private boolean starred;
    private IdentityScreen parent;

    public EntityWidget(int x, int y, int width, int height, IdentityType<T> type, T entity, IdentityScreen parent, boolean starred, boolean current) {
        super(x, y, width, height, class_2561.method_30163((String)""));
        this.type = type;
        this.entity = entity;
        this.parent = parent;
        this.starred = starred;
        this.active = current;
        float baseSizeFactor = 25.0f / Math.max(entity.method_17681(), entity.method_17682());
        double scaleFactor = parent.getScaleFactor();
        int guiScale = parent.getGuiScale();
        double finalScale = scaleFactor / (double)(guiScale == 0 ? 1 : guiScale);
        this.size = Math.max(1, (int)((double)baseSizeFactor * finalScale));
        entity.method_5834(true);
        this.method_47400(class_7919.method_47407((class_2561)entity.method_5476()));
    }

    protected void method_47399(class_6382 builder) {
    }

    public boolean method_25402(double mx, double my, int button) {
        boolean hit;
        boolean bl = hit = mx >= (double)this.method_46426() && mx < (double)(this.method_46426() + this.method_25368()) && my >= (double)this.method_46427() && my < (double)(this.method_46427() + this.method_25364());
        if (hit) {
            if (button == 0) {
                SwapPackets.sendSwapRequest(this.type);
                this.parent.disableAll();
                this.active = true;
            } else if (button == 1) {
                this.starred = !this.starred;
                FavoritePackets.sendFavoriteRequest(this.type, this.starred);
            }
        }
        return super.method_25402(mx, my, button);
    }

    public class_2561 getHoverName() {
        return this.entity.method_5476();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        int rawGui = this.parent.getGuiScale();
        int clampedGui = rawGui == 0 ? 3 : Math.min(rawGui, 5);
        float baseSizePerBlock = 25.0f / Math.max(this.entity.method_17681(), this.entity.method_17682());
        double windowScale = this.parent.getScaleFactor();
        double effectiveScale = windowScale / (double)clampedGui;
        int size = Math.max(1, (int)((double)baseSizePerBlock * effectiveScale));
        int pixelHeight = (int)(this.entity.method_17682() * (float)size);
        int slotCX = this.method_46426() + this.method_25368() / 2;
        int slotCY = this.method_46427() + this.method_25364() / 2;
        int bottomY = slotCY + pixelHeight / 2;
        try {
            class_490.method_2486((class_332)ctx, (int)slotCX, (int)bottomY, (int)size, (float)-10.0f, (float)-10.0f, this.entity);
        }
        catch (Exception e) {
            Identity.LOGGER.warn("Failed to render " + this.type.getEntityType().method_5882(), (Throwable)e);
        }
        if (this.starred) {
            ctx.method_25290(Identity.id("textures/gui/star.png"), this.method_46426(), this.method_46427(), 0.0f, 0.0f, 15, 15, 15, 15);
        }
        if (this.active) {
            ctx.method_25293(Identity.id("textures/gui/selected.png"), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 0.0f, 0.0f, 48, 32, 48, 32);
        }
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
    }

    public void method_25306() {
    }

    public void setActive(boolean a) {
        this.active = a;
    }

    public void dispose() {
        if (this.entity != null) {
            try {
                this.entity.method_31472();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.entity = null;
        }
        this.type = null;
        this.parent = null;
    }
}

