/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import draylar.identity.ability.AbilityRegistry;
import draylar.identity.api.IdentityTickHandlers;
import draylar.identity.api.PlayerFavorites;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.SafeTagManager;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.network.ServerNetworking;
import draylar.identity.network.impl.Payload;
import draylar.identity.network.impl.VillagerIdentitiesPackets;
import draylar.identity.registry.IdentityCommands;
import draylar.identity.registry.IdentityEntityTags;
import draylar.identity.registry.IdentityEventHandlers;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identity {
    public static final String MODID = "identity";
    public static final Logger LOGGER = LoggerFactory.getLogger(Identity.class);

    public void initialize() {
        IdentityEntityTags.init();
        AbilityRegistry.init();
        IdentityEventHandlers.initialize();
        IdentityCommands.init();
        ServerNetworking.initialize();
        ServerNetworking.registerUseAbilityPacketHandler();
        Identity.registerJoinSyncPacket();
        IdentityTickHandlers.initialize();
        LifecycleEvent.SERVER_STARTING.register(server -> SafeTagManager.loadAll(server));
    }

    public static void registerJoinSyncPacket() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            class_2540 packet = new class_2540(Unpooled.buffer());
            packet.method_52964(IdentityConfig.getInstance().enableClientSwapMenu());
            packet.method_52964(IdentityConfig.getInstance().showPlayerNametag());
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new Payload.ConfigSyncPayload(IdentityConfig.getInstance().enableClientSwapMenu(), IdentityConfig.getInstance().showPlayerNametag()));
            PlayerUnlocks.sync(player);
            PlayerFavorites.sync(player);
            VillagerIdentitiesPackets.sendSync(player);
        });
    }

    public static class_2960 id(String name) {
        return class_2960.method_60655((String)MODID, (String)name);
    }

    public static boolean hasFlyingPermissions(class_3222 player) {
        boolean hasPermission = false;
        class_1309 identity = PlayerIdentity.getIdentity((class_1657)player);
        if (identity == null) {
            return hasPermission;
        }
        return IdentityConfig.getInstance().enableFlight() && Identity.isAbleToFly(identity);
    }

    private static boolean isAbleToFly(class_1309 identity) {
        if (identity == null) {
            return false;
        }
        class_1299 type = identity.method_5864();
        class_2960 id = class_1299.method_5890((class_1299)type);
        String idString = id.toString();
        IdentityConfig config = IdentityConfig.getInstance();
        if (config.removedFlyingEntities().contains(idString)) {
            return false;
        }
        if (config.extraFlyingEntities().contains(idString)) {
            return true;
        }
        return type.method_20210(IdentityEntityTags.FLYING) || SafeTagManager.isCustomFlying(type);
    }

    public static boolean identity$isAquatic(class_1309 identity) {
        if (identity == null) {
            return false;
        }
        class_1299 type = identity.method_5864();
        class_2960 id = class_1299.method_5890((class_1299)type);
        String idString = id.toString();
        IdentityConfig config = IdentityConfig.getInstance();
        if (config.removedAquaticEntities().contains(idString)) {
            return false;
        }
        if (config.extraAquaticEntities().contains(idString)) {
            return true;
        }
        return type.method_20210(IdentityEntityTags.BREATHE_UNDERWATER) || SafeTagManager.isCustomBreatheUnderwater(type);
    }

    public static int getCooldown(class_1299<?> type) {
        String id = class_7923.field_41177.method_10221(type).toString();
        return IdentityConfig.getInstance().getAbilityCooldownMap().getOrDefault(id, 20);
    }
}

